<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: ColorPicker.php,v 1.1 2005/05/19 08:48:43 mpolk Exp $
| Color picker image.                                                   |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 
require_once("Colors.php"); 

$ColorValue = $_GET["Value"];
$ColorRGB = new ColorRGB($ColorValue);
$ColorHLS = new ColorHLS($ColorRGB);

$Img = imagecreatefrompng("images/ColorPicker.png");

$X0 = round($ColorHLS->H / HLSMAX * imagesx($Img));
$Y0 = round((1.0 - $ColorHLS->S / HLSMAX) * imagesy($Img));

$CrossColor = imagecolorallocate($Img, 0, 0, 0);
define("D1", 5); define("D2", 2);
imagefilledrectangle($Img, $X0 - D1 - D2, $Y0 - 1, $X0 - D2, $Y0 + 1, $CrossColor);
imagefilledrectangle($Img, $X0 + D2, $Y0 - 1, $X0 + D1 + D2, $Y0 + 1, $CrossColor);
imagefilledrectangle($Img, $X0 - 1, $Y0 - D1 - D2, $X0 + 1, $Y0 - D2, $CrossColor);
imagefilledrectangle($Img, $X0 - 1, $Y0 + D2, $X0 + 1, $Y0 + D1 + D2, $CrossColor);

header("Content-type: image/png");
header ("Pragma: no-cache");
header ("Expires: Fri, 12 Jan 2001 08:32:53 GMT");

imagepng($Img);
imagedestroy($Img);
?>