<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: ColorSelector.php,v 1.1 2005/05/19 08:48:43 mpolk Exp $
| Visual color selector.                                                |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 
require_once("Utils.php"); 
require_once("MainMenu.php"); 
require_once("Settings.php"); 
require_once("Colors.php"); 

define("PICKER_WIDTH", 175);
define("PICKER_HEIGHT", 184);

if ($_SERVER["REQUEST_METHOD"] == "GET") {
    if (empty($_GET["Name"]) || ! isset($_GET["Value"]) || empty($_GET["Descr"])) {
        Redirect(dirname($_SERVER["SCRIPT_NAME"])."/ChangeSettings.php");
        exit;
    }//if
    
    $ColorName = $_SESSION["ColorSel.Name"] = $_GET["Name"];
    $ColorValue = $_SESSION["ColorSel.Value"] = $_GET["Value"];
    $ColorDescr = $_SESSION["ColorSel.Descr"] = $_GET["Descr"];
} else {
    $ColorName = $_SESSION["ColorSel.Name"];
    $ColorValue = $_SESSION["ColorSel.Value"];
    $ColorDescr = $_SESSION["ColorSel.Descr"];
}//if

$ColorRGB = new ColorRGB($ColorValue);
$ColorHLS = new ColorHLS($ColorRGB);

if (isset($_POST["btnOk"])) {
    ChangeIntSetting($ColorName, $ColorValue);
    Redirect(dirname($_SERVER["SCRIPT_NAME"])."/ChangeSettings.php");
    exit;
}//if


if (isset($_POST["ColorPicker_x"])) {
    $ColorHLS->H = round($_POST["ColorPicker_x"] / PICKER_WIDTH * HLSMAX);
    $ColorHLS->S = round((1.0 - $_POST["ColorPicker_y"] / PICKER_HEIGHT) * HLSMAX);
    $ColorRGB->FromHLS($ColorHLS);
    $ColorValue = $_SESSION["ColorSel.Value"] = $ColorRGB->ToInt();
}//if


if (isset($_POST["BrightnessPicker_y"])) {
    $Y = $_POST["BrightnessPicker_y"] - 1;
    if ($Y < 0)
        $Y = 0;
    if ($Y > PICKER_HEIGHT - 2)
        $Y = PICKER_HEIGHT - 2;
    $ColorHLS->L = round((1.0 - $Y / (PICKER_HEIGHT - 2)) * HLSMAX);
    $ColorRGB->FromHLS($ColorHLS);
    $ColorValue = $_SESSION["ColorSel.Value"] = $ColorRGB->ToInt();
}//if

?>

<?= DTD ?>
<html>
<head>
<?php 
$Title = $ColorDescr;
include("PageHeader.php");
?>

<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="Fri, 12 Jan 2001 08:32:53 GMT">

<script type="text/javascript" language="JavaScript">
<!--
function btnCancel_onclick()
{
    location.href = "ChangeSettings.php";
}//btnCancel_onclick
-->
</script>

</head>
<body>
<form method="post">
<?php 
$HelpTopic = "ColorSelector";
include("PageTop.php");
?>
</form>

<?php
$MainMenu = new MainMenu();
$MainMenu->MakeHTML("Settings");

include("PageMiddle.php");
?>

<form method="post">
<table border="0" cellpadding="0" cellspacing="2">
<tr><td colspan="3">Select <?= strtolower($Title) ?>:</td></tr>
<tr>
<td valign="top">
    <input type="image" id="ColorPicker" name="ColorPicker" src="ColorPicker.php?Value=<?= $ColorValue ?>" border="0" align="left" style="cursor: crosshair;">
</td>
<td valign="top">
    <input type="image" id="BrightnessPicker" name="BrightnessPicker" src="ColorBrightnessPicker.php?Value=<?= $ColorValue ?>" border="0" align="left" style="cursor: crosshair;">
</td>
<td valign="top">
    <span style="border: 1px solid Black; background: <?= $ColorRGB->ToHTML() ?>;"><?= str_repeat("&nbsp;", 12) ?></span><br><br>
    R = <?= $ColorRGB->R ?><br>
    G = <?= $ColorRGB->G ?><br>
    B = <?= $ColorRGB->B ?><br><br>
    H = <?= $ColorHLS->H ?><br>
    L = <?= $ColorHLS->L ?><br>
    S = <?= $ColorHLS->S ?><br>
</td>
</tr>
<tr><td colspan="3" align="center">
    <input type="Submit" value="Ok" name="btnOk" id="btnOk">
    <input type="Button" value="Cancel" name="btnCancel" id="btnCancel" onclick="btnCancel_onclick()">
</td></tr>
</table>
</form>

<?php 
include("PageBottom.php");
?>
</body>
</html>
