<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: Colors.php,v 1.1 2005/05/19 08:48:43 mpolk Exp $
| Classes for color manipulation.                                       |
\----------------------------------------------------------------------*/

define("HLSMAX", 240);
define("RGBMAX", 255);
define("UNDEFINED", (HLSMAX*2) / 3);

function HueToRGB($n1, $n2, $hue)
{
    if ($hue < 0)
      $hue += HLSMAX;
    if ($hue > HLSMAX)
      $hue -= HLSMAX;

    if ($hue < (HLSMAX / 6))
      return $n1 + ((($n2 - $n1) * $hue + (HLSMAX / 12)) / (HLSMAX / 6));

    if ($hue < (HLSMAX / 2))
      return $n2;

    if ($hue < ((HLSMAX * 2) / 3))
      return $n1 + ((($n2 - $n1) * (((HLSMAX * 2) / 3) - $hue) + (HLSMAX / 12)) / (HLSMAX / 6));
      
    return $n1;
}//HueToRGB

class ColorRGB
{
    var $R, $G, $B;
    
    function ColorRGB($intRGB)
    {
        $this->R = ($intRGB & 0xFF0000) >> 16;
        $this->G = ($intRGB & 0xFF00) >> 8;
        $this->B = $intRGB & 0xFF;
    }//ctor
    
    function ToInt()
    {
        return ($this->R << 16) | ($this->G << 8) | $this->B;
    }//ToInt
    
    function ToHTML()
    {
        return sprintf("#%02X%02X%02X", $this->R, $this->G, $this->B);
    }//ToInt
    
    
    function FromHLS($ColorHLS)
    {
        if ($ColorHLS->S == 0) {
            $this->B = round(($ColorHLS->L * RGBMAX) / HLSMAX);
            $this->R = $this->B;
            $this->G = $this->B;
        } else {
            if ($ColorHLS->L <= (HLSMAX / 2))
                $Magic2 = ($ColorHLS->L * (HLSMAX + $ColorHLS->S) + (HLSMAX / 2)) / HLSMAX;
            else
                $Magic2 = $ColorHLS->L + $ColorHLS->S - 
                    (($ColorHLS->L * $ColorHLS->S) + (HLSMAX / 2)) / HLSMAX;
            $Magic1 = 2 * $ColorHLS->L - $Magic2;
            $this->R = round((HueToRGB($Magic1, $Magic2, $ColorHLS->H + (HLSMAX / 3)) * RGBMAX + 
                              (HLSMAX / 2)) / HLSMAX);
            $this->G = round((HueToRGB($Magic1, $Magic2, $ColorHLS->H) * RGBMAX + 
                              (HLSMAX / 2)) / HLSMAX);
            $this->B = round((HueToRGB($Magic1, $Magic2, $ColorHLS->H - (HLSMAX / 3)) * RGBMAX + 
                              (HLSMAX / 2)) / HLSMAX);
        }//if

        if ($this->R < 0)
            $this->R = 0;
        if ($this->R > RGBMAX)
            $this->R = RGBMAX;
        if ($this->G < 0)
            $this->G = 0;
        if ($this->G > RGBMAX)
            $this->G = RGBMAX;
        if ($this->B < 0)
            $this->B = 0;
        if ($this->B > RGBMAX)
            $this->B = RGBMAX;
    }//FromHLS
}//ColorRGB


class ColorHLS
{
    var $H, $L, $S;
    
    function ColorHLS($ColorRGB)
    {
        $cMax = max($ColorRGB->R, $ColorRGB->G, $ColorRGB->B);
        $cMin = min($ColorRGB->R, $ColorRGB->G, $ColorRGB->B);
        $this->L = round(((($cMax + $cMin) * HLSMAX) + RGBMAX) / (2 * RGBMAX));
        
        if ($cMax == $cMin) {
            $this->S = 0;
            $this->H = UNDEFINED;
        } else {
            if ($this->L <= (HLSMAX / 2))
                $this->S = round(((($cMax - $cMin) * HLSMAX) + (($cMax + $cMin)/2)) / 
                                 ($cMax + $cMin));
            else
                $this->S = round(((($cMax - $cMin) * HLSMAX) + ((2 * RGBMAX - $cMax - $cMin)/2)) /
                                 (2 * RGBMAX - $cMax - $cMin));
            $Rdelta = ((($cMax - $ColorRGB->R) * (HLSMAX / 6)) + (($cMax - $cMin)/2)) / 
                      ($cMax - $cMin);
            $Gdelta = ((($cMax - $ColorRGB->G) * (HLSMAX / 6)) + (($cMax - $cMin)/2)) / 
                      ($cMax - $cMin);
            $Bdelta = ((($cMax - $ColorRGB->B) * (HLSMAX / 6)) + (($cMax - $cMin)/2)) / 
                      ($cMax - $cMin);

            if ($ColorRGB->R == $cMax)
                $this->H = round($Bdelta - $Gdelta);
            elseif ($ColorRGB->G == $cMax)
                $this->H = round((HLSMAX / 3) + $Rdelta - $Bdelta);
            else
                $this->H = round(((2 * HLSMAX) / 3) + $Gdelta - $Rdelta );

            if ($this->H < 0)
                $this->H += HLSMAX;
            if ($this->H > HLSMAX)
                $this->H -= HLSMAX;
        }//if
        
        if ($this->S < 0)
            $this->S = 0;
        if ($this->S > HLSMAX)
            $this->S = HLSMAX;
        if ($this->L < 0)
            $this->L = 0;
        if ($this->L > HLSMAX)
            $this->L = HLSMAX;
    }//ctor
    
}//ColorHLS

?>