<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2.0.1
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: MainMenu.php,v 1.2 2005/11/07 09:25:10 mpolk Exp $
| Main menu (displayed in the left pane).                               |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 

class MainMenu {
    var $Items = array(
        "Status" => "index.php",
        "Settings" => "ChangeSettings.php",
        "Help" => "Help.php"
        );
        
    var $Subitems = array(
        "Help" => array(
            "Status page" => "Help.php?Topic=StatusPage",
            "Settings" => "Help.php?Topic=Settings",
            "Time graph" => "Help.php?Topic=TimeGraph",
            "Address graph" => "Help.php?Topic=AddressGraph",
            "Address filtering" => "Help.php?Topic=AddressFiltering",
            "Time navigation" => "Help.php?Topic=TimeNavigation"
            )
        );

    function MakeHTML($SelectedItem, $SelectedSubitem = null)
    {
        echo "<table class=\"main-menu\" cellspacing=\"0\">\n";

        foreach ($this->Items as $Item => $HRef) {
            if ($Item != $SelectedItem) {
                echo "<tr><td class=\"main-menu-item\" nowrap><a href=\"$HRef\">$Item</a></td></tr>\n";
                continue;
            }//if
            
            if (empty($SelectedSubitem))
                echo "<tr><td class=\"main-menu-sel-item\" nowrap>$Item</td></tr>\n";
            else
                echo "<tr><td class=\"main-menu-item\" nowrap><a href=\"$HRef\">$Item</a></td></tr>\n";
                
            if (isset($this->Subitems[$Item]))
                foreach ($this->Subitems[$Item] as $Subitem => $HRef) {
                    if (strtolower(str_replace(" ", "", $Subitem)) != 
                        strtolower(str_replace(" ", "", $SelectedSubitem)))
                        echo "<tr><td class=\"main-menu-subitem\" nowrap><a href=\"$HRef\">$Subitem</a></td></tr>\n";
                    else
                        echo "<tr><td class=\"main-menu-sel-subitem\" nowrap>$Subitem</td></tr>\n";
                }//foreach
        }//foreach

        echo "</table>\n";
    }//MakeHTML
}//MainMenu

?>