<?php
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2.0.1
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: Settings.php,v 1.2 2005/11/07 09:25:10 mpolk Exp $
| Class and functions for handling application settings.                |
\----------------------------------------------------------------------*/

require_once("Globals.php");

class Setting {
    var $Name, $IntValue, $CharValue;
    
    function Setting($Initializer) 
    {
        if (is_object($Initializer)) {
            $this->Name = $Initializer->Name;
            $this->IntValue = $Initializer->IntValue;
            $this->CharValue = $Initializer->CharValue;
        } else {
            $this->Name = $Initializer;
            $this->IntValue = 0;
            $this->CharValue = "";
        }//if
    }//ctor
}//Setting


function LoadSettings() {
    global $Settings, $DB;
    $Settings = array();
    
    foreach ($_SESSION as $SesVarName => $SesVarValue) {
        if (preg_match("/^Settings\\[([^\\]]+)\\]$/", $SesVarName, $Matches))
            $Settings[$Matches[1]] = unserialize($SesVarValue);
    }//foreach
    
    $DB = mysql_pconnect(DBSERVER, DBLOGIN, DBPASSWORD);
    mysql_select_db(DBNAME);
    
    $Result = mysql_query("SELECT * FROM Settings", $DB);
    while ($Row = mysql_fetch_object($Result))
        if (! isset($Settings[$Row->Name]))
            $Settings[$Row->Name] = new Setting($Row);
    
    mysql_free_result($Result);

}//LoadSettings


function GetIntSetting($Key, $Default) {
    global $Settings;
    if (isset($Settings[$Key]) && $Settings[$Key]->IntValue != NULL)
        return $Settings[$Key]->IntValue;
    else
        return $Default;
}//GetIntSetting


function GetCharSetting($Key, $Default) {
    global $Settings;
    if (isset($Settings[$Key]) && $Settings[$Key]->CharValue != NULL)
        return $Settings[$Key]->CharValue;
    else
        return $Default;
}//GetCharSetting


function GetTimeSetting($Key, $Default) {
    $T = GetIntSetting($Key, $Default);
    $U = GetCharSetting($Key, "seconds");
    if (strncasecmp($U, "mi", 2) == 0)
        $T *= 60;
    elseif (strncasecmp($U, "h", 1) == 0)
        $T *= 3600;
    elseif (strncasecmp($U, "d", 1) == 0)
        $T *= 86400;
    elseif (strncasecmp($U, "w", 1) == 0)
        $T *= 604800;
    elseif (strncasecmp($U, "mo", 2) == 0)
        $T *= 2592000;
    elseif (strncasecmp($U, "y", 1) == 0)
        $T *= 31536000;

    return $T;
}//GetTimeSetting


function ChangeIntSetting($Key, $Value)
{
    global $Settings;
    if (strncasecmp($Value, "0x", 2) == 0)
        $Value = intval(substr($Value, 2), 16);
    if (! isset($Settings[$Key]))
        $Settings[$Key] = new Setting($Key);
    $Settings[$Key]->IntValue = (int)$Value;
    $_SESSION["Settings[$Key]"] = serialize($Settings[$Key]);
}//ChangeIntSetting


function ChangeCharSetting($Key, $Value)
{
    global $Settings;
    if (! isset($Settings[$Key]))
        $Settings[$Key] = new Setting($Key);
    $Settings[$Key]->CharValue = (string)$Value;
    $_SESSION["Settings[$Key]"] = serialize($Settings[$Key]);
}//ChangeCharSetting


function SaveIntSetting($Key, $Value)
{
    if (strncasecmp($Value, "0x", 2) == 0)
        $Value = intval(substr($Value, 2), 16);
    ChangeIntSetting($Key, $Value);
    mysql_query("START TRANSACTION");
    mysql_query("UPDATE Settings SET IntValue = $Value WHERE Name = '$Key'");
    if (mysql_affected_rows() == 0)
        mysql_query("INSERT INTO Settings (Name, IntValue) VALUES ('$Key', $Value)");
    mysql_query("COMMIT");
}//SaveIntSetting


function SaveCharSetting($Key, $Value)
{
    ChangeCharSetting($Key, $Value);
    mysql_query("START TRANSACTION");
    mysql_query("UPDATE Settings SET CharValue = '$Value' WHERE Name = '$Key'");
    if (mysql_affected_rows() == 0)
        mysql_query("INSERT INTO Settings (Name, CharValue) VALUES ('$Key', '$Value')");
    mysql_query("COMMIT");
}//SaveCharSetting


// Setting keys and defaults
define("DAY_VIEW_GRID", "DayViewGrid");
define("DAY_VIEW_WINDOW", "DayViewWindow");
define("WEEK_VIEW_GRID", "WeekViewGrid");
define("WEEK_VIEW_WINDOW", "WeekViewWindow");
define("MONTH_VIEW_GRID", "MonthViewGrid");
define("MONTH_VIEW_WINDOW", "MonthViewWindow");
define("YEAR_VIEW_GRID", "YearViewGrid");
define("YEAR_VIEW_WINDOW", "YearViewWindow");

define("DEF_DAY_VIEW_GRID", 300);
define("DEF_DAY_VIEW_WINDOW", 201600);
define("DEF_WEEK_VIEW_GRID", 1800);
define("DEF_WEEK_VIEW_WINDOW", 2419200);
define("DEF_MONTH_VIEW_GRID", 7200);
define("DEF_MONTH_VIEW_WINDOW", 4233600);
define("DEF_YEAR_VIEW_GRID", 86400);
define("DEF_YEAR_VIEW_WINDOW", 63072000);

define("TIME_GRAPH_WIDTH", "TimeGraphWidth");
define("TIME_GRAPH_HEIGHT", "TimeGraphHeight");
define("ADDR_GRAPH_WIDTH", "AddrGraphWidth");
define("ADDR_GRAPH_HEIGHT", "AddrGraphHeight");
define("MAX_ADDR_GRAPH_WIDTH", "MaxAddrGraphWidth");

define("DEF_TIME_GRAPH_WIDTH", 600);
define("DEF_TIME_GRAPH_HEIGHT", 200);
define("DEF_ADDR_GRAPH_WIDTH", 600);
define("DEF_ADDR_GRAPH_HEIGHT", 400);
define("DEF_MAX_ADDR_GRAPH_WIDTH", 20000);

define("GRID_COLOR", "GridColor");
define("AXIS_COLOR", "AxisColor");
define("DEF_GRID_COLOR", 0x606060);
define("DEF_AXIS_COLOR", 0x000000);

define("TIME_GRAPH_DAY_BRIGHTNESS", "TimeGraphDayBrightness");
define("TIME_GRAPH_NIGHT_BRIGHTNESS", "TimeGraphNightBrightness");
define("TIME_GRAPH_WINTER_COLOR", "TimeGraphWinterColor");
define("TIME_GRAPH_SUMMER_COLOR", "TimeGraphSummerColor");
define("TIME_GRAPH_CURSOR_COLOR", "TimeGraphCursorColor");
define("TIME_GRAPH_SEL_COLOR", "TimeGraphSelColor");
define("ADDR_GRAPH_H_COLOR", "AddrGraphHColor");
define("ADDR_GRAPH_L_COLOR", "AddrGraphLColor");
define("ADDR_GRAPH_SEL_COLOR", "AddrGraphSelColor");

define("DEF_TIME_GRAPH_DAY_BRIGHTNESS", 255);
define("DEF_TIME_GRAPH_NIGHT_BRIGHTNESS", 128);
define("DEF_TIME_GRAPH_WINTER_COLOR", 0x548AEC);
define("DEF_TIME_GRAPH_SUMMER_COLOR", 0x37A600);
define("DEF_TIME_GRAPH_CURSOR_COLOR", 0xC00000);
define("DEF_TIME_GRAPH_SEL_COLOR", 0xFFFFD4);
define("DEF_ADDR_GRAPH_H_COLOR", 0xFFA500);
define("DEF_ADDR_GRAPH_L_COLOR", 0x00C060);
define("DEF_ADDR_GRAPH_SEL_COLOR", 0x006000);

?>
