<?php
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: TimeGraph.php,v 1.1 2005/05/19 08:48:44 mpolk Exp $
| Time-based graph generator.                                           |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 
require_once("Settings.php"); 
require_once("Utils.php"); 
require_once("TimeSelector.php"); 

if (empty($_GET["Type"]))
    $GraphType = "Day";
else
    $GraphType = $_GET["Type"];

LoadSettings();

// determine time limits
switch ($GraphType) {
case "Day":
    $TimeIncrSec = GetTimeSetting(DAY_VIEW_GRID, DEF_DAY_VIEW_GRID);
    break;
case "Week":
    $TimeIncrSec = GetTimeSetting(WEEK_VIEW_GRID, DEF_WEEK_VIEW_GRID);
    break;
case "Month":
    $TimeIncrSec = GetTimeSetting(MONTH_VIEW_GRID, DEF_MONTH_VIEW_GRID);
    break;
case "Year":
    $TimeIncrSec = GetTimeSetting(YEAR_VIEW_GRID, DEF_YEAR_VIEW_GRID);
    break;
}//switch

$Result = mysql_query("SELECT MIN(UNIX_TIMESTAMP(Time)), MAX(UNIX_TIMESTAMP(Time))
                       FROM ${GraphType}Readouts");
$Row = mysql_fetch_row($Result);
$TimeOfDay = gettimeofday();
$TZOffset = $TimeOfDay["minuteswest"] * 60 - $TimeOfDay["dsttime"] * 3600;
$TimeIncrMin = (int)($TimeIncrSec / 60);
$MinTime = (int)(($Row[0] - $TimeIncrSec - $TZOffset) / $TimeIncrSec) * 
           $TimeIncrSec + $TZOffset; 
$MaxTime = (int)(($Row[1] - $TZOffset) / $TimeIncrSec) * 
           $TimeIncrSec + $TZOffset;
$TimeRange = $MaxTime - $MinTime;
$TotalTimeIncrements = $TimeRange / $TimeIncrSec;
mysql_free_result($Result);

// fetch data
if (! empty($_SESSION["AddrFilterSQL"]))
    $AddrFilterSQL = $_SESSION["AddrFilterSQL"];
$Query = "SELECT UNIX_TIMESTAMP(Time) AS TimeStamp, ReadoutID, Age, 
              SUM(".$_SESSION["TrafficUnits"].") AS TotalTraffic, 
              Src1, Src2, Src3, Src4,
              Dst1, Dst2, Dst3, Dst4
          FROM ${GraphType}Readouts LEFT OUTER JOIN ${GraphType}Data 
              ON ${GraphType}Readouts.ID = ${GraphType}Data.ReadoutID";
if (! empty($AddrFilterSQL))
    $Query .= " WHERE ".$AddrFilterSQL.
                  " OR (Src1 = 0 AND Src2 = 0 AND Src3 = 0 AND Src4 = 0 AND
                        Dst1 = 0 AND Dst2 = 0 AND Dst3 = 0 AND Dst4 = 0)";
$Query .= " GROUP BY ReadoutID ORDER BY Time";
//echo $Query; exit;
$Result = mysql_query($Query);
$TotalReadouts = mysql_num_rows($Result);

// determine vertical image dimensions and sizes
$CharWidth = imagefontwidth(3);
$CharHeight = imagefontheight(3);
$TopMargin = 4;
$BottomMargin = $CharHeight;
$ImageHeight = GetIntSetting(TIME_GRAPH_HEIGHT, DEF_TIME_GRAPH_HEIGHT);

// determine traffic rate limit
$PrevTime = 0; $MaxRate = 10.0;
while ($Row = mysql_fetch_object($Result)) {
    $Age = $Row->Age * 60; $Time = $Row->TimeStamp;
    if (abs($Time - $Age - $PrevTime) <= 60)
        $Age = $Time - $PrevTime;
    $PrevTime = $Time;
    if ($Time > time())
        $Age -= $Time - time();
    if ($Age == 0)
        $Age = 60;
    $Rate = $Row->TotalTraffic / $Age;
    if ($Rate > $MaxRate)
        $MaxRate = $Rate;
}//while

$MaxRateLog = log10($MaxRate);
$MaxRateExp = (int)$MaxRateLog;
$MaxRateMantissa = pow(10.0, $MaxRateLog - $MaxRateExp);
if ($MaxRateMantissa <= 2.0) {
    $MaxRateMantissa = 2.0;
    $RateGrid = (int)(0.5 * pow(10.0, $MaxRateExp));
    $PixelsPerRateStep = (int)round(($ImageHeight - $TopMargin - $BottomMargin) / 4);
} elseif ($MaxRateMantissa <= 5.0) {
    $MaxRateMantissa = 5.0;
    $RateGrid = (int)(pow(10.0, $MaxRateExp));
    $PixelsPerRateStep = (int)round(($ImageHeight - $TopMargin - $BottomMargin) / 5);
} elseif ($MaxRateMantissa <= 8.0) {
    $MaxRateMantissa = 8.0;
    $RateGrid = (int)(2.0 * pow(10.0, $MaxRateExp));
    $PixelsPerRateStep = (int)round(($ImageHeight - $TopMargin - $BottomMargin) / 4);
} else {
    $MaxRateMantissa = 1.0;
    $RateGrid = (int)(2.0 * pow(10.0, $MaxRateExp));
    $PixelsPerRateStep = (int)round(($ImageHeight - $TopMargin - $BottomMargin) / 5);
    $MaxRateExp++;
}//if
$MaxRate = $MaxRateMantissa * pow(10.0, $MaxRateExp);
$RateScale = ($ImageHeight - $TopMargin - $BottomMargin) / $MaxRate;

// determine horizontal image dimensions and sizes
$LeftMargin = $CharWidth * (1 + $MaxRateExp);
$RightMargin = 0;
$ImageWidth = GetIntSetting(TIME_GRAPH_WIDTH, DEF_TIME_GRAPH_WIDTH);
$PixelsPerTimeIncr = (int)(($ImageWidth - $LeftMargin - $RightMargin) / 
                           $TotalTimeIncrements);
if ($PixelsPerTimeIncr > 2)
    $PixelsPerTimeIncr = 2;
elseif ($PixelsPerTimeIncr < 1) {
    $PixelsPerTimeIncr = 1;
    $ImageWidth = $PixelsPerTimeIncr * $TotalTimeIncrements + $LeftMargin + $RightMargin;
}//if
$TimeScale = $PixelsPerTimeIncr / $TimeIncrSec;
$OriginX = $LeftMargin;
$OriginY = $ImageHeight - $BottomMargin;

// save calculated values in session vars to make it available for other scripts
$_SESSION["${GraphType}GraphTmin"] = $MinTime;
$_SESSION["${GraphType}GraphXmin"] = $OriginX;
$_SESSION["${GraphType}GraphXmax"] = $ImageWidth - $RightMargin;
$_SESSION["${GraphType}GraphTimeScale"] = $TimeScale;

// start constructing the image
$Img     = imagecreate($ImageWidth, $ImageHeight);
$BgColor = imagecolorallocate($Img, 0xF5, 0xFF, 0xFA);
$TransColor = $BgColor;
//$TransColor = imagecolorallocatealpha($Img, 0xFF, 0xFF, 0xFF, 127);
imagefill($Img, 0, 0, $BgColor);

// fill a selection area
$SelColorRGB = GetIntSetting(TIME_GRAPH_SEL_COLOR, DEF_TIME_GRAPH_SEL_COLOR);
$SelColor = MakeColor($Img, $SelColorRGB);
$TimeSelector = new TimeSelector();
$x0 = $x1 = 0;
if ($TimeSelector->SelStart && $TimeSelector->SelEnd) {
    $x0 = $OriginX + ($TimeSelector->SelStart - $MinTime) * $TimeScale;
    $x1 = $OriginX + ($TimeSelector->SelEnd - $MinTime) * $TimeScale;
} elseif ($TimeSelector->SelStart) {
    $x0 = $OriginX + ($TimeSelector->SelStart - $MinTime) * $TimeScale;
    $x1 = $ImageWidth - $RightMargin;
} elseif ($TimeSelector->SelEnd) {
    $x0 = $OriginX;
    $x1 = $OriginX + ($TimeSelector->SelEnd - $MinTime) * $TimeScale;
}//if
if ($x0)
    imagefilledrectangle($Img, $x0, $TopMargin, $x1, $OriginY, $SelColor);

// Draw grid
$AxisColor = MakeColor($Img, GetIntSetting(AXIS_COLOR, DEF_AXIS_COLOR));
$GridColor = MakeColor($Img, GetIntSetting(GRID_COLOR, DEF_GRID_COLOR));
$DashedLineStyle = array($GridColor, $TransColor);
imagesetstyle($Img, $DashedLineStyle);

switch ($GraphType) {
case "Day":
    $PixelsPerMark = $PixelsPerTimeIncr * 60 / $TimeIncrMin;
    $DeltaT = 3600;
    break;
case "Week":
    $PixelsPerMark = $PixelsPerTimeIncr * 1440 / $TimeIncrMin;
    $DeltaT = 86400;
    break;
case "Month":
    $PixelsPerMark = $PixelsPerTimeIncr * 10080 / $TimeIncrMin;
    $DeltaT = 604800;
    break;
case "Year":
    $PixelsPerMark = $PixelsPerTimeIncr * 43200 / $TimeIncrMin;
    $DeltaT = /*2635200*/2592000;
    break;
}//switch

$t0 = ((int)(($MinTime + $DeltaT - 1) / $DeltaT)) * $DeltaT + $TZOffset % $DeltaT;
$x0 = $OriginX + ($t0 - $MinTime) * $TimeScale;
$XGridOrigin = $x0;
for ($i = 0, $t = $t0; $t < $MaxTime + $DeltaT; $i++) {
    $t = $t0 + $i * $DeltaT;
    $x = $x0 + $i * $PixelsPerMark;
    if (($i > 0 || $x > 0) && $GraphType == "Day")
        imageline($Img, $x, $OriginY, $x, $TopMargin, IMG_COLOR_STYLED);
    
    switch ($GraphType) {
    case "Day":
        $lt = localtime($t); $h = $lt[2];
        if ($PixelsPerMark > $CharWidth * 2 || $i % 2 == 0)
            imagestring($Img, 3, ($h >= 10) ? $x - $CharWidth : $x - $CharWidth / 2, 
                        $OriginY, $h, $AxisColor);
        break;
    case "Week":
        $d = strftime("%a", $t - $DeltaT / 2);
        if (($PixelsPerMark > $CharWidth * strlen($d) || $i % 2 == 0) && 
            $t >= $DeltaT / 2)
            imagestring($Img, 3, $x - strlen($d) * $CharWidth / 2 - $PixelsPerMark / 2, 
                        $OriginY, $d, $AxisColor);
        break;
    case "Month":
        $lt = localtime($t, 1);
        $t1 = mktime(0, 0, 0, $lt["tm_mon"] + 1, $lt["tm_mday"], $lt["tm_year"]) -
              ($lt["tm_wday"] - 1) * 86400;
        $d = strftime("%d%b", $t1);
        if (($PixelsPerMark > $CharWidth * strlen($d) || 
             $PixelsPerMark * 2 > $CharWidth * strlen($d) && $i % 2 == 0 || 
             $i % 4 == 0) && 
            $t >= $DeltaT / 2)
            imagestring($Img, 3, $x - strlen($d) * $CharWidth / 2 - $PixelsPerMark / 2, 
                        $OriginY, $d, $AxisColor);
        break;
    case "Year":
        $d = strftime("%b", $t - $DeltaT / 2);
        if (($PixelsPerMark > $CharWidth * strlen($d) || $i % 2 == 0) && 
            $t >= $DeltaT / 2)
            imagestring($Img, 3, $x - strlen($d) * $CharWidth / 2 - $PixelsPerMark / 2, 
                        $OriginY, $d, $AxisColor);
        break;
    }//switch
}//for

for ($i = 1; $r = $i * $RateGrid, $r <= $MaxRate; $i++) {
    $y = $OriginY - $i * $PixelsPerRateStep;
    imageline($Img, $OriginX, $y, $ImageWidth - $RightMargin, $y, IMG_COLOR_STYLED);
    imagestring($Img, 3, 0, $y, $r, $AxisColor);
}//for


// draw a time cursor under the graph (line and the upper arrow)
if ($TimeSelector->Cursor >= $MinTime && $TimeSelector->Cursor <= $MaxTime) {
    $TimeCursorColorRGB = GetIntSetting(TIME_GRAPH_CURSOR_COLOR, DEF_TIME_GRAPH_CURSOR_COLOR);
    $TimeCursorColor = MakeColor($Img, $TimeCursorColorRGB);
    $TimeCursorX = (int)round($OriginX + ($TimeSelector->Cursor - $MinTime) * $TimeScale);
    imageline($Img, $TimeCursorX, $OriginY, $TimeCursorX, $TopMargin, $TimeCursorColor);

    define("CURSOR_ARROW_HALF_WIDTH", 4); define("CURSOR_ARROW_HEIGHT", 8);
    $Arrow = array($TimeCursorX - CURSOR_ARROW_HALF_WIDTH, $TopMargin, 
                   $TimeCursorX, $TopMargin + CURSOR_ARROW_HEIGHT, 
                   $TimeCursorX + CURSOR_ARROW_HALF_WIDTH, $TopMargin);
    imagefilledpolygon($Img, $Arrow, 3, $TimeCursorColor);
    imagepolygon($Img, $Arrow, 3, $AxisColor);
}//if

// draw the graph itself
$WinterColorRGB = GetIntSetting(TIME_GRAPH_WINTER_COLOR, DEF_TIME_GRAPH_WINTER_COLOR);
$WinterColorR = ($WinterColorRGB & 0xFF0000) >> 16;
$WinterColorG = ($WinterColorRGB & 0xFF00) >> 8;
$WinterColorB = $WinterColorRGB & 0xFF;
$SummerColorRGB = GetIntSetting(TIME_GRAPH_SUMMER_COLOR, DEF_TIME_GRAPH_SUMMER_COLOR);
$SummerColorR = ($SummerColorRGB & 0xFF0000) >> 16;
$SummerColorG = ($SummerColorRGB & 0xFF00) >> 8;
$SummerColorB = $SummerColorRGB & 0xFF;
$DayBrightness = GetIntSetting(TIME_GRAPH_DAY_BRIGHTNESS, DEF_TIME_GRAPH_DAY_BRIGHTNESS);
$NightBrightness = GetIntSetting(TIME_GRAPH_NIGHT_BRIGHTNESS, DEF_TIME_GRAPH_NIGHT_BRIGHTNESS);
if ($TotalReadouts)
    mysql_data_seek($Result, 0);
$PrevTime = 0;
while ($Row = mysql_fetch_object($Result)) {
    $Age = $Row->Age * 60; $Time = $Row->TimeStamp;
    if (abs($Time - $Age - $PrevTime) <= 60)
        $Age = $Time - $PrevTime;
    $PrevTime = $Time;
    if ($Age == 0)
        $Age = 60;
    if ($Time > time())
        $Rate = $Row->TotalTraffic / ($Age - $Time + time());
    else
        $Rate = $Row->TotalTraffic / $Age;
    
    $x0 = $OriginX + (int)round(($Time - $MinTime - $Age) * $TimeScale);
    $x1 = $OriginX + (int)round(($Time - $MinTime) * $TimeScale) - 1;
    $y0 = $OriginY - (int)round($Rate * $RateScale);

    $lt = localtime($Time, 1);
    $NewYear = mktime(0, 0, 0, 1, 1, $lt["tm_year"]);
    $p1 = 0.5 * cos((float)($Time - $NewYear) / 15768000 * M_PI) + 0.5;
    $p2 = 1.0  - $p1;
    $q = ($DayBrightness + $NightBrightness) * 0.5 / 255 - 
         ($DayBrightness - $NightBrightness) * 0.5 / 255 * 
         cos(($Time - $Age / 2 - $TZOffset) % 86400 / 43200 * M_PI); 
    $R = (int)(round(($WinterColorR * $p1 + $SummerColorR * $p2) * $q)) >> 2 << 2;
    $G = (int)(round(($WinterColorG * $p1 + $SummerColorG * $p2) * $q)) >> 2 << 2;
    $B = (int)(round(($WinterColorB * $p1 + $SummerColorB * $p2) * $q)) >> 2 << 2;
    //$Color = imagecolorexact($Img, $R, $G, $B);
    //if ($Color == -1)
    //    $Color = imagecolorallocate($Img, $R, $G, $B);
    $Color = imagecolorresolve($Img, $R, $G, $B);
    
    imagefilledrectangle($Img, $x0, $y0, $x1, $OriginY, $Color);
    if ((($GraphType == "Year") && ($lt["tm_mday"] == 1)) ||
        (($GraphType == "Month") && ($lt["tm_wday"] == 1) && ($lt["tm_hour"] == 0)) ||
        (($GraphType == "Week") && ($lt["tm_hour"] == 0) && ($lt["tm_min"] == 0)) ||
        (($GraphType == "Day") && ($lt["tm_min"] == 0)))
    {
        if ($GraphType != "Day") {
            $DashedLineStyle = array($GridColor, $TransColor);
            imagesetstyle($Img, $DashedLineStyle);
            imageline($Img, $x1, $y0, $x1, $TopMargin, IMG_COLOR_STYLED);
        }//if
        $DashedLineStyle = array($GridColor, $Color);
        imagesetstyle($Img, $DashedLineStyle);
        imageline($Img, $x1, $OriginY, $x1, $y0, IMG_COLOR_STYLED);
    }//if
    
    // redraw a time mark if required (dashed)
    if (isset($TimeCursorX) && $TimeCursorX >= $x0 && $TimeCursorX <= $x1) {
        imagesetstyle($Img, array($Color, $Color, $TimeCursorColor));
        imageline($Img, $TimeCursorX, $y0, $TimeCursorX, $OriginY, IMG_COLOR_STYLED);
    }//if
}//while

// draw a time cursor over the graph (the lower arrow)
if ($TimeSelector->Cursor >= $MinTime && $TimeSelector->Cursor <= $MaxTime) {
    $Arrow = array($TimeCursorX, $OriginY - CURSOR_ARROW_HEIGHT, 
                   $TimeCursorX - CURSOR_ARROW_HALF_WIDTH, $OriginY, 
                   $TimeCursorX + CURSOR_ARROW_HALF_WIDTH, $OriginY);
    imagefilledpolygon($Img, $Arrow, 3, $TimeCursorColor);
    imagepolygon($Img, $Arrow, 3, $AxisColor);
}//if

// Draw axes
imageline($Img, $OriginX, $OriginY, $ImageWidth - $RightMargin, $OriginY, $AxisColor);
imageline($Img, $OriginX, $OriginY, $OriginX, $TopMargin, $AxisColor);

// print a brief explanation
imagestring($Img, 3, $OriginX + $CharWidth, $TopMargin, 
            $TotalReadouts." readouts, ".date("Y/m/d G:i", $MinTime)." - ".
                                         date("Y/m/d G:i", $MaxTime), 
            $GridColor);

// at last output image and destroy it
header("Content-type: image/png");
imagepng($Img);
imagedestroy($Img);
?>