<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: TimeSelector.php,v 1.1 2005/05/19 08:48:45 mpolk Exp $
| Class implementing time interval selection by functionality.          |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 
require_once("Utils.php"); 
require_once("Settings.php"); 

class TimeSelector {
    var $SelEnd = 0, $SelStart = 0, $Cursor = 0;
    
    function TimeSelector()
    {
        if (isset($_SESSION["TimeSelectorCursor"]))
            $this->Cursor = $_SESSION["TimeSelectorCursor"];
        if (isset($_SESSION["TimeSelectorSelStart"]))
            $this->SelStart = $_SESSION["TimeSelectorSelStart"];
        if (isset($_SESSION["TimeSelectorSelEnd"]))
            $this->SelEnd = $_SESSION["TimeSelectorSelEnd"];
    }//ctor
    

    function SetCursor($T)
    {
        $this->Cursor = (int)$T;
        $_SESSION["TimeSelectorCursor"] = $this->Cursor;
    }//SetCursor
    

    function SetSelStart($T)
    {
        $this->SelStart = (int)$T;
        $_SESSION["TimeSelectorSelStart"] = $this->SelStart;
    }//SetSelStart
    

    function SetSelEnd($T)
    {
        $this->SelEnd = (int)$T;
        $_SESSION["TimeSelectorSelEnd"] = $this->SelEnd;
    }//SetSelStart
    
    
    function SelectionNotEmpty()
    {
        return ($this->SelEnd > $this->SelStart) || $this->SelStart || $this->SelEnd;
    }//SelectionNotEmpty


    function MakeHTML()
    {
        if ($this->Cursor == 0) {
            $Cursor = strftime("%Y/%m/%d %H:%M");
        } else {
            $Cursor = strftime("%Y/%m/%d %H:%M", $this->Cursor);
        }//if
?>
<!-- Time selector subpane -->
<fieldset>
<legend>Time</legend>
<label for="TimeCursor">Cursor: </label>
<input type="Text" class="input" name="TimeCursor" id="TimeCursor" size="16" title="Click on any of the time graphs to move time cursor" value="<?= $Cursor ?>">
<?php if ($this->Cursor) { ?>
<input type="Submit" name="ReleaseTimeCursor" id="ReleaseTimeCursor" class="button" value="Release" title="Release time cursor so it can move freely with the time flow">
<?php } else { ?>
(running)
<?php }//if ?>
<input type="Submit" name="SetTimeCursor" id="SetTimeCursor" class="button" value="Set" title="Set time cursor to the entered value">
<span style="white-space: pre;">  </span>

<label for="TimeSelStart">Selection start: </label>
<?php
        if ($this->Cursor) { ?>
<input type="Submit" name="TimeCursorToSelStart" id="TimeCursorToSelStart" class="button" value="=&gt;" title="Set selection start from the current cursor position">
<?php   } else { ?>
<span class="disabled-button">=&gt;</span>
<?php
        }//if
?>
<input type="Text" class="input" name="TimeSelStart" id="TimeSelStart" size="16" value="<?= $this->SelStart ? strftime("%Y/%m/%d %H:%M", $this->SelStart) : "" ?>">
<input type="Submit" name="SetTimeSelStart" id="SetTimeSelStart" class="button" value="Set" title="Set selection start to the entered value">
<?php
        if ($this->SelStart) {
?>
<input type="Submit" name="UnsetTimeSelStart" id="UnsetTimeSelStart" class="button" value="Unset" title="Unset selection start">
<?php
        }//if
?>
<span style="white-space: pre;">  </span>

<label for="TimeSelEnd">end: </label>
<?php
        if ($this->Cursor) { ?>
<input type="Submit" name="TimeCursorToSelEnd" id="TimeCursorToSelEnd" class="button" value="=&gt;" title="Set selection end from the current cursor position">
<?php   } else { ?>
<span class="disabled-button">=&gt;</span>
<?php
        }//if
?>
<input type="Text" class="input" name="TimeSelEnd" id="TimeSelEnd" size="16" value="<?= $this->SelEnd ? strftime("%Y/%m/%d %H:%M", $this->SelEnd) : "" ?>">
<input type="Submit" name="SetTimeSelEnd" id="SetTimeSelEnd" class="button" value="Set" title="Set selection end to the entered value">
<?php
        if ($this->SelEnd) {
?>
<input type="Submit" name="UnsetTimeSelEnd" id="UnsetTimeSelEnd" class="button" value="Unset" title="Unset selection start">
<?php
        }//if
?>
</fieldset>
<?php
    }//MakeHTML
    
    
    function ProcessFormInput()
    {
        global $Alert;
        
        if (isset($_POST["SetTimeCursor"])) {
            $T = strtotime($_POST["TimeCursor"]);
            if ($T < 0) {
                $T = 0;
                $Alert = "Invalid time value in the cursor field!";
            }//if
            $this->SetCursor($T);
            return;
        }//if

        if (isset($_POST["ReleaseTimeCursor"])) {
            $this->Cursor = 0;
            unset($_SESSION["TimeSelectorCursor"]);
            return;
        }//if

        if (isset($_POST["TimeCursorToSelStart"])) {
            $this->SetSelStart($this->Cursor);
            return;
        }//if
        
        if (isset($_POST["SetTimeSelStart"])) {
            if (empty($_POST["TimeSelStart"]))
                $T = -1;
            else
                $T = strtotime($_POST["TimeSelStart"]);
            if ($T < 0) {
                $T = 0;
                $Alert = "Invalid time value in the selection start field!";
            }//if
            $this->SetSelStart($T);
            return;
        }//if

        if (isset($_POST["UnsetTimeSelStart"])) {
            $this->SelStart = 0;
            unset($_SESSION["TimeSelectorSelStart"]);
            return;
        }//if

        if (isset($_POST["TimeCursorToSelEnd"])) {
            $this->SetSelEnd($this->Cursor);
            return;
        }//if

        if (isset($_POST["SetTimeSelEnd"])) {
            if (empty($_POST["TimeSelEnd"]))
                $T = -1;
            else
                $T = strtotime($_POST["TimeSelEnd"]);
            if ($T < 0) {
                $T = 0;
                $Alert = "Invalid time value in the selection end field!";
            }//if
            $this->SetSelEnd($T);
            return;
        }//if

        if (isset($_POST["UnsetTimeSelEnd"])) {
            $this->SelEnd = 0;
            unset($_SESSION["TimeSelectorSelEnd"]);
            return;
        }//if
    }//ProcessFormInput
    

    function TimeConditionSQL()
    {
        if ($this->SelStart && $this->SelEnd)
            return "(Time - INTERVAL SECOND(Time) SECOND >= '".
                     strftime("%Y-%m-%d %H:%M:00", $this->SelStart)."' AND ".
                   " Time - INTERVAL Age MINUTE <= '".
                     strftime("%Y-%m-%d %H:%M:00", $this->SelEnd)."')";
        elseif ($this->SelStart)
            return "(Time - INTERVAL SECOND(Time) SECOND - INTERVAL SECOND(Time) SECOND >= '".
                     strftime("%Y-%m-%d %H:%M:00", $this->SelStart)."')";
        elseif ($this->SelEnd)
            return "(Time - INTERVAL SECOND(Time) SECOND - INTERVAL Age MINUTE <= '".
                     strftime("%Y-%m-%d %H:%M:00", $this->SelEnd)."')";
        elseif ($this->Cursor)
            return "(Time - INTERVAL SECOND(Time) SECOND <= '".
                     strftime("%Y-%m-%d %H:%M:00", $this->Cursor)."')";
        else
            return "";
    }//TimeConditionSQL
    

    function RateExpressionSQL($MinTime, $MaxTime)
    {
        if ($this->SelStart && $this->SelEnd) {
            $Interval = $this->SelEnd - $this->SelStart;
            if ($Interval <= 0)
                return "0";
            $Start = strftime("%Y-%m-%d %H:%M:00", $this->SelStart);
            $End = strftime("%Y-%m-%d %H:%M:00", $this->SelEnd);
            return "SUM(".$_SESSION["TrafficUnits"]." * ".
                       "(IF(Time <= '$End', UNIX_TIMESTAMP(Time), $this->SelEnd) - ".
                        "IF(Time - INTERVAL Age MINUTE >= '$Start', ".
                           "UNIX_TIMESTAMP(Time) - Age * 60, ".
                           "$this->SelStart)) / (Age * 60)) / $Interval";
        } elseif ($this->SelStart) {
            $Interval = $MaxTime - $this->SelStart;
            if ($Interval <= 0)
                return "0";
            $Start = strftime("%Y-%m-%d %H:%M:00", $this->SelStart);
            return "SUM(IF(Time - INTERVAL Age MINUTE >= '$Start', ".
                          $_SESSION["TrafficUnits"].", ".
                          $_SESSION["TrafficUnits"]." * (UNIX_TIMESTAMP(Time) - $this->SelStart) / (Age * 60))) ".
                   "/ $Interval";
        } elseif ($this->SelEnd) {
            $Interval = $this->SelEnd - $MinTime;
            if ($Interval <= 0)
                return "0";
            $End = strftime("%Y-%m-%d %H:%M:00", $this->SelEnd);
            return "SUM(IF(Time <= '$End', ".
                          $_SESSION["TrafficUnits"].", ".
                          $_SESSION["TrafficUnits"]." * (1 - (UNIX_TIMESTAMP(Time) - $this->SelEnd) / (Age * 60)))) ".
                   "/ $Interval";
        } else
            return "SUM(".$_SESSION["TrafficUnits"].") / Age";
    }//RateExpressionSQL
}//TimeSelector

?>
