<?php
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: Utils.php,v 1.1 2005/05/19 08:48:45 mpolk Exp $
| General-purpose utulity functions.                                    |
\----------------------------------------------------------------------*/

// Modifying HREF to ensure that it contains session ID (if cookies are disabled)
function AppendSID($HRef) {
    if (SID && ! strstr($HRef, SID)) {
        if (strstr($HRef, '?'))
            $HRef .= "&".SID;
        else
            $HRef .= "?".SID;
    }//if
    return $HRef;
}//AppendSID

// Redirection to another page
function Redirect($PageToRedirect) {
    $Path = $_SERVER["HTTP_HOST"].$PageToRedirect;
    
    $Path = AppendSID($Path);
    $Path = preg_replace("|[\w\-]+/\.\.|", "", $Path);
    $Path = str_replace("//", "/", $Path);
    header ("Location: http://".$Path);
    exit();
}//Redirect

// Generating page auto-refresh directives
function AutoRefresh($Interval) {
?>
<meta http-equiv="Refresh" content="<?= $Interval ?>">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="Fri, 12 Jan 2001 08:32:53 GMT">
<?php
}//AutoRefresh

// Making color (allocating in the palette) from the single RGB value
function MakeColor($Image, $RGB)
{
    return imagecolorallocate($Image, 
                              ($RGB & 0xFF0000) >> 16, 
                              ($RGB & 0xFF00) >> 8,
                              $RGB & 0xFF);
}//MakeColor
 
?>
