#!/bin/sh
#-------------------------------------------------------#
#                    IPAcco 0.2                      #
# $Id: install.bash,v 1.3 2005/05/23 11:19:19 mpolk Exp $
#                   Installer script                    #
#-------------------------------------------------------#

Version="0.2"
INSTALL="install -b -S .saved -v -p"

echo
echo "This script will install IPAcco $Version (or at least will try to do it)."
while true ; do
    read -n 1 -p "Do you want to continue? (Y/n) "
    echo
    case $REPLY in
    "" | y | Y) echo; break;;
    n | N) echo; exit;;
    *) echo -n -e \\a;;
    esac
done

# Initialize variables with the default values
if [ -z $ExecDir ]; then ExecDir="/usr/sbin" ; fi
if [ -z $DocDir ]; then DocDir="/usr/share/doc/ipacco-$Version" ; fi
if [ -z $HtmlDir ]; then HtmlDir="/var/www/html/ipacco" ; fi
if [ -z $ConfDir ]; then ConfDir="/etc/ipacco" ; fi

# Ask where to install IPAcco
AskForPath() {
    if read -e -p "$1 [${!2}] "; then
	if [ "$REPLY" != "" ]; then
	    $2=$REPLY
	fi
    fi
} #AskForPath

AskForPath "Where to install IPAcco executable(s)?" ExecDir
AskForPath "Where to install IPAcco configuration file(s)?" ConfDir
AskForPath "Where to install IPAcco HTML and PHP files?" HtmlDir
AskForPath "Where to install IPAcco documentation files?" DocDir

# Copying files to the destination dirs
echo Copying files...
$INSTALL -o root -g root -m 755 -d $ExecDir
$INSTALL -o root -g root -m 755 -d $ConfDir
$INSTALL -o root -g root -m 755 -d $HtmlDir
$INSTALL -o root -g root -m 755 -d $HtmlDir/help
$INSTALL -o root -g root -m 755 -d $HtmlDir/images
$INSTALL -o root -g root -m 755 -d $DocDir

$INSTALL -o root -g root -m 744 ./datapump/ipacco-datapump.tcl $ExecDir
$INSTALL -o root -g root -m 600 ./datapump/ipacco-datapump.cfg $ConfDir

ProcessDir() {
    for F in `ls $1` ; do
	if [ -f $1/$F ]; then
	    $INSTALL -o $2 -g $3 -m $4 $1/$F $5$6
	else
	    ProcessDir $1/$F $2 $3 $4 $5 $6/$F
	fi
    done
} #ProcessDir

ProcessDir ./html root root 644 $HtmlDir
chmod 600 $HtmlDir/SiteDefs.php
ProcessDir ./doc root root 644 $DocDir

$INSTALL -o root -g root -m 644 LICENSE $DocDir
$INSTALL -o root -g root -m 644 README.txt $DocDir
$INSTALL -o root -g root -m 644 README.pdf $DocDir
$INSTALL -o root -g root -m 644 README.html $DocDir
$INSTALL -o root -g root -m 644 CreateDB.sql $DocDir

echo
echo IPAcco files copied to the locations where they can be used.
echo Ok, next.
echo

# Installing ipacco-datapump
echo ipacco-datapump is a script that collects accounting data
echo from the router. It may be either run continously as a daemon 
echo or scheduled for periodic run with cron. The first method is
echo recommended.


InstallSysVInitScript=n
if [ -d /etc/rc.d/init.d ]; then
    echo
    echo Since your system seems to use SystemV-style init, the installer
    echo can try to install ipacco-datapump as a daemon.
    echo
    while true ; do
	read -n 1 -p "Do you want it to do this? (Y/n) "
	echo
	case $REPLY in
	"" | y | Y) InstallSysVInitScript=y; echo; break;;
	n | N) echo; break;;
	*) echo -n -e \\a;;
	esac
    done
    
    if [ $InstallSysVInitScript == y ]; then
	sed -e "s-@EXECDIR@-$ExecDir-; s-@CONFDIR@-$ConfDir-" \
	    sysvinit/ipacco.in > /etc/rc.d/init.d/ipacco
	touch -r sysvinit/ipacco.in /etc/rc.d/init.d/ipacco
	chown root:root /etc/rc.d/init.d/ipacco
	chmod u=rwx,go=r /etc/rc.d/init.d/ipacco
	
        if which chkconfig > /dev/null 2>&1; then
            if chkconfig --add ipacco; then
                echo ipacco-datapump successfully installed as a daemon.
            else
                echo Start/stop script for ipacco-datapump copied to SysVInit directory.
                echo However \"chkconfig\" utility failed, so you should make
                echo runlevel symlinks to this script manually.
            fi
        else
            echo Start/stop script for ipacco-datapump copied to SysVInit directory.
            echo However \"chkconfig\" utility cannot be found, so you should make
            echo runlevel symlinks to this script manually.
        fi
    fi
else
    echo
    echo But since your system does not seem to use SystemV-style init,
    echo the installer does not know how to install ipacco-datapump as daemon.
    echo You can either do it yourself manually or use the second method.
fi


if [ $InstallSysVInitScript == y ]; then
    ScheduleWithCron=n
    ValidReplies="y/N"
else
    ScheduleWithCron=y
    ValidReplies="Y/n"
fi

echo
while true ; do
    read -n 1 -p "Do you want to schedule ipacco-datapump with cron? ($ValidReplies) "
    echo
    case $REPLY in
    y | Y) ScheduleWithCron=y; echo; break;;
    n | N) ScheduleWithCron=n; echo; break;;
    "") echo; break;;
    *) echo -n -e \\a;;
    esac
done

if [ $ScheduleWithCron == y ]; then
    sed -e "s-@EXECDIR@-$ExecDir-; s-@CONFDIR@-$ConfDir-" \
	cron.d/ipacco.in > /etc/cron.d/ipacco
    touch -r cron.d/ipacco.in /etc/cron.d/ipacco
    chown root:root /etc/cron.d/ipacco
    chmod u=rw,go=r /etc/cron.d/ipacco
    echo
    echo A cron schedule file for ipacco-datapump installed.
fi

echo
echo IPAcco 0.2 installation completed.
echo Next you should create IPAcco database using script \"CreateDB.sql\"
echo and optionally tune IPAcco configuration settings.