/*
    Copyright (C) 2004  Frank W. Josellis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.

*/

/* strpdate.c
 *
 * Takes a date string together with a corresponding format string and 
 * converts the given date to seconds since the epoch, using strptime(3).
 */ 

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

void usage(prog)
     char *prog;
{
  fprintf(stderr,"Usage: %s -f fmt date\n", prog);
  exit(1);
}

int main(argc, argv)
     int argc;
     char **argv;
{
  int opt;
  char *fmt = NULL;
  struct tm lt;

  while((opt = getopt(argc, argv, "hf:")) != -1){
    switch(opt){
    case 'f':
      fmt = optarg;
      break;
    case 'h':
    default:
      usage(argv[0]);
    }
  }

  if(!fmt || !argv[optind]) usage(argv[0]);

  lt.tm_isdst = -1;
  if(!strptime(argv[optind], fmt, &lt)){
    fprintf(stderr,"Date conversion failed.\n");
    exit(1);
  }
  printf("%d\n", (int) mktime(&lt));
  
  return(0);
}
