/**
 * Copyright 2003 Wayne Schroeder
 * Released under the GPL version 2
 */

extern "C" {
#include <pcap.h>
}
#include <hash_map>

/* from the sgi stl docs exampe */
struct eqstr
{
	bool operator()(const char* s1, const char* s2) const
	{
		return strcmp(s1, s2) == 0;
	}
};

typedef struct {
	unsigned long totalBytes;
	struct timeval firstPacketTime;
	struct timeval lastPacketTime;
} StreamStats;

typedef hash_map< char *, StreamStats *, hash< const char *>, eqstr > StreamStatsHash;

typedef struct {
	unsigned long totalBytes;
	StreamStatsHash * streamStats;
} Stats;

typedef struct {
	char dmac[6];
	char smac[6];
	u_int16_t type;
} ethernet_header_t;

typedef struct {
	unsigned char version;
	char dsf;
	u_int16_t length;
	u_int16_t id;
	char ff[2];
	unsigned char ttl;
	unsigned char protocol;
	u_int16_t header_checksum;
	u_int32_t sip;
	u_int32_t dip;
} ip_header_t;


