/*
 * ----------------------------------------------------------------
 * Night Light Asynchrounous DNS Resolver
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (06.01.2001)
 *
 */

#ifdef ARES_QUERY_H
#warning "ares_query.h already included."
#else
#define ARES_QUERY_H

/* FUNCTION PROTOTYPES - JONAS (05.07.2000) */

void ares_query_add(const unsigned long int Class, const unsigned long int Type, const char *NamePT, const unsigned long int Addr, const unsigned long int AddrLen, Ares_Callback Callback, void *ArgPT);
signed short int ares_mkquery(const char *NamePT, signed long int Class, signed long int Type, unsigned short ID, signed long int RD, unsigned char **BufferPT, signed long int *BufferLenPT);
void ares_query_server(struct Ares_Query_Struct *Ares_Query);
void ares_query_send(struct Ares_Query_Struct *Query);
void ares_query_callback(struct Ares_Query_Struct *Query, const unsigned short int Result);
void ares_query_rem(struct Ares_Query_Struct *Query);
void ares_query_init(struct Ares_Query_Struct *Query);

#endif
