/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Channel User System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (31.07.2001)
 *
 */

#ifdef CHAN_USER_H
#warning "chan_user.h already included."
#else
#define CHAN_USER_H

struct Conn_Struct;
struct Chan_Struct;

/* BIT MASKS - JONAS (24.06.2000) */

#define CHANUSER_OP			1
#define CHANUSER_VOICE			2
#define CHANUSER_CREATOR		4

#define CHANUSER_WHO			1
#define CHANUSER_AWAY			2
#define CHANUSER_IRCOP			4
#define CHANUSER_SENTVOICE		8
#define CHANUSER_SENTDEVOICE		16
#define CHANUSER_SENTOP			32
#define CHANUSER_SENTDEOP		64
#define CHANUSER_SENTKICK		128
#define CHANUSER_BANCHECK		256

/* MACROS - JONAS (24.06.2000) */

#define ChanUser_SetOP(x)		((x)->ModeFlags |= CHANUSER_OP)
#define ChanUser_SetVoice(x)		((x)->ModeFlags |= CHANUSER_VOICE)
#define ChanUser_SetCreator(x)		((x)->ModeFlags |= CHANUSER_CREATOR)

#define ChanUser_ClearOP(x)		((x)->ModeFlags &= ~CHANUSER_OP)
#define ChanUser_ClearVoice(x)		((x)->ModeFlags &= ~CHANUSER_VOICE)
#define ChanUser_ClearCreator(x)	((x)->ModeFlags &= ~CHANUSER_CREATOR)

#define ChanUser_IsOP(x)		((x)->ModeFlags & CHANUSER_OP)
#define ChanUser_IsVoice(x)		((x)->ModeFlags & CHANUSER_VOICE)
#define ChanUser_IsCreator(x)		((x)->ModeFlags & CHANUSER_CREATOR)


#define ChanUser_SetWho(x)		((x)->Flags |= CHANUSER_WHO)
#define ChanUser_SetAway(x)		((x)->Flags |= CHANUSER_AWAY)
#define ChanUser_SetIRCop(x)		((x)->Flags |= CHANUSER_IRCOP)
#define ChanUser_SetSentVoice(x)	((x)->Flags |= CHANUSER_SENTVOICE)
#define ChanUser_SetSentDeVoice(x)	((x)->Flags |= CHANUSER_SENTDEVOICE)
#define ChanUser_SetSentOP(x)		((x)->Flags |= CHANUSER_SENTOP)
#define ChanUser_SetSentDeOP(x)		((x)->Flags |= CHANUSER_SENTDEOP)
#define ChanUser_SetSentKick(x)		((x)->Flags |= CHANUSER_SENTKICK)
#define ChanUser_SetBanCheck(x)		((x)->Flags |= CHANUSER_BANCHECK)

#define ChanUser_ClearWho(x)		((x)->Flags &= ~CHANUSER_WHO)
#define ChanUser_ClearAway(x)		((x)->Flags &= ~CHANUSER_AWAY)
#define ChanUser_ClearIRCop(x)		((x)->Flags &= ~CHANUSER_IRCOP)
#define ChanUser_ClearSentVoice(x)	((x)->Flags &= ~CHANUSER_SENTVOICE)
#define ChanUser_ClearSentDeVoice(x)	((x)->Flags &= ~CHANUSER_SENTDEVOICE)
#define ChanUser_ClearSentOP(x)		((x)->Flags &= ~CHANUSER_SENTOP)
#define ChanUser_ClearSentDeOP(x)	((x)->Flags &= ~CHANUSER_SENTDEOP)
#define ChanUser_ClearSentKick(x)	((x)->Flags &= ~CHANUSER_SENTKICK)
#define ChanUser_ClearBanCheck(x)	((x)->Flags &= ~CHANUSER_BANCHECK)

#define ChanUser_IsWho(x)		((x)->Flags & CHANUSER_WHO)
#define ChanUser_IsAway(x)		((x)->Flags & CHANUSER_AWAY)
#define ChanUser_IsIRCop(x)		((x)->Flags & CHANUSER_IRCOP)
#define ChanUser_IsSentVoice(x)		((x)->Flags & CHANUSER_SENTVOICE)
#define ChanUser_IsSentDeVoice(x)	((x)->Flags & CHANUSER_SENTDEVOICE)
#define ChanUser_IsSentOP(x)		((x)->Flags & CHANUSER_SENTOP)
#define ChanUser_IsSentDeOP(x)		((x)->Flags & CHANUSER_SENTDEOP)
#define ChanUser_IsSentKick(x)		((x)->Flags & CHANUSER_SENTKICK)
#define ChanUser_IsBanCheck(x)		((x)->Flags & CHANUSER_BANCHECK)

/* STRUCTURES - JONAS (31.07.2001) */

struct ChanUser_Struct {

  char *Nick;
  char *User;
  char *Host;
  char *NUH;
  unsigned long int ModeFlags;
  unsigned long int Flags;
  time_t Time;

  struct ChanUser_Struct *Prev;
  struct ChanUser_Struct *Next;

  struct ChanUser_Struct *PrevH;
  struct ChanUser_Struct *NextH;

};

#ifdef CHAN_USER_C

#ifndef CHANUSER_HASHSIZE
  #error "CHANUSER_HASHSIZE not defined!"
#endif

/*
 * HASH TABLE DEFINES - JONAS (30.07.2001)
 *
 * Taken from ircu, www.coder-com.undernet.org
 * Copyright (C) 1998 Andrea Cocito
 *
 */

#define CHANUSER_HASHSTEP 1
#define CHANUSER_HASHSHIFT 257

#if !(CHANUSER_HASHSHIFT > (CHANUSER_HASHSTEP * (CHAR_MAX-CHAR_MIN)))
  #error "Please make CHANUSER_HASHSHIFT a bigger prime!"
#endif
#if ((CHANUSER_HASHSIZE % CHANUSER_HASHSHIFT) == 0)
  #error "Please set CHANUSER_HASHSIZE to something not multiple of CHANUSER_HASHSHIFT"
#endif

#undef CHANUSER_HASHMEMS
#undef CHANUSER_HASHREGS

#if ((!defined(CHANUSER_HASHMEMS)) && (CHANUSER_HASHSIZE < (SHRT_MAX-CHANUSER_HASHSHIFT)))
  #define CHANUSER_HASHMEMS short
  #define CHANUSER_HASHREGS int
#endif

#if ((!defined(CHANUSER_HASHMEMS)) && (CHANUSER_HASHSIZE < (USHRT_MAX-CHANUSER_HASHSHIFT)))
  #define CHANUSER_HASHMEMS unsigned short
  #define CHANUSER_HASHREGS unsigned int
#endif

#if ((!defined(CHANUSER_HASHMEMS)) && (CHANUSER_HASHSIZE < (INT_MAX-CHANUSER_HASHSHIFT)))
  #define CHANUSER_HASHMEMS int
  #define CHANUSER_HASHREGS int
#endif

#if ((!defined(CHANUSER_HASHMEMS)) && (CHANUSER_HASHSIZE < (UINT_MAX-CHANUSER_HASHSHIFT)))
  #define CHANUSER_HASHMEMS unsigned int
  #define CHANUSER_HASHREGS unsigned int
#endif

#if ((!defined(CHANUSER_HASHMEMS)) && (CHANUSER_HASHSIZE < (LONG_MAX-CHANUSER_HASHSHIFT)))
  #define CHANUSER_HASHMEMS long
  #define CHANUSER_HASHREGS long
#endif

#if ((!defined(CHANUSER_HASHMEMS)) && (CHANUSER_HASHSIZE < (ULONG_MAX-CHANUSER_HASHSHIFT)))
  #define CHANUSER_HASHMEMS unsigned long
  #define CHANUSER_HASHREGS unsigned long
#endif

#if (!defined(CHANUSER_HASHMEMS))
  #error "CHANUSER_HASHSIZE to big."
#endif

#define CHANUSER_HASHMAPSIZE (CHANUSER_HASHSIZE + CHANUSER_HASHSHIFT + 1)

#define ChanUser_Hash_Weight(ch) ChanUser_Hash_Weight_Table[ch-CHAR_MIN]
#define HASHEQ(x,y) ((tolower(x)) == (tolower(y)))

#endif

/* FUNCTION PROTOTYPES - JONAS (31.07.2001) */

struct ChanUser_Struct *chan_adduser(struct Conn_Struct *ConnS, struct Chan_Struct *ChanS, const char *const NickPT, const char *const UserPT, const char *const HostPT, const char *const NUHPT);
signed short int chan_changeuser(struct Conn_Struct *ConnS, struct Chan_Struct *ChanS, struct ChanUser_Struct *ChanUser, const char *const NickPT);
void chan_remuser(struct Conn_Struct *ConnS, struct Chan_Struct *ChanS, struct ChanUser_Struct *ChanUser);
struct ChanUser_Struct *chan_getuser(struct Conn_Struct *ConnS, struct Chan_Struct *ChanS, const char *const NickPT);
void chanuser_hash_init(void);
#ifdef CHAN_USER_C
  static CHANUSER_HASHREGS chanuser_strhash(const char *NickPT);
#endif
void chan_inituser(struct Conn_Struct *ConnS, struct Chan_Struct *ChanS, struct ChanUser_Struct *ChanUser);
void chan_remusers(struct Conn_Struct *ConnS, struct Chan_Struct *ChanS);

#endif
