/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Connection I/O System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (18.07.2001)
 *
 */

#ifdef CONN_IO_H
#warning "conn_io.h already included."
#else
#define CONN_IO_H

struct hostent;

/* DEFINES - JONAS (24.06.2000) */

#define CONN_INTERVAL					120
#define CONN_SOCKKEEPALIVEOPT				TRUE
#define CONN_CONNECTTIMEOUT				120
#define CONN_QUITTIMEOUT				5
#define CONN_IDLETIMEBEFOREPING				30
#define CONN_PINGTIMEOUT				1800
#define CONN_ISONTIME					30
#define CONN_IGNORENICKMASK				6
#define CONN_IGNOREUSERMASK				6
#define CONN_IGNOREHOSTMASK				1
#define CONN_IGNOREEXPIRETIME				240
#define CONN_IGNORETTL					240
#define CHAN_HASHSIZE					100
#define CHANUSER_HASHSIZE				10000

/* BIT MASKS - JONAS (24.06.2000) */

#define CONN_BITMASK_ATTACHED				1
#define CONN_BITMASK_REMOVE				2
#define CONN_BITMASK_LOGHOMEDIR				4

#define CONN_BITMASK_CONNECTPROC			1
#define CONN_BITMASK_SOCKET				2
#define CONN_BITMASK_SOCKOPT				4
#define CONN_BITMASK_KEEPALIVEOPT			8
#define CONN_BITMASK_BOUND				16
#define CONN_BITMASK_CONNECTING				32
#define CONN_BITMASK_CONNECTED				64
#define CONN_BITMASK_SOCKNAME				128
#define CONN_BITMASK_PEERNAME				256
#define CONN_BITMASK_WELCOME				512
#define CONN_BITMASK_AWAY				1024
#define CONN_BITMASK_SENTNICK				2048
#define CONN_BITMASK_SENTAWAYNICK			4096
#define CONN_BITMASK_SENTPING				8192
#define CONN_BITMASK_SENTISON				16384
#define CONN_BITMASK_SENTQUIT				32768
#define CONN_BITMASK_AWAYNICK				65536


/* MACROS - JONAS (24.06.2000) */

#define Conn_SetAttached(x)				((x)->Flags |= CONN_BITMASK_ATTACHED)
#define Conn_SetRemove(x)				((x)->Flags |= CONN_BITMASK_REMOVE)
#define Conn_SetLogHomeDir(x)				((x)->Flags |= CONN_BITMASK_LOGHOMEDIR)
#define Conn_ClearAttached(x)				((x)->Flags &= ~CONN_BITMASK_ATTACHED)
#define Conn_ClearRemove(x)				((x)->Flags &= ~CONN_BITMASK_REMOVE)
#define Conn_ClearLogHomeDir(x)				((x)->Flags &= ~CONN_BITMASK_LOGHOMEDIR)
#define Conn_IsAttached(x)				((x)->Flags & CONN_BITMASK_ATTACHED)
#define Conn_IsRemove(x)				((x)->Flags & CONN_BITMASK_REMOVE)
#define Conn_IsLogHomeDir(x)				((x)->Flags & CONN_BITMASK_LOGHOMEDIR)

#define Conn_SetConnectProc(x)				((x)->ConnectionFlags |= CONN_BITMASK_CONNECTPROC)
#define Conn_SetSocket(x)				((x)->ConnectionFlags |= CONN_BITMASK_SOCKET)
#define Conn_SetSockOPT(x)				((x)->ConnectionFlags |= CONN_BITMASK_SOCKOPT)
#define Conn_SetKeepAliveOPT(x)				((x)->ConnectionFlags |= CONN_BITMASK_KEEPALIVEOPT)
#define Conn_SetBound(x)				((x)->ConnectionFlags |= CONN_BITMASK_BOUND)
#define Conn_SetConnecting(x)				((x)->ConnectionFlags |= CONN_BITMASK_CONNECTING)
#define Conn_SetConnected(x)				((x)->ConnectionFlags |= CONN_BITMASK_CONNECTED)
#define Conn_SetSockName(x)				((x)->ConnectionFlags |= CONN_BITMASK_SOCKNAME)
#define Conn_SetPeerName(x)				((x)->ConnectionFlags |= CONN_BITMASK_PEERNAME)
#define Conn_SetWelcome(x)				((x)->ConnectionFlags |= CONN_BITMASK_WELCOME)
#define Conn_SetAway(x)					((x)->ConnectionFlags |= CONN_BITMASK_AWAY)
#define Conn_SetSentNick(x)				((x)->ConnectionFlags |= CONN_BITMASK_SENTNICK)
#define Conn_SetSentAwayNick(x)				((x)->ConnectionFlags |= CONN_BITMASK_SENTAWAYNICK)
#define Conn_SetSentPing(x)				((x)->ConnectionFlags |= CONN_BITMASK_SENTPING)
#define Conn_SetSentISON(x)				((x)->ConnectionFlags |= CONN_BITMASK_SENTISON)
#define Conn_SetSentQuit(x)				((x)->ConnectionFlags |= CONN_BITMASK_SENTQUIT)
#define Conn_SetAwayNick(x)				((x)->ConnectionFlags |= CONN_BITMASK_AWAYNICK)

#define Conn_ClearConnectProc(x)			((x)->ConnectionFlags &= ~CONN_BITMASK_CONNECTPROC)
#define Conn_ClearSocket(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_SOCKET)
#define Conn_ClearSockOPT(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_SOCKOPT)
#define Conn_ClearKeepAliveOPT(x)			((x)->ConnectionFlags &= ~CONN_BITMASK_KEEPALIVEOPT)
#define Conn_ClearBound(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_BOUND)
#define Conn_ClearConnecting(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_CONNECTING)
#define Conn_ClearConnected(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_CONNECTED)
#define Conn_ClearSockName(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_SOCKNAME)
#define Conn_ClearPeerName(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_PEERNAME)
#define Conn_ClearWelcome(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_WELCOME)
#define Conn_ClearAway(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_AWAY)
#define Conn_ClearSentNick(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_SENTNICK)
#define Conn_ClearSentAwayNick(x)			((x)->ConnectionFlags &= ~CONN_BITMASK_SENTAWAYNICK)
#define Conn_ClearSentPing(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_SENTPING)
#define Conn_ClearSentISON(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_SENTISON)
#define Conn_ClearSentQuit(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_SENTQUIT)
#define Conn_ClearAwayNick(x)				((x)->ConnectionFlags &= ~CONN_BITMASK_AWAYNICK)

#define Conn_IsConnectProc(x)				((x)->ConnectionFlags & CONN_BITMASK_CONNECTPROC)
#define Conn_IsSocket(x)				((x)->ConnectionFlags & CONN_BITMASK_SOCKET)
#define Conn_IsSockOPT(x)				((x)->ConnectionFlags & CONN_BITMASK_SOCKOPT)
#define Conn_IsKeepAliveOPT(x)				((x)->ConnectionFlags & CONN_BITMASK_KEEPALIVEOPT)
#define Conn_IsBound(x)					((x)->ConnectionFlags & CONN_BITMASK_BOUND)
#define Conn_IsConnecting(x)				((x)->ConnectionFlags & CONN_BITMASK_CONNECTING)
#define Conn_IsConnected(x)				((x)->ConnectionFlags & CONN_BITMASK_CONNECTED)
#define Conn_IsSockName(x)				((x)->ConnectionFlags & CONN_BITMASK_SOCKNAME)
#define Conn_IsPeerName(x)				((x)->ConnectionFlags & CONN_BITMASK_PEERNAME)
#define Conn_IsWelcome(x)				((x)->ConnectionFlags & CONN_BITMASK_WELCOME)
#define Conn_IsAway(x)					((x)->ConnectionFlags & CONN_BITMASK_AWAY)
#define Conn_IsSentNick(x)				((x)->ConnectionFlags & CONN_BITMASK_SENTNICK)
#define Conn_IsSentAwayNick(x)				((x)->ConnectionFlags & CONN_BITMASK_SENTAWAYNICK)
#define Conn_IsSentPing(x)				((x)->ConnectionFlags & CONN_BITMASK_SENTPING)
#define Conn_IsSentISON(x)				((x)->ConnectionFlags & CONN_BITMASK_SENTISON)
#define Conn_IsSentQuit(x)				((x)->ConnectionFlags & CONN_BITMASK_SENTQUIT)
#define Conn_IsAwayNick(x)				((x)->ConnectionFlags & CONN_BITMASK_AWAYNICK)

#define Conn_IsConnect(x)				((x)->ConnectionFlags & (CONN_BITMASK_CONNECTING|CONN_BITMASK_CONNECTED))

/* STRUCTURES - JONAS (18.07.2001) */

struct Conn_Struct {

  char *Name;
  char *Nick;
  char *AwayNick;
  char *User;
  char *Host;
  char *Mode;
  char *Info;
  char *Chans;
  char *AwayMsg;
  char *PublicDetachMsg;
  char *PublicAttachMsg;
  unsigned short int AutoConnect;
  unsigned short int Logging;
  unsigned short int AutoAway;
  unsigned short int PublicAway;
  unsigned short int RegainNick;
  unsigned short int MaxClients;
  unsigned short int SendMaxLines;
  unsigned short int SendLineTime;
  unsigned short int SendMaxBuffer;
  unsigned short int SendBufferTime;

  unsigned short int NumServers;
  struct ConnServer_Struct *Server_Head;
  struct ConnServer_Struct *Server_Tail;


  unsigned long int Flags;
  char *FileName;
  unsigned short int NumClients;
  struct ConnServer_Struct *ConnServerTry;


  unsigned long int ResolveFlags;
  char *HostName;
  char *HostIPS;
  unsigned long int HostIPH;
  unsigned long long int HostIPN;
  unsigned long int PortH;
  unsigned long int PortN;

  unsigned long int ServerResolveFlags;
  char *ServerHostName;
  char *ServerHostIPS;
  unsigned long int ServerHostIPH;
  unsigned long long int ServerHostIPN;
  unsigned long int ServerPortH;
  unsigned long int ServerPortN;

  unsigned long long int ConnectionFlags;
  signed long int FD;
  char *ServerName;
  char *IRCNick;
  char *Welcome[5];
  char **ISupport;
  unsigned short int ISupportLines;
  unsigned short int NumSendQs;
  struct SendQ_Struct *SendQ_Head;
  unsigned short int NumFlushLs;
  unsigned long int SendQMaxFlushLines;
  struct FlushL_Struct *FlushL_Head;
  struct FlushL_Struct *FlushL_Tail;
  unsigned short int NumFlushBs;
  unsigned long int SendQMaxFlushBuffer;
  struct FlushB_Struct *FlushB_Head;
  struct FlushB_Struct *FlushB_Tail;
  char *RecvBuffer;
  char *SendBuffer;
  unsigned short int NicksIndex;
  time_t ConnectProcTime;
  time_t ConnectTime;
  time_t ConnectedTime;
  time_t SentPingTime;
  time_t SentQuitTime;
  time_t LastRecvTime;
  time_t IgnoreExpireTime;
  time_t SentISONTime;

  unsigned short int NumChans;
  struct Chan_Struct *Chan_Head;
  struct Chan_Struct *Chan_Tail;
  struct Chan_Struct *Chan_Table[CHAN_HASHSIZE];

  unsigned short int NumIgnores;
  struct Ignore_Struct *Ignore_Head;
  struct Ignore_Struct *Ignore_Tail;

  struct Conn_Struct *Prev;
  struct Conn_Struct *Next;

};

struct ConnServer_Struct {

  char *Host;
  unsigned long int Port;
  char *Pass;

  unsigned short int Tries;

  struct ConnServer_Struct *Prev;
  struct ConnServer_Struct *Next;

};

/* FUNCTION PROTOTYPES - JONAS (18.07.2001) */

struct Conn_Struct *conn_add(const char *const NamePT, const char *const NickPT, const char *const AwayNickPT, const char *const UserPT, const char *const HostPT, const char *const ModePT, const char *const InfoPT, const char *const ChansPT, const unsigned short int AutoConnect, const unsigned short int Logging, const unsigned short int AutoAway, const unsigned short int PublicAway, const unsigned short int RegainNick, const unsigned short int MaxClients, const unsigned short int SendMaxLines, const unsigned short int SendLineTime, const unsigned short int SendMaxBuffer, const unsigned short int SendBufferTime, const char *const AwayMsgPT, const char *const PublicDetachMsgPT, const char *const PublicAttachMsgPT);
void conn_rem(struct Conn_Struct *ConnS);
struct Conn_Struct *conn_get(const char *const NamePT);
struct ConnServer_Struct *conn_addserver(struct Conn_Struct *ConnS, const char *const HostPT, const unsigned long int Port, const char *const PassPT);
void conn_remserver(struct Conn_Struct *ConnS, struct ConnServer_Struct *ConnServer);
struct ConnServer_Struct *conn_getserver(struct Conn_Struct *ConnS, const char *const HostPT);
void conn_remservers(struct Conn_Struct *ConnS);
void conn_initconnection(struct Conn_Struct *ConnS);
void conn_connect(struct Conn_Struct *ConnS);
void conn_disconnect(struct Conn_Struct *ConnS, const char *const LinePT, ...) __attribute__ ((format (printf, 2, 3)));
void conn_hosttoip(void *ArgPT, unsigned short int ErrNo, struct hostent *HostEnt);
void conn_serverhosttoip(void *ArgPT, unsigned short int ErrNo, struct hostent *HostEnt);
void conn_logon(struct Conn_Struct *ConnS);
void conn_fds(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
void conn_io(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
void conn_recv(struct Conn_Struct *ConnS);
void conn_send(struct Conn_Struct *ConnS);
void conn_addsend(struct Conn_Struct *ConnS, const char *const LinePT);
void conn_quit(struct Conn_Struct *ConnS, const char *const MessagePT, ...) __attribute__ ((format (printf, 2, 3)));
unsigned short int conn_closeall(const char *const MessagePT, ...) __attribute__ ((format (printf, 1, 2)));

#endif
