/*
 * ----------------------------------------------------------------
 * Night Light File Descriptor Debugging Functions Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (02.07.2003)
 *
 */

#ifdef FDCALLS_H
#warning "fdcalls.h already included."
#else
#define FDCALLS_H

struct sockaddr;

#if !FDDEBUG
  #error "fdcalls.h included, but FDDEBUG not defined TRUE."
#endif

#define FDPTRZSTRLEN		10
#define FDBYTESTRLEN		4
#define FDFILESTRLEN		16
#define FDLINESTRLEN		4
#define FDTIMESTRLEN		10

#define FD_PRINT		FALSE
#define SOCKET_PRINT		FALSE

#ifndef FDCALLS_C
  #define SOCKET_REDEFINE
  #undef fopen
  #undef fclose
  #undef socket
  #undef close
  #undef accept
  #define fopen(p, m) openfd(__FILE__, __LINE__, __FUNCTION__, (p), (m))
  #define fclose(s) closefd(__FILE__, __LINE__, __FUNCTION__, (s))
  #define socket(d, t, p) opensock(__FILE__, __LINE__, __FUNCTION__, (d), (t), (p))
  #define close(s) closesock(__FILE__, __LINE__, __FUNCTION__, (s))
  #define accept(s, a, l) acceptsock(__FILE__, __LINE__, __FUNCTION__, s, a, l);
#endif


/* STRUCTURES - JONAS (21.06.2003) */

struct FDTable_Struct {

  FILE *FD;
  const char *File;
  unsigned short int Line;
  const char *Function;
  char *Path;
  char *Mode;
  time_t Time;

  struct FDTable_Struct *Prev;
  struct FDTable_Struct *Next;

};

struct SockTable_Struct {

  signed long int Socket;
  const char *File;
  unsigned short int Line;
  const char *Function;
  time_t Time;

  struct SockTable_Struct *Prev;
  struct SockTable_Struct *Next;

};

/* FUNCTION PROTOTYPES - JONAS (01.07.2003) */

void fdtable_add(FILE *FD, const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, const char *const PathPT, const char *const ModePT);
void fdtable_rem(struct FDTable_Struct *FDTableS);
struct FDTable_Struct *fdtable_get(const FILE *const FD);
void fdtable_clear(void);
FILE *openfd(const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, const char *const PathPT, const char *const ModePT);
signed short int closefd(const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, FILE *FD);
void socktable_add(signed long int Socket, const char *const FilePT, const unsigned short int Line, const char *const FunctionPT);
void socktable_rem(struct SockTable_Struct *SockTableS);
struct SockTable_Struct *socktable_get(signed long int Socket);
void socktable_clear(void);
#if NEED_SYS_SOCKET_H
  signed short int opensock(const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, signed short int Domain, signed short int Type, signed short int Protocol);
  signed short int acceptsock(const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, signed short int ListenSocket, struct sockaddr *SockAddr, accept_addrlen_type *SockAddrLen);
#endif
#if NEED_UNISTD_H
  signed short int closesock(const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, signed short int Socket);
#endif
void fd_print(void);

#endif
