/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Ident Connection System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (04.07.2003)
 *
 */

#ifdef IDENT_CONN_H
#warning "ident_conn.h already included."
#else
#define IDENT_CONN_H


/* DEFINES - JONAS (04.07.2003) */

#define IDENTCONN_TIMEOUT			45

/* BIT MASKS - JONAS (04.07.2003) */

#define IDENTCONN_SOCKET			1

/* MACROS - JONAS (04.07.2003) */

#define IdentConn_SetSocket(x)			((x)->Flags |= IDENTCONN_SOCKET)
#define IdentConn_ClearSocket(x)		((x)->Flags &= ~IDENTCONN_SOCKET)
#define IdentConn_IsSocket(x)			((x)->Flags & IDENTCONN_SOCKET)

/* STRUCTURES - JONAS (04.07.2003) */

struct IdentConn_Struct {

  unsigned long int Flags;

  char *HostIPS;
  unsigned long int HostIPH;
  unsigned long long int HostIPN;

  unsigned long int PortH;
  unsigned long int PortN;

  signed long int FD;

  char *RecvBuffer;
  char *SendBuffer;

  time_t Time;

  struct IdentConn_Struct *Prev;
  struct IdentConn_Struct *Next;

};

/* FUNCTION PROTOTYPES - JONAS (04.07.2003) */

struct IdentConn_Struct *ident_conn_add(const char *const HostIPSPT, unsigned long int HostIPH, unsigned long int HostIPN, unsigned long int PortH, unsigned long int PortN, signed long int FD);
void ident_conn_rem(struct IdentConn_Struct *IdentConnS);
void ident_conn_initconnection(struct IdentConn_Struct *IdentConnS);
void ident_conn_disconnect(struct IdentConn_Struct *IdentConnS);
void ident_conn_fds(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
void ident_conn_io(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
void ident_conn_recv(struct IdentConn_Struct *IdentConnS);
void ident_conn_send(struct IdentConn_Struct *IdentConnS);
void ident_conn_addsend(struct IdentConn_Struct *IdentConnS, const char *const LinePT, ...) __attribute__ ((format (printf, 2, 3)));
void ident_conn_parse(struct IdentConn_Struct *IdentConnS);
void ident_conn_parse_message(struct IdentConn_Struct *IdentConnS, char *MessagePT);
unsigned short int ident_conn_closeall(void);

#endif
