/*
 * ----------------------------------------------------------------
 * Night Light Internet Relat Chat Numerics (irc_numerics.h)
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (18.07.2001)
 *
 *
 */

#ifdef IRC_NUMERICS_H
#warning "irc_numerics.h already included."
#else
#define IRC_NUMERICS_H

#define	IRC_RFC1459_RPL_WELCOME					1				/* "Welcome to the Internet Relay Network <nick>!<user>@<host>" */
#define	IRC_RFC1459_RPL_YOURHOST				2				/* "Your host is <servername>, running version <ver>" */
#define IRC_RFC1459_RPL_CREATED					3				/* "This server was created <date>" */
#define IRC_RFC1459_RPL_MYINFO					4				/* "<servername> <version> <available user modes> <available channel modes>" */

#define IRC_RFC1459_ERR_NOSUCHNICK				401				/* "<nickname> :No such nick/channel" */
#define IRC_RFC1459_ERR_NOSUCHSERVER				402				/* "<server name> :No such server" */
#define IRC_RFC1459_ERR_NOSUCHCHANNEL				403				/* "<channel name> :No such channel" */
#define IRC_RFC1459_ERR_CANNOTSENDTOCHAN			404				/* "<channel name> :Cannot send to channel" */
#define IRC_RFC1459_ERR_TOOMANYCHANNELS				405				/* "<channel name> :You have joined too many channels" */
#define IRC_RFC1459_ERR_WASNOSUCHNICK				406				/* "<nickname> :There was no such nickname" */
#define IRC_RFC1459_ERR_TOOMANYTARGETS				407				/* "<target> :Duplicate recipients. No message delivered" */
#define IRC_RFC1459_ERR_NOORIGIN				409				/* ":No origin specified" */
#define IRC_RFC1459_ERR_NORECIPIENT				411				/* ":No recipient given (<command>)" */
#define IRC_RFC1459_ERR_NOTEXTTOSEND				412				/* ":No text to send" */
#define IRC_RFC1459_ERR_NOTOPLEVEL				413				/* "<mask> :No toplevel domain specified" */
#define IRC_RFC1459_ERR_WILDTOPLEVEL				414				/* "<mask> :Wildcard in toplevel domain" */
#define IRC_RFC1459_ERR_UNKNOWNCOMMAND				421				/* "<command> :Unknown command" */
#define IRC_RFC1459_ERR_NOMOTD					422				/* ":MOTD File is missing" */
#define IRC_RFC1459_ERR_NOADMININFO				423				/* "<server> :No administrative info available" */
#define IRC_RFC1459_ERR_FILEERROR				424				/* ":File error doing <file op> on <file>" */
#define IRC_RFC1459_ERR_NONICKNAMEGIVEN				431				/* ":No nickname given" */
#define IRC_RFC1459_ERR_ERRONEUSNICKNAME			432				/* "<nick> :Erroneus nickname" */
#define IRC_RFC1459_ERR_NICKNAMEINUSE				433				/* "<nick> :Nickname is already in use" */
#define IRC_RFC1459_ERR_NICKCOLLISION				436				/* "<nick> :Nickname collision KILL" */
#define IRC_RFC1459_ERR_USERNOTINCHANNEL			441				/* "<nick> <channel> :They aren't on that channel" */
#define IRC_RFC1459_ERR_NOTONCHANNEL				442				/* "<channel> :You're not on that channel" */
#define IRC_RFC1459_ERR_USERONCHANNEL				443				/* "<user> <channel> :is already on channel" */
#define IRC_RFC1459_ERR_NOLOGIN					444				/* "<user> :User not logged in" */
#define IRC_RFC1459_ERR_SUMMONDISABLED				445				/* ":SUMMON has been disabled" */
#define IRC_RFC1459_ERR_USERSDISABLED				446				/* ":USERS has been disabled" */
#define IRC_RFC1459_ERR_NOTREGISTERED				451				/* ":You have not registered" */
#define IRC_RFC1459_ERR_NEEDMOREPARAMS				461				/* "<command> :Not enough parameters" */
#define IRC_RFC1459_ERR_ALREADYREGISTRED			462				/* ":You may not reregister" */
#define IRC_RFC1459_ERR_NOPERMFORHOST				463				/* ":Your host isn't among the privileged" */
#define IRC_RFC1459_ERR_PASSWDMISMATCH				464				/* ":Password incorrect" */
#define IRC_RFC1459_ERR_YOUREBANNEDCREEP			465				/* ":You are banned from this server" */
#define IRC_RFC1459_ERR_KEYSET					467				/* "<channel> :Channel key already set" */
#define IRC_RFC1459_ERR_CHANNELISFULL				471				/* "<channel> :Cannot join channel (+l)" */
#define IRC_RFC1459_ERR_UNKNOWNMODE				472				/* "<char> :is unknown mode char to me" */
#define IRC_RFC1459_ERR_INVITEONLYCHAN				473				/* "<channel> :Cannot join channel (+i)" */
#define IRC_RFC1459_ERR_BANNEDFROMCHAN				474				/* "<channel> :Cannot join channel (+b)" */
#define IRC_RFC1459_ERR_BADCHANNELKEY				475				/* "<channel> :Cannot join channel (+k)" */
#define IRC_RFC1459_ERR_NOPRIVILEGES				481				/* ":Permission Denied- You're not an IRC operator" */
#define IRC_RFC1459_ERR_CHANOPRIVSNEEDED			482				/* "<channel> :You're not channel operator" */
#define IRC_RFC1459_ERR_CANTKILLSERVER				483				/* ":You cant kill a server!" */
#define IRC_RFC1459_ERR_NOOPERHOST				491				/* ":No O-lines for your host" */
#define IRC_RFC1459_ERR_UMODEUNKNOWNFLAG			501				/* ":Unknown MODE flag" */
#define IRC_RFC1459_ERR_USERSDONTMATCH				502				/* ":Cant change mode for other users" */
#define IRC_RFC1459_RPL_NONE					300				/* Dummy reply number. Not used. */
#define IRC_RFC1459_RPL_USERHOST				302				/* ":[<reply>{<space><reply>}]" */
#define IRC_RFC1459_RPL_ISON					303				/* ":[<nick> {<space><nick>}]" */
#define IRC_RFC1459_RPL_AWAY					301				/* "<nick> :<away message>" */
#define IRC_RFC1459_RPL_UNAWAY					305				/* ":You are no longer marked as being away" */
#define IRC_RFC1459_RPL_NOWAWAY					306				/* ":You have been marked as being away" */
#define IRC_RFC1459_RPL_WHOISUSER				311				/* "<nick> <user> <host> * :<real name>" */
#define IRC_RFC1459_RPL_WHOISSERVER				312				/* "<nick> <server> :<server info>" */
#define IRC_RFC1459_RPL_WHOISOPERATOR				313				/* "<nick> :is an IRC operator" */
#define IRC_RFC1459_RPL_WHOISIDLE				317				/* "<nick> <integer> :seconds idle" */
#define IRC_RFC1459_RPL_ENDOFWHOIS				318				/* "<nick> :End of /WHOIS list" */
#define IRC_RFC1459_RPL_WHOISCHANNELS				319				/* "<nick> :{[@|+]<channel><space>}" */
#define IRC_RFC1459_RPL_WHOWASUSER				314				/* "<nick> <user> <host> * :<real name>" */
#define IRC_RFC1459_RPL_ENDOFWHOWAS				369				/* "<nick> :End of WHOWAS" */
#define IRC_RFC1459_RPL_LISTSTART				321				/* "Channel :Users Name" */
#define IRC_RFC1459_RPL_LIST					322				/* "<channel> <# visible> :<topic>" */
#define IRC_RFC1459_RPL_LISTEND					323				/* ":End of /LIST" */
#define IRC_RFC1459_RPL_CHANNELMODEIS				324				/* "<channel> <mode> <mode params>" */
#define IRC_RFC1459_RPL_NOTOPIC					331				/* "<channel> :No topic is set" */
#define IRC_RFC1459_RPL_TOPIC					332				/* "<channel> :<topic>" */
#define IRC_RFC1459_RPL_INVITING				341				/* "<channel> <nick>" */
#define IRC_RFC1459_RPL_SUMMONING				342				/* "<user> :Summoning user to IRC" */
#define IRC_RFC1459_RPL_VERSION					351				/* "<version>.<debuglevel> <server> :<comments>" */
#define IRC_RFC1459_RPL_WHOREPLY				352				/* "<channel> <user> <host> <server> <nick> <H|G>[*][@|+] :<hopcount> <real name>" */
#define IRC_RFC1459_RPL_ENDOFWHO				315				/* "<name> :End of /WHO list" */
#define IRC_RFC1459_RPL_NAMEREPLY				353				/* "<channel> :[[@|+]<nick> [[@|+]<nick> [...]]]" */
#define IRC_RFC1459_RPL_ENDOFNAMES				366				/* "<channel> :End of /NAMES list" */
#define IRC_RFC1459_RPL_LINKS					364				/* "<mask> <server> :<hopcount> <server info>" */
#define IRC_RFC1459_RPL_ENDOFLINKS				365				/* "<mask> :End of /LINKS list" */
#define IRC_RFC1459_RPL_BANLIST					367				/* "<channel> <banid>" */
#define IRC_RFC1459_RPL_INFO					371				/* ":<string>" */
#define IRC_RFC1459_RPL_ENDOFINFO				374				/* ":End of /INFO list" */
#define IRC_RFC1459_RPL_MOTDSTART				375				/* ":- <server> Message of the day - " */
#define IRC_RFC1459_RPL_MOTD					372				/* ":- <text>" */
#define IRC_RFC1459_RPL_ENDOFMOTD				376				/* ":End of /MOTD command" */
#define IRC_RFC1459_RPL_YOUREOPER				381				/* ":You are now an IRC operator" */
#define IRC_RFC1459_RPL_REHASHING				382				/* "<config file> :Rehashing" */
#define IRC_RFC1459_RPL_TIME					391				/* "<server> :<string showing server's local time>" */
#define IRC_RFC1459_RPL_USERSSTART				392				/* ":UserID   Terminal  Host" */
#define IRC_RFC1459_RPL_USERS					393				/* ":%-8s %-9s %-8s" */
#define IRC_RFC1459_RPL_ENDOFUSERS				394				/* ":End of users" */
#define IRC_RFC1459_RPL_NOUSERS					395				/* ":Nobody logged in" */
#define IRC_RFC1459_RPL_TRACELINK				200				/* "Link <version & debug level> <destination> <next server>" */
#define IRC_RFC1459_RPL_TRACECONNECTING				201				/* "Try. <class> <server>" */
#define IRC_RFC1459_RPL_TRACEHANDSHAKE				202				/* "H.S. <class> <server>" */
#define IRC_RFC1459_RPL_TRACEUNKNOWN				203				/* "???? <class> [<client IP address in dot form>]" */
#define IRC_RFC1459_RPL_TRACEOPERATOR				204				/* "Oper <class> <nick>" */
#define IRC_RFC1459_RPL_TRACEUSER				205				/* "User <class> <nick>" */
#define IRC_RFC1459_RPL_TRACESERVER				206				/* "Serv <class> <int>S <int>C <server> <nick!user|*!*>@<host|server>" */
#define IRC_RFC1459_RPL_TRACENEWTYPE				208				/* "<newtype> 0 <client name>" */
#define IRC_RFC1459_RPL_TRACELOG				261				/* "File <logfile> <debug level>" */
#define IRC_RFC1459_RPL_STATSLINKINFO				211				/* <linkname> <sendq> <sent messages> <sent bytes> <received messages> <received bytes> <time open>" */
#define IRC_RFC1459_RPL_STATSCOMMANDS				212				/* "<command> <count>" */
#define IRC_RFC1459_RPL_STATSCLINE				213				/* "C <host> * <name> <port> <class>" */
#define IRC_RFC1459_RPL_STATSNLINE				214				/* "N <host> * <name> <port> <class>" */
#define IRC_RFC1459_RPL_STATSILINE				215				/* "I <host> * <host> <port> <class>" */
#define IRC_RFC1459_RPL_STATSKLINE				216				/* "K <host> * <username> <port> <class>" */
#define IRC_RFC1459_RPL_STATSYLINE				218				/* "Y <class> <ping frequency> <connect frequency> <max sendq>" */
#define IRC_RFC1459_RPL_ENDOFSTATS				219				/* "<stats letter> :End of /STATS report" */
#define IRC_RFC1459_RPL_STATSLLINE				241				/* "L <hostmask> * <servername> <maxdepth>" */
#define IRC_RFC1459_RPL_STATSUPTIME				242				/* ":Server Up %d days %d:%02d:%02d" */
#define IRC_RFC1459_RPL_STATSOLINE				243				/* "O <hostmask> * <name>" */
#define IRC_RFC1459_RPL_STATSHLINE				244				/* "H <hostmask> * <servername>" */
#define IRC_RFC1459_RPL_UMODEIS					221				/* "<user mode string>" */
#define IRC_RFC1459_RPL_LUSERCLIENT				251				/* ":There are <integer> users and <integer> invisible on <integer> servers" */
#define IRC_RFC1459_RPL_LUSEROP					252				/* "<integer> :operator(s) online" */
#define IRC_RFC1459_RPL_LUSERUNKNOWN				253				/* "<integer> :unknown connection(s)" */
#define IRC_RFC1459_RPL_LUSERCHANNELS				254				/* "<integer> :channels formed" */
#define IRC_RFC1459_RPL_LUSERME					255				/* ":I have <integer> clients and <integer> servers" */
#define IRC_RFC1459_RPL_ADMINME					256				/* "<server> :Administrative info" */
#define IRC_RFC1459_RPL_ADMINLOC1				257				/* ":<admin info>" */
#define IRC_RFC1459_RPL_ADMINLOC2				258				/* ":<admin info>" */
#define IRC_RFC1459_RPL_ADMINEMAIL				259				/* ":<admin info>" */

#define IRC_RFC2812_RPL_WELCOME					1				/* "Welcome to the Internet Relay Network <nick>!<user>@<host>" */
#define IRC_RFC2812_RPL_YOURHOST				2				/* "Your host is <servername>, running version <ver>" */
#define IRC_RFC2812_RPL_CREATED					3				/* "This server was created <date>" */
#define IRC_RFC2812_RPL_MYINFO					4				/* "<servername> <version> <available user modes> <available channel modes>" */
#define IRC_RFC2812_RPL_BOUNCE					5				/* "Try server <server name>, port <port number>" */
#define IRC_RFC2812_RPL_USERHOST				302				/* ":*1<reply> *( " " <reply> )" */
#define IRC_RFC2812_RPL_ISON					303				/* ":*1<nick> *( " " <nick> )" */
#define IRC_RFC2812_RPL_AWAY					301				/* "<nick> :<away message>" */
#define IRC_RFC2812_RPL_UNAWAY					305				/* ":You are no longer marked as being away" */
#define IRC_RFC2812_RPL_NOWAWAY					306				/* ":You have been marked as being away" */
#define IRC_RFC2812_RPL_WHOISUSER				311				/* "<nick> <user> <host> * :<real name>" */
#define IRC_RFC2812_RPL_WHOISSERVER				312				/* "<nick> <server> :<server info>" */
#define IRC_RFC2812_RPL_WHOISOPERATOR				313				/* "<nick> :is an IRC operator" */
#define IRC_RFC2812_RPL_WHOISIDLE				317				/* "<nick> <integer> :seconds idle" */
#define IRC_RFC2812_RPL_ENDOFWHOIS				318				/* "<nick> :End of WHOIS list" */
#define IRC_RFC2812_RPL_WHOISCHANNELS				319				/* "<nick> :*( ( "@" / "+" ) <channel> " " )" */
#define IRC_RFC2812_RPL_WHOWASUSER				314				/* "<nick> <user> <host> * :<real name>" */
#define IRC_RFC2812_RPL_ENDOFWHOWAS				369				/* "<nick> :End of WHOWAS" */
#define IRC_RFC2812_RPL_LISTSTART				321				/* Obsolete. Not used. */
#define IRC_RFC2812_RPL_LIST					322				/* "<channel> <# visible> :<topic>" */
#define IRC_RFC2812_RPL_LISTEND					323				/* ":End of LIST" */
#define IRC_RFC2812_RPL_UNIQOPIS				325				/* "<channel> <nickname>" */
#define IRC_RFC2812_RPL_CHANNELMODEIS				324				/* "<channel> <mode> <mode params>" */
#define IRC_RFC2812_RPL_NOTOPIC					331				/* "<channel> :No topic is set" */
#define IRC_RFC2812_RPL_TOPIC					332				/* "<channel> :<topic>" */
#define IRC_RFC2812_RPL_INVITING				341				/* "<channel> <nick>" */
#define IRC_RFC2812_RPL_SUMMONING				342				/* "<user> :Summoning user to IRC" */
#define IRC_RFC2812_RPL_INVITELIST				346				/* "<channel> <invitemask>" */
#define IRC_RFC2812_RPL_ENDOFINVITELIST				347				/* "<channel> :End of channel invite list" */
#define IRC_RFC2812_RPL_EXCEPTLIST				348				/* "<channel> <exceptionmask>" */
#define IRC_RFC2812_RPL_ENDOFEXCEPTLIST				349				/* "<channel> :End of channel exception list" */
#define IRC_RFC2812_RPL_VERSION					351				/* "<version>.<debuglevel> <server> :<comments>" */
#define IRC_RFC2812_RPL_WHOREPLY				352				/* "<channel> <user> <host> <server> <nick> ( "H" / "G" > ["*"] [ ( "@" / "+" ) ] :<hopcount> <real name>" */
#define IRC_RFC2812_RPL_ENDOFWHO				315				/* "<name> :End of WHO list" */
#define IRC_RFC2812_RPL_NAMEREPLY				353				/* "( "=" / "*" / "@" ) <channel> :[ "@" / "+" ] <nick> *( " " [ "@" / "+" ] <nick> )" */
#define IRC_RFC2812_RPL_ENDOFNAMES				366				/* "<channel> :End of NAMES list" */
#define IRC_RFC2812_RPL_LINKS					364				/* "<mask> <server> :<hopcount> <server info>" */
#define IRC_RFC2812_RPL_ENDOFLINKS				365				/* "<mask> :End of LINKS list" */
#define IRC_RFC2812_RPL_BANLIST					367				/* "<channel> <banmask>" */
#define IRC_RFC2812_RPL_ENDOFBANLIST				368				/* "<channel> :End of channel ban list" */
#define IRC_RFC2812_RPL_INFO					371				/* ":<string>" */
#define IRC_RFC2812_RPL_ENDOFINFO				374				/* ":End of INFO list" */
#define IRC_RFC2812_RPL_MOTDSTART				375				/* ":- <server> Message of the day - " */
#define IRC_RFC2812_RPL_MOTD					372				/* ":- <text>" */
#define IRC_RFC2812_RPL_ENDOFMOTD				376				/* ":End of MOTD command" */
#define IRC_RFC2812_RPL_YOUREOPER				381				/* ":You are now an IRC operator" */
#define IRC_RFC2812_RPL_REHASHING				382				/* "<config file> :Rehashing" */
#define IRC_RFC2812_RPL_YOURESERVICE				383				/* "You are service <servicename>" */
#define IRC_RFC2812_RPL_TIME					391				/* "<server> :<string showing server's local time>" */
#define IRC_RFC2812_RPL_USERSSTART				392				/* ":UserID   Terminal  Host" */
#define IRC_RFC2812_RPL_USERS					393				/* ":<username> <ttyline> <hostname>" */
#define IRC_RFC2812_RPL_ENDOFUSERS				394				/* ":End of users" */
#define IRC_RFC2812_RPL_NOUSERS					395				/* ":Nobody logged in" */
#define IRC_RFC2812_RPL_TRACELINK				200				/* "Link <version & debug level> <destination> <next server> V<protocol version> <link uptime in seconds> <backstream sendq> <upstream sendq>" */
#define IRC_RFC2812_RPL_TRACECONNECTING				201				/* "Try. <class> <server>" */
#define IRC_RFC2812_RPL_TRACEHANDSHAKE				202				/* "H.S. <class> <server>" */
#define IRC_RFC2812_RPL_TRACEUNKNOWN				203				/* "???? <class> [<client IP address in dot form>]" */
#define IRC_RFC2812_RPL_TRACEOPERATOR				204				/* "Oper <class> <nick>" */
#define IRC_RFC2812_RPL_TRACEUSER				205				/* "User <class> <nick>" */
#define IRC_RFC2812_RPL_TRACESERVER				206				/* "Serv <class> <int>S <int>C <server> <nick!user|*!*>@<host|server> V<protocol version>" */
#define IRC_RFC2812_RPL_TRACESERVICE				207				/* "Service <class> <name> <type> <active type>" */ 
#define IRC_RFC2812_RPL_TRACENEWTYPE				208				/* "<newtype> 0 <client name>" */
#define IRC_RFC2812_RPL_TRACECLASS				209				/* "Class <class> <count>" */
#define IRC_RFC2812_RPL_TRACERECONNECT				210				/* Unused. */
#define IRC_RFC2812_RPL_TRACELOG				261				/* "File <logfile> <debug level>" */
#define IRC_RFC2812_RPL_TRACEEND				262				/* "<server name> <version & debug level> :End of TRACE" */
#define IRC_RFC2812_RPL_STATSLINKINFO				211				/* "<linkname> <sendq> <sent messages> <sent Kbytes> <received messages> <received Kbytes> <time open>" */
#define IRC_RFC2812_RPL_STATSCOMMANDS				212				/* "<command> <count> <byte count> <remote count>" */
#define IRC_RFC2812_RPL_ENDOFSTATS				219				/* "<stats letter> :End of STATS report" */
#define IRC_RFC2812_RPL_STATSUPTIME				242				/* ":Server Up %d days %d:%02d:%02d" */
#define IRC_RFC2812_RPL_STATSOLINE				243				/* "O <hostmask> * <name>" */
#define IRC_RFC2812_RPL_UMODEIS					221				/* "<user mode string>" */
#define IRC_RFC2812_RPL_SERVLIST				234				/* "<name> <server> <mask> <type> <hopcount> <info>" */
#define IRC_RFC2812_RPL_SERVLISTEND				235				/* "<mask> <type> :End of service listing" */
#define IRC_RFC2812_RPL_LUSERCLIENT				251				/* ":There are <integer> users and <integer> services on <integer> servers" */
#define IRC_RFC2812_RPL_LUSEROP					252				/* "<integer> :operator(s) online" */
#define IRC_RFC2812_RPL_LUSERUNKNOWN				253				/* "<integer> :unknown connection(s)" */
#define IRC_RFC2812_RPL_LUSERCHANNELS				254				/* "<integer> :channels formed" */
#define IRC_RFC2812_RPL_LUSERME					255				/* ":I have <integer> clients and <integer> servers" */
#define IRC_RFC2812_RPL_ADMINME					256				/* "<server> :Administrative info" */
#define IRC_RFC2812_RPL_ADMINLOC1				257				/* ":<admin info>" */
#define IRC_RFC2812_RPL_ADMINLOC2				258				/* ":<admin info>" */
#define IRC_RFC2812_RPL_ADMINEMAIL				259				/* ":<admin info>" */
#define IRC_RFC2812_RPL_TRYAGAIN				263				/* "<command> :Please wait a while and try again." */ 
#define IRC_RFC2812_ERR_NOSUCHNICK				401				/* "<nickname> :No such nick/channel" */
#define IRC_RFC2812_ERR_NOSUCHSERVER				402				/* "<server name> :No such server" */
#define IRC_RFC2812_ERR_NOSUCHCHANNEL				403				/* "<channel name> :No such channel" */
#define IRC_RFC2812_ERR_CANNOTSENDTOCHAN			404				/* "<channel name> :Cannot send to channel" */
#define IRC_RFC2812_ERR_TOOMANYCHANNELS				405				/* "<channel name> :You have joined too many channels" */
#define IRC_RFC2812_ERR_WASNOSUCHNICK				406				/* "<nickname> :There was no such nickname" */
#define IRC_RFC2812_ERR_TOOMANYTARGETS				407				/* "<target> :<error code> recipients. <abort message>" */
#define IRC_RFC2812_ERR_NOSUCHSERVICE				408				/* "<service name> :No such service" */
#define IRC_RFC2812_ERR_NOORIGIN				409				/* ":No origin specified" */
#define IRC_RFC2812_ERR_NORECIPIENT				411				/* ":No recipient given (<command>)" */
#define IRC_RFC2812_ERR_NOTEXTTOSEND				412				/* ":No text to send" */
#define IRC_RFC2812_ERR_NOTOPLEVEL				413				/* "<mask> :No toplevel domain specified" */
#define IRC_RFC2812_ERR_WILDTOPLEVEL				414				/* "<mask> :Wildcard in toplevel domain" */
#define IRC_RFC2812_ERR_BADMASK					515				/* "<mask> :Bad Server/host mask" */
#define IRC_RFC2812_ERR_UNKNOWNCOMMAND				521				/* "<command> :Unknown command" */
#define IRC_RFC2812_ERR_NOMOTD					422				/* ":MOTD File is missing" */
#define IRC_RFC2812_ERR_NOADMININFO				423				/* "<server> :No administrative info available" */
#define IRC_RFC2812_ERR_FILEERROR				424				/* ":File error doing <file op> on <file>" */
#define IRC_RFC2812_ERR_NONICKNAMEGIVEN				431				/* ":No nickname given" */
#define IRC_RFC2812_ERR_ERRONEUSNICKNAME			432				/* "<nick> :Erroneous nickname" */
#define IRC_RFC2812_ERR_NICKNAMEINUSE				433				/* "<nick> :Nickname is already in use" */
#define IRC_RFC2812_ERR_NICKCOLLISION				436				/* "<nick> :Nickname collision KILL from <user>@<host>" */
#define IRC_RFC2812_ERR_UNAVAILRESOURCE				437				/* "<nick/channel> :Nick/channel is temporarily unavailable" */
#define IRC_RFC2812_ERR_USERNOTINCHANNEL			441				/* "<nick> <channel> :They aren't on that channel" */
#define IRC_RFC2812_ERR_NOTONCHANNEL				442				/* "<channel> :You're not on that channel" */
#define IRC_RFC2812_ERR_USERONCHANNEL				443				/* "<user> <channel> :is already on channel" */
#define IRC_RFC2812_ERR_NOLOGIN					444				/* "<user> :User not logged in" */
#define IRC_RFC2812_ERR_SUMMONDISABLED				445				/* ":SUMMON has been disabled" */
#define IRC_RFC2812_ERR_USERSDISABLED				446				/* ":USERS has been disabled" */
#define IRC_RFC2812_ERR_NOTREGISTERED				451				/* ":You have not registered" */
#define IRC_RFC2812_ERR_NEEDMOREPARAMS				461				/* "<command> :Not enough parameters" */
#define IRC_RFC2812_ERR_ALREADYREGISTRED			462				/* ":Unauthorized command (already registered)" */
#define IRC_RFC2812_ERR_NOPERMFORHOST				463				/* ":Your host isn't among the privileged" */
#define IRC_RFC2812_ERR_PASSWDMISMATCH				464				/* ":Password incorrect" */
#define IRC_RFC2812_ERR_YOUREBANNEDCREEP			465				/* ":You are banned from this server" */
#define IRC_RFC2812_ERR_YOUWILLBEBANNED				466				/* "" */
#define IRC_RFC2812_ERR_KEYSET					467				/* "<channel> :Channel key already set" */
#define IRC_RFC2812_ERR_CHANNELISFULL				471				/* "<channel> :Cannot join channel (+l)" */
#define IRC_RFC2812_ERR_UNKNOWNMODE				472				/* "<char> :is unknown mode char to me for <channel>" */
#define IRC_RFC2812_ERR_INVITEONLYCHAN				473				/* "<channel> :Cannot join channel (+i)" */
#define IRC_RFC2812_ERR_BANNEDFROMCHAN				474				/* "<channel> :Cannot join channel (+b)" */
#define IRC_RFC2812_ERR_BADCHANNELKEY				475				/* "<channel> :Cannot join channel (+k)" */
#define IRC_RFC2812_ERR_BADCHANMASK				476				/* "<channel> :Bad Channel Mask" */
#define IRC_RFC2812_ERR_NOCHANMODES				477				/* "<channel> :Channel doesn't support modes" */
#define IRC_RFC2812_ERR_BANLISTFULL				478				/* "<channel> <char> :Channel list is full" */
#define IRC_RFC2812_ERR_NOPRIVILEGES				481				/* ":Permission Denied- You're not an IRC operator" */
#define IRC_RFC2812_ERR_CHANOPRIVSNEEDED			482				/* "<channel> :You're not channel operator" */
#define IRC_RFC2812_ERR_CANTKILLSERVER				283				/* ":You can't kill a server!" */
#define IRC_RFC2812_ERR_RESTRICTED				484				/* ":Your connection is restricted!" */
#define IRC_RFC2812_ERR_UNIQOPPRIVSNEEDED			485				/* ":You're not the original channel operator" */
#define IRC_RFC2812_ERR_NOOPERHOST				491				/* ":No O-lines for your host" */
#define IRC_RFC2812_ERR_UMODEUNKNOWNFLAG			501				/* ":Unknown MODE flag" */
#define IRC_RFC2812_ERR_USERSDONTMATCH				502				/* ":Cannot change mode for other users" */

#define IRC_GENERIC_RPL_ISUPPORT				5				/* "Generic reply" */

#define IRC_UNDERNET_RPL_CREATIONTIME				329				/* "Undernet specific reply" */
#define IRC_UNDERNET_ERR_TARGETTOOFAST				349				/* "Undernet specific reply" */
#define IRC_UNDERNET_RPL_BANNICKCHANGE				347				/* "Undernet specific reply" */
#define IRC_UNDERNET_RPL_NICKTOOFAST				349				/* "Undernet specific reply" */
#define IRC_UNDERNET_RPL_USERIP					307				/* "Undernet specific reply" */
#define IRC_UNDERNET_RPL_MAP					15				/* "Undernet specific reply" */
#define IRC_UNDERNET_RPL_MAPMORE				16				/* "Undernet specific reply" */
#define IRC_UNDERNET_RPL_MAPEND					17				/* "Undernet specific reply" */
#define IRC_UNDERNET_RPL_SILELIST				217				/* "Undernet specific reply" */
#define IRC_UNDERNET_RPL_ENDOFSILELIST				218				/* "Undernet specific reply" */
#define IRC_UNDERNET_RPL_LISTHELP				334				/* "Undernet specific reply" */
#define IRC_UNDERNET_RPL_TOPICWHOTIME				333				/* "Undernet specific reply" */
#define	IRC_UNDERNET_RPL_INVITELIST				346				/* "Undernet specific reply" */
#define	IRC_UNDERNET_RPL_ENDOFINVITELIST			347				/* "Undernet specific reply" */

#endif
