/*
 * ----------------------------------------------------------------
 * Night Light Memory Allocation Functions Header (memcalls.h)
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (21.09.2001)
 *
 */

#ifdef MEMCALLS_H
#warning "memcalls.h already included."
#else
#define MEMCALLS_H


#if !MEMDEBUG
  #error "memcalls.h included, but MEMDEBUG not defined TRUE."
#endif

#define MEMPTRZSTRLEN		10
#define MEMBYTESTRLEN		4
#define MEMFILESTRLEN		16
#define MEMLINESTRLEN		4
#define MEMTIMESTRLEN		10

#define MALLOC_HASH_SIZE	65539
#define MALLOC_LIMIT		0xFFFFFFF

#define MALLOC_PREFIX		"LadyDay"
#define MALLOC_POSTFIX		"SweetJane"

#define MALLOC_PREFIX_LEN	strlen(MALLOC_PREFIX)
#define MALLOC_POSTFIX_LEN	strlen(MALLOC_POSTFIX)

#define MALLOC_REDBYTE		0xCD

#define MALLOC_PRINT		FALSE

#define MallocHash(PTR)		(((unsigned long) (PTR) >> 3) % MALLOC_HASH_SIZE)

#ifndef MEMCALLS_C
  #define MALLOC_REDEFINE
  #undef malloc
  #undef realloc
  #undef calloc
  #undef free
  #define malloc(s) memalloc(__FILE__, __LINE__, __FUNCTION__, (s))
  #define realloc(p, s) memrealloc(__FILE__, __LINE__, __FUNCTION__, (p), (s))
  #define calloc(n, s) memcalloc(__FILE__, __LINE__, __FUNCTION__, (n), (s))
  #define free(p) memfree(__FILE__, __LINE__, __FUNCTION__, (p))
#endif


/* STRUCTURES - JONAS (21.09.2001) */

struct MemTable_Struct {

  const void *PTR;
  const char *File;
  unsigned short int Line;
  const char *Function;
  size_t Size;
  time_t Time;

  struct MemTable_Struct *Prev;
  struct MemTable_Struct *Next;

  struct MemTable_Struct *PrevH;
  struct MemTable_Struct *NextH;

};


/* FUNCTION PROTOTYPES - JONAS (21.09.2001) */

void memtable_add(const void *const PTR, const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, const size_t Size);
void memtable_rem(struct MemTable_Struct *MemTableS);
struct MemTable_Struct *memtable_get(const void *const PTR);
void *memalloc(const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, const size_t MemSize);
void *memrealloc(const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, void *const OldPTR, const size_t MemSize);
void *memcalloc(const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, const size_t Elements, const size_t Size);
signed short int memfree(const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, void *const MemPTR);

#endif
