/*
 * ----------------------------------------------------------------
 * Night Light String Defines (nlstrdef.h)
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (12.08.2001)
 *
 */

#ifdef NLSTRDEF_H
#warning "nlstrdef.h already included."
#else
#define NLSTRDEF_H


/* DEFINES */

#define STDINMSGLEN		512
#define DATESTAMPLEN		12
#define TIMESTAMPLEN		10
#define DTSTAMPLEN		21
#define HOURLEN			2
#define MINLEN			2
#define SECLEN			2
#define STRDURATIONLEN		200
#define FILELEN			1024
#define USERLEN			12
#define HOSTLEN			254
#define RECVBUFFERLEN		2048
#define SENDBUFFERLEN		2048
#define LINELEN			4000
#define TEXTLEN			150
#define SPACE10			"          "
#define SPACE15			"               "
#define SPACE20			"                    "
#define ONESECOND		1
#define ONEMINUTE		60
#define ONEHOUR			3600
#define ONEDAY			86400
#define FILECHARS		"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-.!@{}[]~:,"
#define STRHOSTCHARS		"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.?*"


/* MACROS */

#define Seconds(x)		(((x) / ONESECOND) % ONEMINUTE)
#define Minutes(x)		(((x) / ONEMINUTE) % ONEMINUTE)
#define Hours(x)		(((x) / ONEHOUR) % 24)
#define Days(x)			(((x) / ONEDAY))
#define OneOrMore(x)		(((x) == 1) ? "" : "s")

#define StrMovePastToken(S, T)	\
				S = strchr(S, T); \
				if (S != NULL) { \
				  *S = '\0'; \
				  ++S; \
				  while (S[0] == T) { ++S; } \
				}

#define StrPrintErrorIfNull(S, F, L, M) \
				if ((S == NULL) || (S[0] == '\0')) { \
				  sysprint(BITMASK_ERROR, M, F, L); \
				  continue; \
				} \
				while ((S[0] == ' ') || (S[0] == '\t')) { ++S; }

#endif
