/*
 * ----------------------------------------------------------------
 * Night Light String Functions Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (27.04.2002)
 *
 */

#ifdef STRCALLS_H
#warning "strcalls.h already included."
#else
#define STRCALLS_H


#define STRHOSTINVALIDCHAR						"Invalid character \"%c\" in hostname."
#define STRHOSTMAXCHARS							"Maximum %d characters in hostname."
#define STRFILEINVALIDCHAR						"Invalid character \"%c\" in filename."
#define STRFILEMAXCHARS							"Maximum %d characters in filename."


/* VARIABLES - JONAS (05.05.2000) */

#ifdef STRCALLS_C
  unsigned short int WMChars = 0;
  char *UNAMEINFO = NULL;
  char *PLATFORM = NULL;
  char *HOSTNAME = NULL;
  char *HOSTIPS = NULL;
  unsigned long int HOSTIPH = 0;
  unsigned long int HOSTIPN = 0;
  char *OSNAME = NULL;
  char *OSRELEASE = NULL;
  char *STRDURATION = NULL;
  char StrResult[LINELEN+1] = "";
#else
  extern unsigned short int WMChars;
  extern char *UNAMEINFO;
  extern char *PLATFORM;
  extern char *HOSTNAME;
  extern char *HOSTIPS;
  extern unsigned long int HOSTIPH;
  extern unsigned long int HOSTIPN;
  extern char *OSNAME;
  extern char *OSRELEASE;
  extern char *STRDURATION;
  extern char StrResult[];
#endif


/* MACROS - JONAS (05.05.2000) */

#undef strdup
#define strdup(s)		mystrdup(__FILE__, __LINE__, __FUNCTION__, (s))

#undef strrealloc
#define strrealloc(p, s)	mystrrealloc(__FILE__, __LINE__, __FUNCTION__, (p), (s))

#undef strwm
#define strwm(p, s)		mystrwm(__FILE__, __LINE__, __FUNCTION__, (p), (s), FALSE)


/* FUNCTION PROTOTYPES - JONAS (27.04.2002) */

const char *const straerror(unsigned short int aerrnocode);
unsigned short int strisvalidhost(const char *const StringPT);
unsigned short int strisvalidfile(const char *const StringPT);
const char *const strresult(void);
char *mystrdup(const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, const char *StringPT);
char *mystrrealloc(const char *FilePT, const unsigned long int Line, const char *const FunctionPT, char *OldPointer, const char *StringPT);
size_t mystrspn(const char *StringPT, const char *AcceptPT);
unsigned short int mystrwm(const char *FilePT, const unsigned long int Line, const char *const FunctionPT, const char *PatternPT, const char *StringPT, unsigned short int Internal);
void strlower(char *StringPT);
void strupper(char *StringPT);
unsigned short int strdigit(const char *StringPT);
unsigned short int strip(const char *StringPT);
void strrnd(char *StringPT, const unsigned short int Len);
const char *const datestamp(void);
const char *const timestamp(void);
const char *const dtstamp(void);
const char *const strduration(const time_t Time);
#if WIN32
  #define strgetunameinfo UNAMEINFO = strrealloc(UNAMEINFO, "Windows/WIN32/i386");
  #define strgetplatform PLATFORM = strrealloc(PLATFORM, "i386");
  #define strgetosname OSNAME = strreallooc(OSNAME, "Windows");
  #define strgetosrelease OSRELEASE = strrealloc(OSRELEASE, "WIN32");
#else
void strgetunameinfo(void);
void strgetplatform(void);
void strgetosname(void);
void strgetosrelease(void);
#endif
void strgethostname(void);
char *straddbuffer(char *StringPT, const char *const BufferPT, const unsigned long int MaxStringLen, const unsigned short int AddLen);
void strcleanup(void);

#endif
