/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Connection Logging System
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (07.07.2003)
 *
 */

#define CONN_LOG_C

#define NEED_SYS_TYPES_H 1		/* Extra types */
#define NEED_SYS_PARAM_H 1		/* Some systems need this */
#define NEED_LIMITS_H 0			/* Kernel limits */
#define NEED_STDARG_H 1			/* va_list, etc */
#define NEED_ERRNO_H 1			/* errno */
#define NEED_CTYPE_H 1			/* isdigit(), etc */
#define NEED_NETINET_IN_H 0		/* in_addr, sockaddr_in, etc */
#define NEED_ARPA_INET_H 0		/* inet_ntoa(), inet_aton(), etc */
#define NEED_STDIO_H 1			/* Standard C UNIX functions */
#define NEED_STDLIB_H 1			/* malloc(), exit(), atoi(), etc */
#define NEED_TIME_H 1			/* time(), etc */
#define NEED_SYSCTL_H 0			/* sysctl(), etc */
#define NEED_SYS_STAT_H 1		/* chmod(), mkdir(), etc */
#define NEED_SYS_UIO_H 0		/* iovec, etc */
#define NEED_FCNTL_H 1			/* open(), creat(), fcntl(), etc */
#define NEED_SYS_IOCTL_H 0		/* ioctl(), etc */
#define NEED_SYS_FILIO_H 0		/* Solaris need this for ioctl(), etc */
#define NEED_UNISTD_H 1			/* Unix standard functions */
#define NEED_STRING_H 1			/* C string functions */
#define NEED_SIGNAL_H 0			/* Signal functions */
#define NEED_SYS_SOCKET_H 0		/* Socket functions */
#define NEED_NETDB_H 0			/* Network database functions */
#define NEED_ARPA_NAMESER_H 0		/* Nameserver definitions */
#define NEED_GETUSERPW_HEADERS 0 	/* Functions to retrive system passwords */

#include "includes.h"

#include "irc.h"

#include "conn_io.h"
#include "conn_log.h"

/* CONN_LOG FUNCTION - JONAS (18.07.2001) */

unsigned short int conn_log(struct Conn_Struct *ConnS, const char *const NUHPT, const char *const CommandPT, const char *const MessagePT) {

  signed long int Result = 0;
#if !WIN32
  char *HomeDirPT = NULL;
#endif
  char FileName[FILELEN+1] = "";
  char LogPath[FILELEN+1] = "";
  FILE *FilePT = NULL;

  assert(ConnS != NULL);
  assert(NUHPT != NULL);
  assert(CommandPT != NULL);
  assert(MessagePT != NULL);

#if !WIN32
  HomeDirPT = sysgethomedirfromuser(ConnS->User);
  if ((HomeDirPT != NULL) && (access(HomeDirPT, X_OK) == SUCCESS) && (sysseteuidbyuser(ConnS->User) == SUCCESS)) {
    Conn_SetLogHomeDir(ConnS);
    snprintf(LogPath, FILELEN+1, "%s/ircproxy-logs", HomeDirPT);
  }
  else {
    Conn_ClearLogHomeDir(ConnS);
    snprintf(LogPath, FILELEN+1, "%s/%s", LOGPATH, ConnS->User);
  }
#else
  snprintf(LogPath, FILELEN+1, "%s/%s", LOGPATH, ConnS->User);
#endif

  if (access(LogPath, X_OK) == ERROR) {
    Result = mkdir(LogPath, (S_IRWXU|S_IXGRP|S_IXOTH));
    if ((Result <= ERROR) && (errno != EEXIST)) {
      sysprint(BITMASK_ERROR, "Unable to create directory %s: [%d] %s", LogPath, errno, strerror(errno));
      return(ERROR);
    }
  }

  snprintf(FileName, FILELEN+1, "%s/%s.log", LogPath, ConnS->Name);
  ConnS->FileName = strrealloc(ConnS->FileName, FileName);

  FilePT = fopen(FileName, "a");
  if (FilePT == NULL) {
    sysprint(BITMASK_ERROR, "Unable to open %s for writing: [%d] %s", FileName, errno, strerror(errno));
    return(ERROR);
  }
  Result = chmod(FileName, S_IRUSR|S_IWUSR);
  if (Result <= ERROR) {
    sysprint(BITMASK_ERROR, "Unable to set file permission for %s: [%d] %s", FileName, errno, strerror(errno));
    fclose(FilePT);
    return(ERROR);
  }

  if (strcasecmp(CommandPT, "PRIVMSG") == FALSE) { fprintf(FilePT, "%s <%s> %s%s", dtstamp(), NUHPT, MessagePT, LINEFEED); }
  else if (strcasecmp(CommandPT, "NOTICE") == FALSE) { fprintf(FilePT, "%s -%s- %s%s", dtstamp(), NUHPT, MessagePT, LINEFEED); }

  fclose(FilePT);

#if !WIN32
  if (Conn_IsLogHomeDir(ConnS)) { sysseteuidnormal(); }
#endif

  return(SUCCESS);

}

