/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Listen Configuration System
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (25.06.2001)
 *
 */

#define LISTEN_CONF_C

#define NEED_SYS_TYPES_H 1		/* Extra types */
#define NEED_SYS_PARAM_H 1		/* Some systems need this */
#define NEED_LIMITS_H 0			/* Kernel limits */
#define NEED_STDARG_H 1			/* va_list, etc */
#define NEED_ERRNO_H 1			/* errno */
#define NEED_CTYPE_H 1			/* isdigit(), etc */
#define NEED_NETINET_IN_H 0		/* in_addr, sockaddr_in, etc */
#define NEED_ARPA_INET_H 0		/* inet_ntoa(), inet_aton(), etc */
#define NEED_STDIO_H 1			/* Standard C UNIX functions */
#define NEED_STDLIB_H 1			/* malloc(), exit(), atoi(), etc */
#define NEED_TIME_H 1			/* time(), etc */
#define NEED_SYSCTL_H 0			/* sysctl(), etc */
#define NEED_SYS_STAT_H 0		/* chmod(), mkdir(), etc */
#define NEED_SYS_UIO_H 0		/* iovec, etc */
#define NEED_FCNTL_H 1			/* open(), creat(), fcntl(), etc */
#define NEED_SYS_IOCTL_H 0		/* ioctl(), etc */
#define NEED_SYS_FILIO_H 0		/* Solaris need this for ioctl(), etc */
#define NEED_UNISTD_H 1			/* Unix standard functions */
#define NEED_STRING_H 1			/* C string functions */
#define NEED_SIGNAL_H 0			/* Signal functions */
#define NEED_SYS_SOCKET_H 0		/* Socket functions */
#define NEED_NETDB_H 0			/* Network database functions */
#define NEED_ARPA_NAMESER_H 0		/* Nameserver definitions */
#define NEED_GETUSERPW_HEADERS 0 	/* Functions to retrive system passwords */

#include "includes.h"

#include "listen_conf.h"
#include "listen_io.h"

/* VARIABLES - JONAS (06.10.2000) */

struct ListenConf_Struct *ListenConf_Head = NULL;
struct ListenConf_Struct *ListenConf_Tail = NULL;
unsigned long int ListenConfs = 0;

/* LISTEN_CONF_READ FUNCTION - JONAS (01.07.2000) */

signed long int listen_conf_read(void) {

  char File[FILELEN+1] = "";
  FILE *FilePT = NULL;

  char *TempPT = NULL;

  char Line[LINELEN+1] = "";
  char *LinePT = NULL;

  unsigned short int Count = 0;

  char *EntryPT = NULL;
  char *HostPT = NULL;
  unsigned long int Port = 0;

  sysprint(BITMASK_CONF, "Reading listen configuration file.");

  if (LISTEN_CONFFILE[0] != '/') {
    strncat(File, DATAPATH, FILELEN);
    if (DATAPATH[strlen(DATAPATH)] != '/') { strncat(File, "/", (FILELEN - strlen(File))); }
  }
  strncat(File, LISTEN_CONFFILE, (FILELEN - strlen(File)));

  FilePT = fopen(File, "r");
  if (FilePT == NULL) {
    sysprint(BITMASK_ERROR, "Unable to open listen configuration file %s: [%d] %s", File, errno, strerror(errno));
    return(ERROR);
  }

  listen_conf_remall();

  FOREVERLOOP {

    memset(&Line, 0, LINELEN+1);
    TempPT = fgets(Line, LINELEN, FilePT);
    if (TempPT == NULL) { break; }
    ++Count;
    LinePT = Line;

    while ((TempPT = strchr(LinePT, '\r')) != NULL) { *TempPT = '\0'; }
    while ((TempPT = strchr(LinePT, '\n')) != NULL) { *TempPT = '\0'; }
    while ((TempPT = strchr(LinePT, '\t')) != NULL) { *TempPT = ' '; }

    while ((LinePT[0] == ' ') || (LinePT[0] == '\t')) { ++LinePT; }
    if ((LinePT[0] == '#') || (LinePT[0] == ';') || (LinePT[0] == '\0')) { continue; }

    EntryPT = LinePT;
    StrMovePastToken(LinePT, ':');
    if (strcasecmp(EntryPT, "LISTEN") != FALSE) {
      sysprint(BITMASK_ERROR, "Ident configuration error, file %s line %d: Unknown entry \"%s\".", File, Count, EntryPT);
      continue;
    }

    if (LinePT == NULL) {
      sysprint(BITMASK_ERROR, "Ident configuration error, file %s line %d: Expecting host(name/IP-address) for \"%s\" entry.", File, Count, EntryPT);
      continue;
    }
    HostPT = LinePT;
    StrMovePastToken(LinePT, ':');

    if (LinePT == NULL) {
      sysprint(BITMASK_ERROR, "Ident configuration error, file %s line %d: Expecting port for \"%s\" entry.", File, Count, EntryPT);
      continue;
    }
    TempPT = LinePT;
    StrMovePastToken(LinePT, ':');
    Port = strtoul(TempPT, NULL, 0);

    listen_conf_add(HostPT, Port);

  }
  fclose(FilePT);

  return(ListenConfs);

}

/* LISTEN_CONF_ADD FUNCTION - JONAS (06.10.2000) */

struct ListenConf_Struct *listen_conf_add(const char *const HostPT, const unsigned long int Port) {

  struct ListenConf_Struct *ListenConf = NULL;
  struct ListenConf_Struct *ListenConf_NEW = NULL;

  assert(HostPT != NULL);

  sysprint(BITMASK_CONF, "Adding listen address: Host: %s - Port: %ld.", HostPT, Port);

  ListenConf = listen_conf_get(HostPT, Port);
  if (ListenConf != NULL) {
    aerrno = AEEXISTS;
    return(ListenConf);
  }

  ListenConf_NEW = malloc(sizeof(struct ListenConf_Struct));
  if (ListenConf_NEW == NULL) {
    aerrno = AEMALLOC;
    return(NULL);
  }

  memset(ListenConf_NEW, 0, sizeof(struct ListenConf_Struct));

  ListenConf_NEW->Host = strdup(HostPT);
  if (ListenConf_NEW->Host == NULL) {
    free(ListenConf_NEW);
    aerrno = AEMALLOC;
    return(NULL);
  }
  ListenConf_NEW->Port = Port;

  if (ListenConf_Head == NULL) {
    ListenConf_Head = ListenConf_NEW;
    ListenConf_Tail = ListenConf_NEW;
  }
  else {
    ListenConf = ListenConf_Tail;
    ListenConf->Next = ListenConf_NEW;
    ListenConf_NEW->Prev = ListenConf;
    ListenConf_Tail = ListenConf_NEW;
  }

  ListenConfs++;

  listen_add(HostPT, Port);

  aerrno = AESUCCESS;
  return(ListenConf_NEW);

}

/* LISTEN_CONF_REM - JONAS (06.10.2000) */

void listen_conf_rem(struct ListenConf_Struct *ListenConf) {

  assert(ListenConf != NULL);

  if (ListenConf->Prev == NULL) { ListenConf_Head = ListenConf->Next; }
  else { ListenConf->Prev->Next = ListenConf->Next; }

  if (ListenConf->Next == NULL) { ListenConf_Tail = ListenConf->Prev; }
  else { ListenConf->Next->Prev = ListenConf->Prev; }

  free(ListenConf->Host);
  free(ListenConf);

  ListenConfs--;

}

/* LISTEN_CONF_GET - JONAS (06.10.2000) */

struct ListenConf_Struct *listen_conf_get(const char *const HostPT, const unsigned long int Port) {

  struct ListenConf_Struct *ListenConf = NULL;

  assert(HostPT != NULL);

  for (ListenConf = ListenConf_Head ; ListenConf != NULL ; ListenConf = ListenConf->Next) {
    if ((strcasecmp(ListenConf->Host, HostPT) == FALSE) && (ListenConf->Port == Port)) {
      aerrno = AESUCCESS;
      return(ListenConf);
    }
  }
  aerrno = AENOMATCH;
  return(NULL);

}

/* LISTEN_CONF_REMALL FUNCTION - JONAS (31.07.2001) */

void listen_conf_remall(void) {

  while (ListenConf_Head != NULL) { listen_conf_rem(ListenConf_Head); }

}
