/*
 * ----------------------------------------------------------------
 * Night Light Memory Allocation List Functions
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (26.03.2002)
 *
 */

#define MEMLIST_C

#define NEED_SYS_TYPES_H 1		/* Extra types */
#define NEED_SYS_PARAM_H 1		/* Some systems need this */
#define NEED_LIMITS_H 0			/* Kernel limits */
#define NEED_STDARG_H 1			/* va_list, etc */
#define NEED_ERRNO_H 1			/* errno */
#define NEED_CTYPE_H 1			/* isdigit(), etc */
#define NEED_NETINET_IN_H 1		/* in_addr, sockaddr_in, etc */
#define NEED_ARPA_INET_H 0		/* inet_ntoa(), inet_aton(), etc */
#define NEED_STDIO_H 1			/* Standard C UNIX functions */
#define NEED_STDLIB_H 1			/* malloc(), exit(), atoi(), etc */
#define NEED_TIME_H 1			/* time(), etc */
#define NEED_SYSCTL_H 0			/* sysctl(), etc */
#define NEED_SYS_STAT_H 0		/* chmod(), mkdir(), etc */
#define NEED_SYS_UIO_H 0		/* iovec, etc */
#define NEED_FCNTL_H 1			/* open(), creat(), fcntl(), etc */
#define NEED_SYS_IOCTL_H 0		/* ioctl(), etc */
#define NEED_SYS_FILIO_H 0		/* Solaris need this for ioctl(), etc */
#define NEED_UNISTD_H 1			/* Unix standard functions */
#define NEED_STRING_H 1			/* C string functions */
#define NEED_SIGNAL_H 0			/* Signal functions */
#define NEED_SYS_SOCKET_H 0		/* Socket functions */
#define NEED_NETDB_H 0			/* Network database functions */
#define NEED_ARPA_NAMESER_H 0		/* Nameserver definitions */
#define NEED_GETUSERPW_HEADERS 0 	/* Functions to retrive system passwords */

#include "includes.h"

#include "memlist.h"

#if ARES
  #include "ares_io.h"
  #include "ares_int.h"
#endif

#include "access_conf.h"
#include "listen_conf.h"
#if USER_CONF
  #include "user_conf.h"
#endif
#include "conn_conf.h"

#include "listen_io.h"
#include "client_io.h"
#include "conn_io.h"
#include "conn_sendq.h"
#include "conn_ignore.h"
#include "chan.h"
#include "chan_user.h"

#if IDENT
  #include "ident_conf.h"
  #include "ident_listen.h"
  #include "ident_conn.h"
#endif

/* VARIABLES - JONAS (21.09.2001) */

time_t MemLeaksTime = 0;
extern struct MemTable_Struct *MemTable_Head;
extern struct MemTable_Struct *MemTable_Tail;
extern unsigned long int G_Allocations;
extern size_t MemPrefixSize;
extern size_t MemPostfixSize;

extern char *TMPSTRPT;

extern struct PrintFile_Struct PrintFileS[];
extern unsigned short int PrintFileS_Len;

extern char *IRCNUH;
extern char *IRCNICK;

extern char *STDIN_RecvBufferPT;

#if FDDEBUG
  extern struct FDTable_Struct *FDTable_Head;
  extern struct SockTable_Struct *SockTable_Head;
#endif

extern struct Ares_Server_Struct *Ares_Server_Head;
extern struct Ares_Host_Struct *Ares_Host_Head;
extern struct Ares_Query_Struct *Ares_Query_Head;
extern struct AccessConf_Struct *Allow_Head;
extern struct AccessConf_Struct *Deny_Head;
extern struct ListenConf_Struct *ListenConf_Head;
#if USER_CONF
  extern struct UserConf_Struct *UserConf_Head;
#endif
extern struct ConnConf_Struct *ConnConf_Head;
extern struct Listen_Struct *Listen_Head;
extern struct Client_Struct *Client_Head;
extern struct Conn_Struct *Conn_Head;

#if IDENT
  extern char *Listen_Conf_DefaultUser;
  extern struct IdentConf_Struct *IdentConf_Head;
  extern struct IdentListen_Struct *IdentListen_Head;
  extern struct IdentConn_Struct *IdentConn_Head;
#endif

/* MEM_PRINT - JONAS (21.09.2001) */

void mem_print(void) {

  signed long int Result = 0;
  struct MemTable_Struct *MemTableS = NULL;
  unsigned long int Allocations = 0;
  unsigned long int AllocationsSize = 0;
  char PTRZSTR[MEMPTRZSTRLEN+1] = "";
  char BYTESTR[MEMBYTESTRLEN+1] = "";
  char FILESTR[MEMFILESTRLEN+1] = "";
  char LINESTR[MEMLINESTRLEN+1] = "";
  char TIMESTR[MEMTIMESTRLEN+1] = "";

  for (MemTableS = MemTable_Head ; MemTableS != NULL ; MemTableS = MemTableS->Next) {

    const void *PrefixPTR = MemTableS->PTR - MemPrefixSize;
    const void *PostfixPTR = MemTableS->PTR + MemTableS->Size;

    Allocations++;
    AllocationsSize += MemTableS->Size;

    if (strncmp(PrefixPTR, MALLOC_PREFIX, MALLOC_PREFIX_LEN) != 0) {
      sysprint(BITMASK_ERROR, "Magic memory prefix \"%s\" corrupt on pointer %p allocated in function %s (%s:%d).", MALLOC_PREFIX, MemTableS->PTR, MemTableS->Function, MemTableS->File, MemTableS->Line);
      abort();
    }

    if (strncmp(PostfixPTR, MALLOC_POSTFIX, MALLOC_POSTFIX_LEN) != 0) {
      sysprint(BITMASK_ERROR, "Magic memory postfix \"%s\" corrupt on pointer %p allocated in function %s (%s:%d).", MALLOC_POSTFIX, MemTableS->PTR, MemTableS->Function, MemTableS->File, MemTableS->Line);
      abort();
    }

    memset(&PTRZSTR, 32, MEMPTRZSTRLEN);
    memset(&BYTESTR, 32, MEMBYTESTRLEN);
    memset(&FILESTR, 32, MEMFILESTRLEN);
    memset(&LINESTR, 32, MEMLINESTRLEN);
    memset(&TIMESTR, 32, MEMTIMESTRLEN);

    Result = snprintf(PTRZSTR, MEMPTRZSTRLEN+1, "%p", MemTableS->PTR);
    if (Result > 0) { PTRZSTR[Result] = 32; }
    PTRZSTR[MEMPTRZSTRLEN] = 0;

    Result = snprintf(BYTESTR, MEMBYTESTRLEN+1, "%ld", (PRINT_SIZE_T) MemTableS->Size);
    if (Result > 0) { BYTESTR[Result] = 32; }
    BYTESTR[MEMBYTESTRLEN] = 0;

    Result = snprintf(FILESTR, MEMFILESTRLEN+1, "%s", MemTableS->File);
    if (Result > 0) { FILESTR[Result] = 32; }
    FILESTR[MEMFILESTRLEN] = 0;

    Result = snprintf(LINESTR, MEMLINESTRLEN+1, "%d", MemTableS->Line);
    if (Result > 0) { LINESTR[Result] = 32; }
    LINESTR[MEMLINESTRLEN] = 0;

    Result = snprintf(TIMESTR, MEMTIMESTRLEN+1, "%ld", (PRINT_TIME_T) MemTableS->Time);
    if (Result > 0) { TIMESTR[Result] = 32; }
    TIMESTR[MEMTIMESTRLEN] = 0;

    sysprint(BITMASK_ERROR, "Memory allocation: Hex: %s Size: %s File: %s Line: %s Time: %s", PTRZSTR, BYTESTR, FILESTR, LINESTR, TIMESTR);

  }

  sysprint(BITMASK_MAIN, "Memory allocations: %ld size: %ld", Allocations, AllocationsSize);

}

/* MEM_LEAKS - JONAS (21.09.2001) */

void mem_leaks(void) {

  struct MemTable_Struct *MemTableS = NULL;
  unsigned long int Allocations = 0;
  unsigned long int AllocationsSize = 0;
  unsigned long int Leaks = 0;
  unsigned long int LeaksSize = 0;
  char PTRZSTR[MEMPTRZSTRLEN+1] = "";
  char BYTESTR[MEMBYTESTRLEN+1] = "";
  char FILESTR[MEMFILESTRLEN+1] = "";
  char LINESTR[MEMLINESTRLEN+1] = "";
  char TIMESTR[MEMTIMESTRLEN+1] = "";
  signed short int Result = 0;
  unsigned short int Bool = 0;
  unsigned short int Index = 0;

#if FDDEBUG
  struct FDTable_Struct *FDTableS = NULL;
  struct SockTable_Struct *SockTableS = NULL;
#endif

  struct Ares_Server_Struct *AresServer = NULL;
  struct Ares_Host_Struct *AresHost = NULL;
  struct Ares_Query_Struct *AresQuery = NULL;
  struct Ares_SendQ_Struct *AresSendQ = NULL;

  struct AccessConf_Struct *AccessConf = NULL;
  struct ListenConf_Struct *ListenConf = NULL;
#if USER_CONF
  struct UserConf_Struct *UserConf = NULL;
#endif
  struct ConnConf_Struct *ConnConf = NULL;
  struct ConnConfServer_Struct *ConnConfServer = NULL;

  struct Listen_Struct *ListenS = NULL;
  struct Client_Struct *ClientS = NULL;
  struct Conn_Struct *ConnS = NULL;
  struct ConnServer_Struct *ConnServer = NULL;

  struct SendQ_Struct *SendQ = NULL;
  struct FlushL_Struct *FlushL = NULL;
  struct FlushB_Struct *FlushB = NULL;
  struct Ignore_Struct *IgnoreS = NULL;

  struct Chan_Struct *ChanS = NULL;
  struct ChanUser_Struct *ChanUser = NULL;

#if IDENT
  struct IdentConf_Struct *IdentConfS = NULL;
  struct IdentListen_Struct *IdentListenS = NULL;
  struct IdentConn_Struct *IdentConnS = NULL;
#endif

  MemLeaksTime = NOW;

  for (MemTableS = MemTable_Head ; MemTableS != NULL ; MemTableS = MemTableS->Next) {

    const void *PrefixPTR = MemTableS->PTR - MemPrefixSize;
    const void *PostfixPTR = MemTableS->PTR + MemTableS->Size;

    Allocations++;
    AllocationsSize += MemTableS->Size;

    if (strncmp(PrefixPTR, MALLOC_PREFIX, MALLOC_PREFIX_LEN) != 0) {
      sysprint(BITMASK_ERROR, "Magic memory prefix \"%s\" corrupt on pointer %p allocated in function %s (%s:%d).", MALLOC_PREFIX, MemTableS->PTR, MemTableS->Function, MemTableS->File, MemTableS->Line);
      abort();
    }

    if (strncmp(PostfixPTR, MALLOC_POSTFIX, MALLOC_POSTFIX_LEN) != 0) {
      sysprint(BITMASK_ERROR, "Magic memory postfix \"%s\" corrupt on pointer %p allocated in function %s (%s:%d).", MALLOC_POSTFIX, MemTableS->PTR, MemTableS->Function, MemTableS->File, MemTableS->Line);
      abort();
    }

    Bool = FALSE;
    if (MemTableS->PTR == NULL) { continue; }


    /* SYSCALLS */

    else if (MemTableS->PTR == TMPSTRPT) { continue; }
    for (Index = 0 ; Index < PrintFileS_Len ; Index++) {
      if (MemTableS->PTR == PrintFileS[Index].Name) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }


    /* STRCALLS */

    else if (MemTableS->PTR == UNAMEINFO) { continue; }
    else if (MemTableS->PTR == PLATFORM) { continue; }
    else if (MemTableS->PTR == HOSTNAME) { continue; }
    else if (MemTableS->PTR == OSNAME) { continue; }
    else if (MemTableS->PTR == OSRELEASE) { continue; }
    else if (MemTableS->PTR == STRDURATION) { continue; }


    /* IRCCALLS */

    else if (MemTableS->PTR == IRCNUH) { continue; }
    else if (MemTableS->PTR == IRCNICK) { continue; }


    /* MAIN */

    else if (MemTableS->PTR == STDIN_RecvBufferPT) { continue; }

#if FDDEBUG
    for (FDTableS = FDTable_Head ; FDTableS != NULL ; FDTableS = FDTableS->Next) {
      if (MemTableS->PTR == FDTableS) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }
    for (SockTableS = SockTable_Head ; SockTableS != NULL ; SockTableS = SockTableS->Next) {
      if (MemTableS->PTR == SockTableS) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }
#endif

    for (AresServer = Ares_Server_Head ; AresServer != NULL ; AresServer = AresServer->Next) {
      if (MemTableS->PTR == AresServer) { Bool = TRUE; break; }
      if (MemTableS->PTR == AresServer->HostIPS) { Bool = TRUE; break; }
      if (MemTableS->PTR == AresServer->Buffer) { Bool = TRUE; break; }
      for (AresSendQ = AresServer->TCPSend_Head ; AresSendQ != NULL ; AresSendQ = AresSendQ->Next) {
        if (MemTableS->PTR == AresSendQ) { Bool = TRUE; break; }
        if (MemTableS->PTR == AresSendQ->Buffer) { Bool = TRUE; break; }
      }
      for (AresSendQ = AresServer->UDPSend_Head ; AresSendQ != NULL ; AresSendQ = AresSendQ->Next) {
        if (MemTableS->PTR == AresSendQ) { Bool = TRUE; break; }
        if (MemTableS->PTR == AresSendQ->Buffer) { Bool = TRUE; break; }
      }
    }
    if (Bool == TRUE) { continue; }

    for (AresHost = Ares_Host_Head ; AresHost != NULL ; AresHost = AresHost->Next) {
      if (MemTableS->PTR == AresHost) { Bool = TRUE; break; }
      if (MemTableS->PTR == AresHost->HostIPS) { Bool = TRUE; break; }
      if (MemTableS->PTR == AresHost->HostName) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }

    for (AresQuery = Ares_Query_Head ; AresQuery != NULL ; AresQuery = AresQuery->Next) {
      if (MemTableS->PTR == AresQuery) { Bool = TRUE; break; }
      if (MemTableS->PTR == AresQuery->Name) { Bool = TRUE; break; }
      if (MemTableS->PTR == AresQuery->Buffer) { Bool = TRUE; break; }
      if (MemTableS->PTR == AresQuery->HostEnt) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }

    for (AccessConf = Allow_Head ; AccessConf != NULL ; AccessConf = AccessConf->Next) {
      if (MemTableS->PTR == AccessConf) { Bool = TRUE; break; }
      if (MemTableS->PTR == AccessConf->Host) { Bool = TRUE; break; }
      if (MemTableS->PTR == AccessConf->Reason) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }

    for (AccessConf = Deny_Head ; AccessConf != NULL ; AccessConf = AccessConf->Next) {
      if (MemTableS->PTR == AccessConf) { Bool = TRUE; break; }
      if (MemTableS->PTR == AccessConf->Host) { Bool = TRUE; break; }
      if (MemTableS->PTR == AccessConf->Reason) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }

    for (ListenConf = ListenConf_Head ; ListenConf != NULL ; ListenConf = ListenConf->Next) {
      if (MemTableS->PTR == ListenConf) { Bool = TRUE; break; }
      if (MemTableS->PTR == ListenConf->Host) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }

#if USER_CONF
    for (UserConf = UserConf_Head ; UserConf != NULL ; UserConf = UserConf->Next) {
      if (MemTableS->PTR == UserConf) { Bool = TRUE; break; }
      if (MemTableS->PTR == UserConf->User) { Bool = TRUE; break; }
      if (MemTableS->PTR == UserConf->Pass) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }
#endif

    for (ConnConf = ConnConf_Head ; ConnConf != NULL ; ConnConf = ConnConf->Next) {
      if (MemTableS->PTR == ConnConf) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnConf->Name) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnConf->Nick) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnConf->AwayNick) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnConf->User) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnConf->Host) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnConf->Mode) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnConf->Info) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnConf->Chans) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnConf->AwayMsg) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnConf->PublicDetachMsg) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnConf->PublicAttachMsg) { Bool = TRUE; break; }
      for (ConnConfServer = ConnConf->Server_Head ; ConnConfServer != NULL ; ConnConfServer = ConnConfServer->Next) {
        if (MemTableS->PTR == ConnConfServer) { Bool = TRUE; break; }
        if (MemTableS->PTR == ConnConfServer->Host) { Bool = TRUE; break; }
        if (MemTableS->PTR == ConnConfServer->Pass) { Bool = TRUE; break; }
      }
      if (Bool == TRUE) { break; }
    }
    if (Bool == TRUE) { continue; }

    for (ListenS = Listen_Head ; ListenS != NULL ; ListenS = ListenS->Next) {
      if (MemTableS->PTR == ListenS) { Bool = TRUE; break; }
      if (MemTableS->PTR == ListenS->Host) { Bool = TRUE; break; }
      if (MemTableS->PTR == ListenS->HostIPS) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }

    for (ClientS = Client_Head ; ClientS != NULL ; ClientS = ClientS->Next) {
      if (MemTableS->PTR == ClientS) { Bool = TRUE; break; }
      if (MemTableS->PTR == ClientS->Nick) { Bool = TRUE; break; }
      if (MemTableS->PTR == ClientS->User) { Bool = TRUE; break; }
      if (MemTableS->PTR == ClientS->Pass) { Bool = TRUE; break; }
      if (MemTableS->PTR == ClientS->HostName) { Bool = TRUE; break; }
      if (MemTableS->PTR == ClientS->HostIPS) { Bool = TRUE; break; }
      if (MemTableS->PTR == ClientS->RecvBuffer) { Bool = TRUE; break; }
      if (MemTableS->PTR == ClientS->SendBuffer) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }

    for (ConnS = Conn_Head ; ConnS != NULL ; ConnS = ConnS->Next) {
      if (MemTableS->PTR == ConnS) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->Name) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->Nick) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->AwayNick) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->User) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->Host) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->Mode) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->Info) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->Chans) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->AwayMsg) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->PublicDetachMsg) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->PublicAttachMsg) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->HostIPS) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->HostName) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->ServerHostIPS) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->ServerHostName) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->ServerName) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->IRCNick) { Bool = TRUE; break; }
      for (Index = 0 ; Index <= 4 ; Index++) {
        if (MemTableS->PTR == ConnS->Welcome[Index]) { Bool = TRUE; break; }
      }
      if (MemTableS->PTR == ConnS->ISupport) { Bool = TRUE; break; }
      for (Index = 0 ; Index < ConnS->ISupportLines ; Index++) {
        if (MemTableS->PTR == ConnS->ISupport[Index]) { Bool = TRUE; break; }
      }
      if (Bool == TRUE) { break; }
      if (MemTableS->PTR == ConnS->RecvBuffer) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->SendBuffer) { Bool = TRUE; break; }
      if (MemTableS->PTR == ConnS->FileName) { Bool = TRUE; break; }

      for (SendQ = ConnS->SendQ_Head ; SendQ != NULL ; SendQ = SendQ->Next) {
        if (MemTableS->PTR == SendQ) { Bool = TRUE; break; }
        if (MemTableS->PTR == SendQ->Line) { Bool = TRUE; break; }
      }
      if (Bool == TRUE) { break; }

      for (FlushL = ConnS->FlushL_Head ; FlushL != NULL ; FlushL = FlushL->Next) {
        if (MemTableS->PTR == FlushL) { Bool = TRUE; break; }
      }
      if (Bool == TRUE) { break; }

      for (FlushB = ConnS->FlushB_Head ; FlushB != NULL ; FlushB = FlushB->Next) {
        if (MemTableS->PTR == FlushB) { Bool = TRUE; break; }
      }
      if (Bool == TRUE) { break; }

      for (IgnoreS = ConnS->Ignore_Head ; IgnoreS != NULL ; IgnoreS = IgnoreS->Next) {
        if (MemTableS->PTR == IgnoreS) { Bool = TRUE; break; }
        if (MemTableS->PTR == IgnoreS->NUH) { Bool = TRUE; break; }
      }
      if (Bool == TRUE) { break; }

      for (ConnServer = ConnS->Server_Head ; ConnServer != NULL ; ConnServer = ConnServer->Next) {
        if (MemTableS->PTR == ConnServer) { Bool = TRUE; break; }
        if (MemTableS->PTR == ConnServer->Host) { Bool = TRUE; break; }
        if (MemTableS->PTR == ConnServer->Pass) { Bool = TRUE; break; }
      }
      if (Bool == TRUE) { break; }

      for (ChanS = ConnS->Chan_Head ; ChanS != NULL ; ChanS = ChanS->Next) {
        if (MemTableS->PTR == ChanS) { Bool = TRUE; break; }
        if (MemTableS->PTR == ChanS->Chan) { Bool = TRUE; break; }
        for (ChanUser = ChanS->User_Head ; ChanUser != NULL ; ChanUser = ChanUser->Next) {
          if (MemTableS->PTR == ChanUser) { Bool = TRUE; break; }
          if (MemTableS->PTR == ChanUser->Nick) { Bool = TRUE; break; }
          if (MemTableS->PTR == ChanUser->User) { Bool = TRUE; break; }
          if (MemTableS->PTR == ChanUser->Host) { Bool = TRUE; break; }
          if (MemTableS->PTR == ChanUser->NUH) { Bool = TRUE; break; }
        }
        if (Bool == TRUE) { break; }

      }
      if (Bool == TRUE) { break; }

    }
    if (Bool == TRUE) { continue; }

#if IDENT
    if (MemTableS->PTR == Listen_Conf_DefaultUser) { continue; }
    for (IdentConfS = IdentConf_Head ; IdentConfS != NULL ; IdentConfS = IdentConfS->Next) {
      if (MemTableS->PTR == IdentConfS) { Bool = TRUE; break; }
      if (MemTableS->PTR == IdentConfS->Host) { Bool = TRUE; break; }
    }
    for (IdentListenS = IdentListen_Head ; IdentListenS != NULL ; IdentListenS = IdentListenS->Next) {
      if (MemTableS->PTR == IdentListenS) { Bool = TRUE; break; }
      if (MemTableS->PTR == IdentListenS->Host) { Bool = TRUE; break; }
      if (MemTableS->PTR == IdentListenS->HostIPS) { Bool = TRUE; break; }
    }
    for (IdentConnS = IdentConn_Head ; IdentConnS != NULL ; IdentConnS = IdentConnS->Next) {
      if (MemTableS->PTR == IdentConnS) { Bool = TRUE; break; }
      if (MemTableS->PTR == IdentConnS->HostIPS) { Bool = TRUE; break; }
      if (MemTableS->PTR == IdentConnS->RecvBuffer) { Bool = TRUE; break; }
      if (MemTableS->PTR == IdentConnS->SendBuffer) { Bool = TRUE; break; }
    }
    if (Bool == TRUE) { continue; }
#endif

    Leaks++;
    LeaksSize += MemTableS->Size;

    memset(&PTRZSTR, 32, MEMPTRZSTRLEN);
    memset(&BYTESTR, 32, MEMBYTESTRLEN);
    memset(&FILESTR, 32, MEMFILESTRLEN);
    memset(&LINESTR, 32, MEMLINESTRLEN);
    memset(&TIMESTR, 32, MEMTIMESTRLEN);

    Result = snprintf(PTRZSTR, MEMPTRZSTRLEN+1, "%p", MemTableS->PTR);
    if (Result > 0) { PTRZSTR[Result] = 32; }
    PTRZSTR[MEMPTRZSTRLEN] = 0;

    Result = snprintf(BYTESTR, MEMBYTESTRLEN+1, "%ld", (PRINT_SIZE_T) MemTableS->Size);
    if (Result > 0) { BYTESTR[Result] = 32; }
    BYTESTR[MEMBYTESTRLEN] = 0;

    Result = snprintf(FILESTR, MEMFILESTRLEN+1, "%s", MemTableS->File);
    if (Result > 0) { FILESTR[Result] = 32; }
    FILESTR[MEMFILESTRLEN] = 0;

    Result = snprintf(LINESTR, MEMLINESTRLEN+1, "%d", MemTableS->Line);
    if (Result > 0) { LINESTR[Result] = 32; }
    LINESTR[MEMLINESTRLEN] = 0;

    Result = snprintf(TIMESTR, MEMTIMESTRLEN+1, "%ld", (PRINT_TIME_T) MemTableS->Time);
    if (Result > 0) { TIMESTR[Result] = 32; }
    TIMESTR[MEMTIMESTRLEN] = 0;

    sysprint(BITMASK_ERROR, "Memory leak: Hex: %s Size: %s File: %s Line: %s Time: %s", PTRZSTR, BYTESTR, FILESTR, LINESTR, TIMESTR);

  }

  if (Leaks > 0) { sysprint(BITMASK_MAIN, "Memory leaks: %ld size: %ld", Leaks, LeaksSize); }

}



