/*
 * ----------------------------------------------------------------
 * Night Light MKPasswd Crypt tool
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (22.06.2003)
 *
 */

#define MKPASSWD_C

#define _XOPEN_SOURCE 4
#define _XOPEN_VERSION 4

#define NEED_SYS_TYPES_H 1		/* Extra types */
#define NEED_SYS_PARAM_H 1		/* Some systems need this */
#define NEED_LIMITS_H 0			/* Kernel limits */
#define NEED_STDARG_H 0			/* va_list, etc */
#define NEED_ERRNO_H 0			/* errno */
#define NEED_CTYPE_H 0			/* isdigit(), etc */
#define NEED_NETINET_IN_H 0		/* in_addr, sockaddr_in, etc */
#define NEED_ARPA_INET_H 0		/* inet_ntoa(), inet_aton(), etc */
#define NEED_STDIO_H 1			/* Standard C UNIX functions */
#define NEED_STDLIB_H 1			/* malloc(), exit(), atoi(), etc */
#define NEED_TIME_H 0			/* time(), etc */
#define NEED_SYSCTL_H 0			/* sysctl(), etc */
#define NEED_SYS_STAT_H 0		/* chmod(), mkdir(), etc */
#define NEED_SYS_UIO_H 0		/* iovec, etc */
#define NEED_FCNTL_H 0			/* open(), creat(), fcntl(), etc */
#define NEED_SYS_IOCTL_H 0		/* ioctl(), etc */
#define NEED_SYS_FILIO_H 0		/* Solaris need this for ioctl(), etc */
#define NEED_UNISTD_H 1			/* Unix standard functions */
#define NEED_STRING_H 1			/* C string functions */
#define NEED_SIGNAL_H 0			/* Signal functions */
#define NEED_SYS_SOCKET_H 0		/* Socket functions */
#define NEED_NETDB_H 0			/* Network database functions */
#define NEED_ARPA_NAMESER_H 0		/* Nameserver definitions */
#define NEED_GETUSERPW_HEADERS 0 	/* Functions to retrive system passwords */
#define NEED_CRYPT 1			/* Some systems declare crypt() here */

#include "includes.h"
#include "nlcrypt.h"

int main(int argc, char *argv[]);

#if !HAVE_DECL_CRYPT
  char *crypt(const char *key, const char *salt);
#endif

int main(int argc, char *argv[]) {

  char Chars[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./";
  float Len = strlen(Chars);
  unsigned short int Index = 0;
  char Salt[3] = "";
  char *CryptPT = NULL;
  char *PlainTextPT = NULL;

  printf("Password encryptor v%s.\n", VERSION);
  printf("Copyright (C) 2000-2003 Jonas Kvinge, all rights reserved.\n");
  printf("\n");

  srand(NOW);

  if (argc < 2) {
    Index = (unsigned int) (Len * rand() / (RAND_MAX + 1.0));
    Salt[0] = Chars[Index];
    Index = (unsigned int) (Len * rand() / (RAND_MAX + 1.0));
    Salt[1] = Chars[Index];
    Salt[2] = '\0';
    printf("Using random salt: '%s'\n", Salt);
  }
  else {
    Salt[0] = argv[1][0];
    Salt[1] = argv[1][1];
    Salt[2] = '\0';
    if ((strchr(Chars, Salt[0]) == NULL) || (strchr(Chars, Salt[1]) == NULL)) {
      fprintf(stderr, "Error: Illegal salt: '%s'\n", Salt);
      exit(0);
    }
    printf("Using salt: '%s'\n", Salt);
  }

  PlainTextPT = getpass("Enter password: ");
  if (PlainTextPT == NULL) { return(0); }
  if (strcmp(PlainTextPT, "") == 0) {
    printf("Error: Invalid password.\n");
    exit(0);
  }

  CryptPT = crypt(PlainTextPT, Salt);
  printf("Encrypted password: %s\n", CryptPT);

  return(0);

}

