/*
 * ----------------------------------------------------------------
 * Night Light String Functions
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (06.10.2001)
 *
 */

#define STRCALLS_C

#define NEED_SYS_TYPES_H 1		/* Extra types */
#define NEED_SYS_PARAM_H 1		/* Some systems need this */
#define NEED_LIMITS_H 1			/* Kernel limits */
#define NEED_STDARG_H 1			/* va_list, etc */
#define NEED_ERRNO_H 1			/* errno */
#define NEED_CTYPE_H 1			/* isdigit(), etc */
#define NEED_NETINET_IN_H 0		/* in_addr, sockaddr_in, etc */
#define NEED_ARPA_INET_H 0		/* inet_ntoa(), inet_aton(), etc */
#define NEED_STDIO_H 1			/* Standard C UNIX functions */
#define NEED_STDLIB_H 1			/* malloc(), exit(), atoi(), etc */
#define NEED_TIME_H 1			/* time(), etc */
#define NEED_SYSCTL_H 0			/* sysctl(), etc */
#define NEED_SYS_STAT_H 1		/* chmod(), mkdir(), etc */
#define NEED_SYS_UIO_H 0		/* iovec, etc */
#define NEED_FCNTL_H 1			/* open(), creat(), fcntl(), etc */
#define NEED_SYS_IOCTL_H 0		/* ioctl(), etc */
#define NEED_SYS_FILIO_H 0		/* Solaris need this for ioctl(), etc */
#define NEED_UNISTD_H 1			/* Unix standard functions */
#define NEED_STRING_H 1			/* C string functions */
#define NEED_SIGNAL_H 0			/* Signal functions */
#define NEED_SYS_SOCKET_H 0		/* Socket functions */
#define NEED_NETDB_H 0			/* Network database functions */
#define NEED_ARPA_NAMESER_H 0		/* Nameserver definitions */
#define NEED_GETUSERPW_HEADERS 0 	/* Functions to retrive system passwords */

#include "includes.h"

/* VARIABLES - JONAS (023.08.2001) */

const char STRCALLS_VERSION[] = "1.1.5d";

static char DATESTAMP[DATESTAMPLEN+1] = "[00/00/0000]";
static char TIMESTAMP[TIMESTAMPLEN+1] = "[00:00:00]";
static char DTSTAMP[DTSTAMPLEN+1] = "[00/00/0000 00:00:00]";
static char * const DATESTAMPPT = DATESTAMP;
static char * const TIMESTAMPPT = TIMESTAMP;
static char * const DTSTAMPPT = DTSTAMP;
static time_t DateStampTime = 0;
static time_t TimeStampTime = 0;
static time_t DTStampTime = 0;

const char *StrAErrNo[] = {

  "Success",
  "Invalid",
  "Exists",
  "Memory allocation failure",
  "No match"
  "No resources",
  "In progress"

};

/* STRAERROR FUNCTION - JONAS (01.07.2000) */

const char *const straerror(unsigned short int aerrnocode) {

  assert(aerrnocode < (sizeof(StrAErrNo) / sizeof(*StrAErrNo)));

  return(StrAErrNo[aerrnocode]);

}

/* STRISVALIDHOST - JONAS (28.08.2000) */

unsigned short int strisvalidhost(const char *const StringPT) {

  unsigned short int Index = 0;

  Index = strspn(StringPT, STRHOSTCHARS);
  if (Index < strlen(StringPT)) {
    snprintf(StrResult, LINELEN+1, STRHOSTINVALIDCHAR, StringPT[Index]);
    return(FALSE);
  }
  if (strlen(StringPT) > HOSTLEN) {
    snprintf(StrResult, LINELEN+1, STRHOSTMAXCHARS, HOSTLEN);
    return(FALSE);
  }

  return(TRUE);

}

/* STRISVALIDFILE - JONAS (28.08.2000) */

unsigned short int strisvalidfile(const char *const StringPT) {

  unsigned short int Index = 0;

  Index = strspn(StringPT, FILECHARS);
  if (Index < strlen(StringPT)) {
    snprintf(StrResult, LINELEN+1, STRFILEINVALIDCHAR, StringPT[Index]);
    return(FALSE);
  }
  if (strlen(StringPT) > FILELEN) {
    snprintf(StrResult, LINELEN+1, STRFILEMAXCHARS, FILELEN);
    return(FALSE);
  }

  return(TRUE);

}

/* STRRESULT - JONAS (28.08.2000) */

const char *const strresult(void) {

  return(StrResult);

}

/* MYSTRDUP FUNCTION - JONAS (12.07.2001) */

char *mystrdup(const char *const FilePT, const unsigned short int Line, const char *const FunctionPT, const char *StringPT) {

  void *PTR = NULL;

#if MEMDEBUG
  PTR = memalloc(FilePT, Line, FunctionPT, strlen(StringPT) + 1);
#else
  PTR = malloc(strlen(StringPT) + 1);
#endif
  if (PTR != NULL) { strcpy(PTR, StringPT); }
  return(PTR);

}

/* MYSTRREALLOC FUNCTION - JONAS (12.07.2001) */

char *mystrrealloc(const char *FilePT, const unsigned long int Line, const char *const FunctionPT, char *OldPointer, const char *StringPT) {

  size_t OldLen = 0;
  size_t NewLen = 0;
  char *NewPointer = NULL;

  if ((OldPointer == NULL) && (StringPT == NULL)) {
    aerrno = AESUCCESS;
    return(NULL);
  }

  if (OldPointer == NULL) { OldLen = 0; }
  else {
    OldLen = strlen(OldPointer);
    if (OldLen != 0) { OldLen++; }
  }

  if (StringPT == NULL) { NewLen = 0; }
  else {
    NewLen = strlen(StringPT);
    if (NewLen != 0) { NewLen++; }
  }

  if ((OldLen > 0) && (NewLen > 0) && (OldLen == NewLen)) {
    if (strcmp(StringPT, OldPointer) != FALSE) { strcpy(OldPointer, StringPT); }
    aerrno = AESUCCESS;
    return(OldPointer);
  }

  if (NewLen == 0) {
    free(OldPointer);
    return(NULL);
  }

#if MEMDEBUG
  NewPointer = memrealloc(FilePT, Line, FunctionPT, OldPointer, NewLen);
#else
  NewPointer = realloc(OldPointer, NewLen);
#endif
  if (NewPointer == NULL) {
    aerrno = AEMALLOC;
    return(OldPointer);
  }

  strcpy(NewPointer, StringPT);

  aerrno = AESUCCESS;
  return(NewPointer);

}

/* MYSTRSPN FUNCTION - JONAS (23.07.2000) */

size_t mystrspn(const char *StringPT, const char *AcceptPT) {

  size_t Count = 0;

  assert(StringPT != NULL);
  assert(AcceptPT != NULL);

  for (Count = 0 ; *StringPT != 0 ; ++StringPT) {
    if (strchr(AcceptPT, *StringPT) == NULL) { return(Count); }
    ++Count;
  }
  return(Count);

}

/* MYSTRWM FUNCTION - JONAS (08.07.2000) */

unsigned short int mystrwm(const char *FilePT, const unsigned long int Line, const char *const FunctionPT, const char *PatternPT, const char *StringPT, unsigned short int Internal) {

  char Char1 = 0;
  char Char2 = 0;
  const char *DummyPT = NULL;
  unsigned short int Escape = 0;

  assert(PatternPT != NULL);
  assert(StringPT != NULL);

  if (Internal == FALSE) {
    WMChars = 0;
    #if 0
      sysprint("MYSTRWM: PATTERN: %s STRING: %s", PatternPT, StringPT);
    #endif
  }

  FOREVERLOOP {
    Char1 = tolower((int) *PatternPT);
    Char2 = tolower((int) *StringPT);
    PatternPT++;
    switch (Char1) {
    case 0:
      if (*StringPT == 0) { return(TRUE); }
      return(FALSE);
    case 92:
      if (Escape == FALSE) {
        Escape = TRUE;
        break;
      }
    case '?':
      if (Escape == FALSE) {
        if (Char2 == '*') { return(FALSE); } /* IM NOT 100% SURE ABOUT THIS */
        StringPT++;
        WMChars++;
        break;
      }
    case '*':
      if (Escape == FALSE) {
        if (*PatternPT == 0) {
          WMChars += strlen(StringPT);
          return(TRUE);
        }
        for (DummyPT = StringPT ; *DummyPT != 0 ; DummyPT++) {
  	if ((tolower((int) *DummyPT) == tolower((int) *PatternPT)) && (mystrwm(FilePT, Line, FunctionPT, PatternPT, DummyPT, TRUE) == TRUE)) { return(TRUE); }
          WMChars++;
        }
        break;
      }
    default:
      Escape = FALSE;
      if (Char1 != Char2) { return(FALSE); }
      StringPT++;
      break;
    }
  }
}

/* STRLOWER FUNCTION - JONAS (01.03.2000) */

void strlower(char *StringPT) {

  assert(StringPT != NULL);

  for (; *StringPT != 0 ; StringPT++) {
    *StringPT = tolower((int) StringPT[0]);
  }

}

/* STRUPPER FUNCTION - JONAS (01.03.2000) */

void strupper(char *StringPT) {

  assert(StringPT != NULL);

  for (; *StringPT != 0 ; StringPT++) { *StringPT = toupper((int) *StringPT); }

}

/* STRDIGIT FUNCTION - JONAS (01.03.2000) */

unsigned short int strdigit(const char *StringPT) {

  assert(StringPT != NULL);

  for (; *StringPT != 0 ; StringPT++) {
    if (isdigit((int) *StringPT) != FALSE) { continue; }
    else { return(FALSE); }
  }
  return(TRUE);

}

/* STRISIP FUNCTION - JONAS (01.03.2000) */

unsigned short int strip(const char *StringPT) {

  assert(StringPT != NULL);

  for (; *StringPT != 0 ; StringPT++) {
    if ((isdigit((int) *StringPT) != FALSE) || (*StringPT == '.')) { continue; }
    else { return(FALSE); }
  }
  return(TRUE);

}

/* STRRND FUNCTION - JONAS (27.06.2001) */

void strrnd(char *StringPT, const unsigned short int Len) {

  unsigned short int Index = 0;

  assert(StringPT != NULL);

  for (Index = 0 ; Index < Len ; ++Index) {
    StringPT[Index] = 97 + (int) (26.0 * rand() / (RAND_MAX + 1.0));
  }

  StringPT[Index] = '\0';

}

/* DATESTAMP FUNCTION - JONAS (23.07.2000) */

const char *const datestamp(void) {

  time_t Duration = 0;
  struct tm *TMPT = NULL;

  Duration = NOW - DateStampTime;
  if (Duration == 0) { return(DATESTAMP); }

  DateStampTime = NOW;

  TMPT = localtime(&NOW);

  strftime(DATESTAMPPT, DATESTAMPLEN+1, "[%d/%m/%Y]", TMPT);

  return(DATESTAMPPT);

}

/* TIMESTAMP FUNCTION - JONAS (23.07.2000) */

const char *const timestamp(void) {

  time_t Duration = 0;
  struct tm *TMPT = NULL;

  Duration = NOW - TimeStampTime;
  if (Duration == 0) { return(TIMESTAMP); }

  TimeStampTime = NOW;

  TMPT = localtime(&NOW);

  strftime(TIMESTAMPPT, TIMESTAMPLEN+1, "[%H:%M:%S]", TMPT);

  return(TIMESTAMPPT);

}

/* DTSTAMP FUNCTION - JONAS (23.07.2000) */

const char *const dtstamp(void) {

  time_t Duration = 0;
  struct tm *TMPT = NULL;

  Duration = NOW - DTStampTime;
  if (Duration == 0) { return(DTSTAMP); }

  DTStampTime = NOW;

  TMPT = localtime(&NOW);

  strftime(DTSTAMPPT, DTSTAMPLEN+1, "[%d/%m/%Y %H:%M:%S]", TMPT);

  return(DTSTAMPPT);

}

/* STRDURATION FUNCTION - JONAS (23.07.2000) */

const char *const strduration(const time_t Time) {

  char String[STRDURATIONLEN+1] = "";
  char Return[STRDURATIONLEN+1] = "";

  if (Time <= FOREVER) {
    STRDURATION = strrealloc(STRDURATION, "N/A (FOREVER)");
    return(STRDURATION);
  }

  if (Time < ONESECOND) {
    snprintf(String, STRDURATIONLEN+1, "N/A");
  }
  else if (Time < ONEMINUTE) {
    snprintf(String, STRDURATIONLEN+1, "%ld second%s", (PRINT_TIME_T) Seconds(Time), OneOrMore(Seconds(Time)));
  }
  else if (Time < ONEHOUR) {
    if (Seconds(Time) == 0) { snprintf(String, STRDURATIONLEN+1, "%ld minute%s", (PRINT_TIME_T) Minutes(Time), OneOrMore(Minutes(Time))); }
    else { snprintf(String, STRDURATIONLEN+1, "%ld minute%s and %ld second%s", (PRINT_TIME_T) Minutes(Time), OneOrMore(Minutes(Time)), (PRINT_TIME_T) Seconds(Time), OneOrMore(Seconds(Time))); }
  }
  else if (Time < ONEDAY) {
    if ((Minutes(Time) == 0) && (Seconds(Time) == 0)) { snprintf(String, STRDURATIONLEN+1, "%ld hour%s", (PRINT_TIME_T) Hours(Time), OneOrMore(Hours(Time))); }
    else if (Minutes(Time) == 0) { snprintf(String, STRDURATIONLEN+1, "%ld hour%s and %ld second%s", (PRINT_TIME_T) Hours(Time), OneOrMore(Hours(Time)), (PRINT_TIME_T) Seconds(Time), OneOrMore(Seconds(Time))); }
    else if (Seconds(Time) == 0) { snprintf(String, STRDURATIONLEN+1, "%ld hour%s and %ld minute%s", (PRINT_TIME_T) Hours(Time), OneOrMore(Hours(Time)), (PRINT_TIME_T) Minutes(Time), OneOrMore(Minutes(Time))); }
    else { snprintf(String, STRDURATIONLEN+1, "%ld hour%s, %ld minute%s and %ld second%s", (PRINT_TIME_T) Hours(Time), OneOrMore(Hours(Time)), (PRINT_TIME_T) Minutes(Time), OneOrMore(Minutes(Time)), (PRINT_TIME_T) Seconds(Time), OneOrMore(Seconds(Time))); }
  }
  else {
    if (Hours(Time) == 0) {
      if (Minutes(Time) == 0) {
        if (Seconds(Time) == 0) { snprintf(String, STRDURATIONLEN+1, "%ld day%s", (PRINT_TIME_T) Days(Time), OneOrMore(Days(Time))); }
        else { snprintf(String, STRDURATIONLEN+1, "%ld day%s and %ld second%s", (PRINT_TIME_T) Days(Time), OneOrMore(Days(Time)), (PRINT_TIME_T) Seconds(Time), OneOrMore(Seconds(Time))); }
      }
      else {
        if (Seconds(Time) == 0) { snprintf(String, STRDURATIONLEN+1, "%ld day%s and %ld minute%s", (PRINT_TIME_T) Days(Time), OneOrMore(Days(Time)), (PRINT_TIME_T) Minutes(Time), OneOrMore(Minutes(Time))); }
        else { snprintf(String, STRDURATIONLEN+1, "%ld day%s, %ld minute%s and %ld second%s", (PRINT_TIME_T) Days(Time), OneOrMore(Days(Time)), (PRINT_TIME_T) Minutes(Time), OneOrMore(Minutes(Time)), (PRINT_TIME_T) Seconds(Time), OneOrMore(Seconds(Time))); }
      }
    }
    else {
      if (Minutes(Time) == 0) {
        if (Seconds(Time) == 0) { snprintf(String, STRDURATIONLEN+1, "%ld day%s and %ld hour%s", (PRINT_TIME_T) Days(Time), OneOrMore(Days(Time)), (PRINT_TIME_T) Hours(Time), OneOrMore(Hours(Time))); }
        else { snprintf(String, STRDURATIONLEN+1, "%ld day%s, %ld hour%s and %ld second%s", (PRINT_TIME_T) Days(Time), OneOrMore(Days(Time)), (PRINT_TIME_T) Hours(Time), OneOrMore(Hours(Time)), (PRINT_TIME_T) Seconds(Time), OneOrMore(Seconds(Time))); }
      }
      else {
        if (Seconds(Time) == 0) { snprintf(String, STRDURATIONLEN+1, "%ld day%s, %ld hour%s and %ld minute%s", (PRINT_TIME_T) Days(Time), OneOrMore(Days(Time)), (PRINT_TIME_T) Hours(Time), OneOrMore(Hours(Time)), (PRINT_TIME_T) Minutes(Time), OneOrMore(Minutes(Time))); }
        else { snprintf(String, STRDURATIONLEN+1, "%ld day%s, %ld hour%s, %ld minute%s and %ld second%s", (PRINT_TIME_T) Days(Time), OneOrMore(Days(Time)), (PRINT_TIME_T) Hours(Time), OneOrMore(Hours(Time)), (PRINT_TIME_T) Minutes(Time), OneOrMore(Minutes(Time)), (PRINT_TIME_T) Seconds(Time), OneOrMore(Seconds(Time))); }
      }
    }
  }

  snprintf(Return, STRDURATIONLEN+1, "%s (%ld)", String, (PRINT_TIME_T) Time);

  STRDURATION = strrealloc(STRDURATION, Return);

  return(STRDURATION);

}

/* STRGETUNAMEINFO FUNCTION - JONAS (01.07.2000) */

#if !WIN32
void strgetunameinfo(void) {

  char Result[RECVBUFFERLEN+1] = "";

  if (UNAMEINFO != NULL) { free(UNAMEINFO); }
  sysrun("uname -a", Result);
  if (strcmp(Result, "") == FALSE) { UNAMEINFO = strdup("unknown"); }
  else {
    if (Result[strlen(Result)-1] == 10) { Result[strlen(Result)-1] = 0; }
    UNAMEINFO = strdup(Result);
  }
  assert(UNAMEINFO != NULL);

}

/* STRGETPLATFORM FUNCTION - JONAS (01.07.2000) */

void strgetplatform(void) {

  char Result[RECVBUFFERLEN+1] = "";

  if (PLATFORM != NULL) { free(PLATFORM); }
  sysrun("uname -m", Result);
  if (strcmp(Result, "") == FALSE) { PLATFORM = strdup("unknown"); }
  else {
    if (Result[strlen(Result)-1] == 10) { Result[strlen(Result)-1] = 0; }
    PLATFORM = strdup(Result);
  }
  assert(PLATFORM != NULL);

}

/* STRGETOSNAME FUNCTION - JONAS (01.07.2000) */

void strgetosname(void) {

  char Result[RECVBUFFERLEN+1] = "";

  if (OSNAME != NULL) { free(OSNAME); }
  sysrun("uname -s", Result);
  if (strcmp(Result, "") == FALSE) { OSNAME = strdup("unknown"); }
  else {
    if (Result[strlen(Result)-1] == 10) { Result[strlen(Result)-1] = 0; }
    OSNAME = strdup(Result);
  }
  assert(OSNAME != NULL);

}

/* STRGETOSRELEASE FUNCTION - JONAS (01.07.2000) */

void strgetosrelease(void) {

  char Result[RECVBUFFERLEN+1] = "";

  if (OSRELEASE != NULL) { free(OSRELEASE); }
  sysrun("uname -r", Result);
  if (strcmp(Result, "") == FALSE) { OSRELEASE = strdup("unknown"); }
  else {
    if (Result[strlen(Result)-1] == 10) { Result[strlen(Result)-1] = 0; }
    OSRELEASE = strdup(Result);
  }
  assert(OSRELEASE != NULL);

}
#endif

/* STRGETHOSTNAME FUNCTION - JONAS (01.07.2000) */

void strgethostname(void) {

  char Host[HOSTLEN+1] = "";

#if 0
  char Result[RECVBUFFERLEN+1] = "";

  if (HOSTNAME != NULL) { free(HOSTNAME); }
  sysrun("uname -n", Result);
  if (strcmp(Result, "") == FALSE) { HOSTNAME = strdup("unknown"); }
  else {
    if (Result[strlen(Result)-1] == 10) { Result[strlen(Result)-1] = 0; }
    HOSTNAME = strdup(Result);
  }
  assert(HOSTNAME != NULL);
#endif

  gethostname(Host, HOSTLEN);
  HOSTNAME = strdup(Host);

}

/* STRADDBUFFER FUNCTION - JONAS (01.07.2000) */

char *straddbuffer(char *StringPT, const char *const BufferPT, const unsigned long int MaxStringLen, const unsigned short int AddLen) {

  unsigned long int StringLen = 0;
  unsigned long int BufferLen = 0;
  unsigned long int NewStringLen = 0;
  char *TempPT = NULL;

  assert(BufferPT != NULL);

  if (StringPT == NULL) { StringLen = 0; }
  else { StringLen = strlen(StringPT); }

  BufferLen = strlen(BufferPT);

  NewStringLen = StringLen + BufferLen + AddLen;
  if (NewStringLen > MaxStringLen) {
    aerrno = AENORESOURCE;
    return(StringPT);
  }

  TempPT = realloc(StringPT, (NewStringLen + 1));
  if (TempPT == NULL) {
    aerrno = AEMALLOC;
    return(StringPT);
  }
  StringPT = TempPT;

  TempPT += StringLen;
  strcpy(TempPT, BufferPT);

  aerrno = AESUCCESS;
  return(StringPT);

}

/* STRCLEANUP FUNCTION - JONAS (01.07.2000) */

void strcleanup(void) {

  sysprint(BITMASK_DEBUG_STRCALLS, "Freeing %s allocated memory.", __FILE__);

  FREE(UNAMEINFO);
  FREE(PLATFORM);
  FREE(HOSTNAME);
  FREE(OSNAME);
  FREE(OSRELEASE);
  FREE(STRDURATION);

}

