/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy User Configuration System
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (27.02.2002)
 *
 */

#define USER_CONF_C

#define NEED_SYS_TYPES_H 1		/* Extra types */
#define NEED_SYS_PARAM_H 1		/* Some systems need this */
#define NEED_LIMITS_H 0			/* Kernel limits */
#define NEED_STDARG_H 1			/* va_list, etc */
#define NEED_ERRNO_H 1			/* errno */
#define NEED_CTYPE_H 0			/* isdigit(), etc */
#define NEED_NETINET_IN_H 0		/* in_addr, sockaddr_in, etc */
#define NEED_ARPA_INET_H 0		/* inet_ntoa(), inet_aton(), etc */
#define NEED_STDIO_H 1			/* Standard C UNIX functions */
#define NEED_STDLIB_H 1			/* malloc(), exit(), atoi(), etc */
#define NEED_TIME_H 1			/* time(), etc */
#define NEED_SYSCTL_H 0			/* sysctl(), etc */
#define NEED_SYS_STAT_H 0		/* chmod(), mkdir(), etc */
#define NEED_SYS_UIO_H 0		/* iovec, etc */
#define NEED_FCNTL_H 1			/* open(), creat(), fcntl(), etc */
#define NEED_SYS_IOCTL_H 0		/* ioctl(), etc */
#define NEED_SYS_FILIO_H 0		/* Solaris need this for ioctl(), etc */
#define NEED_UNISTD_H 1			/* Unix standard functions */
#define NEED_STRING_H 1			/* C string functions */
#define NEED_SIGNAL_H 0			/* Signal functions */
#define NEED_SYS_SOCKET_H 0		/* Socket functions */
#define NEED_NETDB_H 0			/* Network database functions */
#define NEED_ARPA_NAMESER_H 0		/* Nameserver definitions */
#define NEED_GETUSERPW_HEADERS 0 	/* Functions to retrive system passwords */

#include "includes.h"

#include "nlcrypt.h"

#include "user_conf.h"
#include "client_io.h"

#if !USER_CONF
  #error "USER_CONF not defined."
#endif

/* VARIABLES - JONAS (31.07.2001) */

unsigned long int UserConfs = 0;

struct UserConf_Struct *UserConf_Head = NULL;
struct UserConf_Struct *UserConf_Tail = NULL;

extern struct Client_Struct *Client_Head;

#define MSG_CONF_ERROR_MOREDATA			"User configuration error, file %s line %d: Expecting more data."
#define MSG_CONF_ERROR_INVALIDENT		"User configuration error, file %s line %d: Invalid entry: \"%s\"."

/* USER_CONF_READ FUNCTION - JONAS (31.07.2001) */

signed long int user_conf_read(void) {

  char File[FILELEN+1] = "";
  FILE *FilePT = NULL;

  char *TempPT = NULL;

  char Line[LINELEN+1] = "";
  char *LinePT = NULL;

  unsigned short int Count = 0;

  char *EntryPT = NULL;
  char *UserPT = NULL;
  char *PassPT = NULL;

  sysprint(BITMASK_CONF, "Reading user configuration file.");

  if (USER_CONFFILE[0] != '/') {
    strncat(File, DATAPATH, FILELEN);
    if (DATAPATH[strlen(DATAPATH)] != '/') { strncat(File, "/", (FILELEN - strlen(File))); }
  }
  strncat(File, USER_CONFFILE, (FILELEN - strlen(File)));

  FilePT = fopen(File, "r");
  if (FilePT == NULL) {
    sysprint(BITMASK_ERROR, "Unable to open user configuration file %s: [%d] %s", File, errno, strerror(errno));
    return(ERROR);
  }

  user_conf_remall();

  FOREVERLOOP {

    memset(&Line, 0, LINELEN+1);
    TempPT = fgets(Line, LINELEN, FilePT);
    if (TempPT == NULL) { break; }
    ++Count;
    LinePT = Line;

    while ((TempPT = strchr(LinePT, '\r')) != NULL) { *TempPT = '\0'; }
    while ((TempPT = strchr(LinePT, '\n')) != NULL) { *TempPT = '\0'; }
    while ((TempPT = strchr(LinePT, '\t')) != NULL) { *TempPT = ' '; }

    while ((LinePT[0] == ' ') || (LinePT[0] == '\t')) { ++LinePT; }
    if ((LinePT[0] == '#') || (LinePT[0] == ';') || (LinePT[0] == '\0')) { continue; }

    EntryPT = LinePT;
    StrMovePastToken(LinePT, ':');
    if (strcasecmp(EntryPT, "USER") != FALSE) { sysprint(BITMASK_ERROR, MSG_CONF_ERROR_INVALIDENT, File, Count, EntryPT); continue; }

    StrPrintErrorIfNull(LinePT, File, Count, MSG_CONF_ERROR_MOREDATA);
    UserPT = LinePT;
    StrMovePastToken(LinePT, ':');

    StrPrintErrorIfNull(LinePT, File, Count, MSG_CONF_ERROR_MOREDATA);
    PassPT = LinePT;
    StrMovePastToken(LinePT, ':');

    user_conf_add(UserPT, PassPT);

  }
  fclose(FilePT);

  return(UserConfs);

}

/* USER_CONF_ADD - JONAS (31.07.2001) */

struct UserConf_Struct *user_conf_add(const char *const UserPT, const char *const PassPT) {

  struct UserConf_Struct *UserConf = NULL;
  struct UserConf_Struct *UserConf_NEW = NULL;

  assert(UserPT != NULL);
  assert(PassPT != NULL);

  sysprint(BITMASK_CONF, "Adding user: User: %s - Password: %s.", UserPT, PassPT);

  UserConf = user_conf_get(UserPT);
  if (UserConf != NULL) {
    aerrno = AEEXISTS;
    return(UserConf);
  }

  UserConf_NEW = malloc(sizeof(struct UserConf_Struct));
  if (UserConf_NEW == NULL) {
    aerrno = AEMALLOC;
    return(NULL);
  }

  memset(UserConf_NEW, 0, sizeof(struct UserConf_Struct));

  UserConf_NEW->User = strdup(UserPT);
  UserConf_NEW->Pass = strdup(PassPT);

  if ((UserConf_NEW->User == NULL) || (UserConf_NEW->Pass == NULL)) {
    free(UserConf_NEW->User);
    free(UserConf_NEW->Pass);
    free(UserConf_NEW);
    aerrno = AEMALLOC;
    return(NULL);
  }

  if (UserConf_Head == NULL) {
    UserConf_Head = UserConf_NEW;
    UserConf_Tail = UserConf_NEW;
  }
  else {
    UserConf = UserConf_Tail;
    UserConf->Next = UserConf_NEW;
    UserConf_NEW->Prev = UserConf;
    UserConf_Tail = UserConf_NEW;
  }

  UserConfs++;

  aerrno = AESUCCESS;
  return(UserConf_NEW);

}

/* USER_CONF_REM FUNCTION - JONAS (31.07.2001) */

void user_conf_rem(struct UserConf_Struct *UserConf) {

  struct Client_Struct *ClientS = NULL;

  assert(UserConf != NULL);

  if (UserConf->Prev == NULL) { UserConf_Head = UserConf->Next; }
  else { UserConf->Prev->Next = UserConf->Next; }

  if (UserConf->Next == NULL) { UserConf_Tail = UserConf->Prev; }
  else { UserConf->Next->Prev = UserConf->Prev; }

  free(UserConf->User);
  free(UserConf->Pass);
  free(UserConf);

  for (ClientS = Client_Head ; ClientS != NULL ; ClientS = ClientS->Next) {
    if (ClientS->UserConf == UserConf) { ClientS->UserConf = NULL; }
  }

  UserConfs--;

}

/* USER_CONF_GET FUNCTION - JONAS (31.07.2001) */

struct UserConf_Struct *user_conf_get(const char *const UserPT) {

  struct UserConf_Struct *UserConf = NULL;

  assert(UserPT != NULL);

  for (UserConf = UserConf_Head ; UserConf != NULL ; UserConf = UserConf->Next) {
    if (strcasecmp(UserConf->User, UserPT) == FALSE) {
      aerrno = AESUCCESS;
      return(UserConf);
    }
  }
  aerrno = AENOMATCH;
  return(NULL);

}

/* USER_CONF_REMALL FUNCTION - JONAS (31.07.2001) */

void user_conf_remall(void) {

  while (UserConf_Head != NULL) { user_conf_rem(UserConf_Head); }

}
