/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Access Configuration System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (18.07.2001)
 *
 */

#ifdef ACCESS_CONF_H
#warning "access_conf.h already included."
#else
#define ACCESS_CONF_H

#define ACCESS_ALLOW 1
#define ACCESS_DENY 2

#define ACCESS_CONF_NOREASON				"No reason given."
#define ACCESS_CONF_USERFLOOD				"User flooding detected."
#define ACCESS_CONF_SENDQFLOOD				"Maximum allowed SendQ exceeded"

/* STRUCTURES - JONAS (18.07.2001) */

struct AccessConf_Struct {

  char *Host;
  char *Reason;

  struct AccessConf_Struct *Prev;
  struct AccessConf_Struct *Next;

};

/* FUNCTION PROTOTYPES - JONAS (18.07.2001) */

signed long int access_conf_read(void);
struct AccessConf_Struct *access_conf_addallow(const char *const HostPT, const char *const ReasonPT);
void access_conf_remallow(struct AccessConf_Struct *AccessConf);
struct AccessConf_Struct *access_conf_adddeny(const char *const HostPT, const char *const ReasonPT);
void access_conf_remdeny(struct AccessConf_Struct *AccessConf);
void access_conf_remall(void);

#endif
