/*
 * ----------------------------------------------------------------
 * Night Light Asynchrounous DNS Resolver
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (30.07.2001)
 *
 */

#ifdef ARES_INT_H
#warning "ares_int.h already included."
#else
#define ARES_INT_H

/* CONFIGURATION - JONAS (30.07.2001) */

#define	ARES_TIMEOUT				300
#define ARES_TRIES				4

#define ARES_SERVER_TIMEOUT			60

#if WIN32
  #define RESOLVCONFFILE			"./resolv.conf"
  #define HOSTSFILE				"./hosts"
#else
  #define RESOLVCONFFILE			"/etc/resolv.conf"
  #define HOSTSFILE				"/etc/hosts"
#endif

#define ARES_UDP_CONNECTWAIT			120
#define ARES_TCP_CONNECTWAIT			120

#define ARES_SOCKKEEPALIVEOPT			TRUE

#define ARES_ATCP				FALSE

#define ARES_QUERY_MAX				10000

/* BIT_MASKS - JONAS (05.07.2000) */

#define ARES_CONNECTPROC			2
#define ARES_SOCKET				4
#define ARES_SOCKOPT				8
#define ARES_KEEPALIVEOPT			16
#define ARES_BOUND				32
#define ARES_CONNECTING				64
#define ARES_CONNECTED				128
#define ARES_SOCKNAME				256
#define ARES_PEERNAME				512

/* MACROS - JONAS (05.07.2000) */

#define Ares_SetConnectProc(x)			((x) |= ARES_CONNECTPROC)
#define Ares_SetServer(x)			((x) |= ARES_SERVER)
#define Ares_SetSocket(x)			((x) |= ARES_SOCKET)
#define Ares_SetSockOPT(x)			((x) |= ARES_SOCKOPT)
#define Ares_SetKeepAliveOPT(x)			((x) |= ARES_KEEPALIVEOPT)
#define Ares_SetBound(x)			((x) |= ARES_BOUND)
#define Ares_SetConnecting(x)			((x) |= ARES_CONNECTING)
#define Ares_SetConnected(x)			((x) |= ARES_CONNECTED)
#define Ares_SetSockName(x)			((x) |= ARES_SOCKNAME)
#define Ares_SetPeerName(x)			((x) |= ARES_PEERNAME)

#define Ares_ClearConnectProc(x)		((x) &= ~ARES_CONNECTPROC)
#define Ares_ClearServer(x)			((x) &= ~ARES_SERVER)
#define Ares_ClearSocket(x)			((x) &= ~ARES_SOCKET)
#define Ares_ClearSockOPT(x)			((x) &= ~ARES_SOCKOPT)
#define Ares_ClearKeepAliveOPT(x)		((x) &= ~ARES_KEEPALIVEOPT)
#define Ares_ClearBound(x)			((x) &= ~ARES_BOUND)
#define Ares_ClearConnecting(x)			((x) &= ~ARES_CONNECTING)
#define Ares_ClearConnected(x)			((x) &= ~ARES_CONNECTED)
#define Ares_ClearSockName(x)			((x) &= ~ARES_SOCKNAME)
#define Ares_ClearPeerName(x)			((x) &= ~ARES_PEERNAME)

#define Ares_IsConnectProc(x)			((x) & ARES_CONNECTPROC)
#define Ares_IsServer(x)			((x) & ARES_SERVER)
#define Ares_IsSocket(x)			((x) & ARES_SOCKET)
#define Ares_IsSockOPT(x)			((x) & ARES_SOCKOPT)
#define Ares_IsKeepAliveOPT(x)			((x) & ARES_KEEPALIVEOPT)
#define Ares_IsBound(x)				((x) & ARES_BOUND)
#define Ares_IsConnecting(x)			((x) & ARES_CONNECTING)
#define Ares_IsConnected(x)			((x) & ARES_CONNECTED)
#define Ares_IsSockName(x)			((x) & ARES_SOCKNAME)
#define Ares_IsPeerName(x)			((x) & ARES_PEERNAME)

#define Ares_IsConnect(x)			((x) & (ARES_CONNECTING|ARES_CONNECTED))

/* CODES - JONAS (05.07.2000) */

#define ARES_SUCCESS				0
#define ARES_ENODATA				1
#define ARES_EFORMERR				2
#define ARES_ESERVFAIL				3
#define ARES_ENOTFOUND				4
#define ARES_ENOTIMP				5
#define ARES_EREFUSED				6
#define ARES_EBADQUERY				7
#define ARES_EBADNAME				8
#define ARES_EBADFAMILY				9
#define ARES_EBADRESP				10
#define ARES_ECONNREFUSED			11
#define ARES_ETIMEOUT				12
#define ARES_EOF				13
#define ARES_EFILE				14
#define ARES_ENOMEM				15
#define ARES_EDESTRUCTION			16
#define ARES_ECANCELLED				17

/* STRCTURES - JONAS (29.07.2001) */

struct Ares_Server_Struct {

  unsigned long int TCP_Flags;
  unsigned long int UDP_Flags;

  char *HostIPS;

  struct in_addr InAddr;

  unsigned long int PortH;
  unsigned long int PortN;

  time_t TCP_Time;
  signed long int TCP_Socket;

  time_t UDP_Time;
  signed long int UDP_Socket;

  unsigned char TempBuffer[2];
  unsigned long int TempBufferLen;

  char *Buffer;
  unsigned long int BufferLen;
  unsigned long int BufferPos;

  struct Ares_SendQ_Struct *TCPSend_Head;
  struct Ares_SendQ_Struct *UDPSend_Head;

  unsigned short int ConnectTCP;

  struct Ares_Server_Struct *Prev;
  struct Ares_Server_Struct *Next;

};

struct Ares_Host_Struct {

  char *HostName;
  char *HostIPS;

  struct Ares_Host_Struct *Prev;
  struct Ares_Host_Struct *Next;

};

struct Ares_Query_Struct {

  unsigned long int ID;

  char *Name;
  unsigned short int Class;
  unsigned short int Type;

  unsigned long int Addr;
  unsigned long int AddrLen;

  unsigned short int TCP;
  unsigned short int Tries;
  time_t Server_Timeout;
  time_t Timeout;

  unsigned char *Buffer;
  unsigned long int BufferLen;

  Ares_Callback Callback;
  void *Arg;

  struct Ares_Server_Struct *Server;

  struct hostent *HostEnt;

  unsigned short int Remove;

  struct Ares_Query_Struct *Prev;
  struct Ares_Query_Struct *Next;

};

struct Ares_SendQ_Struct {

  char *Buffer;
  unsigned long int Len;

  struct Ares_SendQ_Struct *Prev;
  struct Ares_SendQ_Struct *Next;

};

#endif
