/*
 * ----------------------------------------------------------------
 * Night Light Asynchrounous DNS Resolver
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (06.01.2001)
 *
 */

#ifdef ARES_IO_H
#warning "ares_io.h already included."
#else
#define ARES_IO_H

struct hostent;

/* TYPEDEFS - JONAS (05.07.2000) */

typedef void (*Ares_Callback)		(void *ArgPT, unsigned short int Status, struct hostent *HostEnt);

/* FUNCTION PROTOTYPES - JONAS (05.07.2000) */

const char *ares_strerror(unsigned long int Code);
void ares_readresolvconf(void);
void ares_readhosts(void);
void ares_start(void);
void ares_stop(void);
void ares_fds(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
void ares_io(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
void ares_gethostbyaddr(const void *AddrPT, const unsigned long int AddrLen, const unsigned long int Family, Ares_Callback Callback, void *ArgPT);
void ares_gethostbyname(const char *NamePT, const signed long int Family, Ares_Callback callback, void *ArgPT);
void ares_cancelquery(Ares_Callback Callback, const void *const ArgPT);

#endif
