/*
 * ----------------------------------------------------------------
 * Night Light Asynchrounous DNS Resolver
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (06.01.2001)
 *
 */

#ifdef ARES_PARSE_H
#warning "ares_parse.h already included."
#else
#define ARES_PARSE_H

/* FUNCTION PROTOTYPES - JONAS (05.07.2000) */

void ares_parse(const unsigned char *BufferPT, const signed long int BufferLen, struct Ares_Server_Struct *Ares_Server, const unsigned short int TCP);
signed short int ares_parse_a(struct Ares_Query_Struct *Query, const unsigned char *BufferPT, const unsigned long int BufferLen, unsigned short int ANCount);
signed short int ares_parse_ptr(struct Ares_Query_Struct *Ares_Query, const unsigned char *BufferPT, const unsigned long int BufferLen, unsigned short int ANCount);
signed short int ares_parse_nmexp(const unsigned char *EncodedPT, const unsigned char *BufferPT, const unsigned long int BufferLen, char **DecodedPT, unsigned long int *EncodedLenPT);
signed short int ares_parse_nmlen(const unsigned char *EncodedPT, const unsigned char *BufferPT, const signed long int Len);

#endif
