/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Bitmasks (bitmasks.h)
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (09.07.2003)
 *
 */

#ifdef BITMASKS_H
#warning "bitmasks.h already included."
#else
#define BITMASKS_H

#define BITMASK_MAIN			1
#define BITMASK_ERROR			2
#define BITMASK_EXTRA			4
#define BITMASK_CONF			8
#define BITMASK_DEBUG001		16
#define BITMASK_DEBUG002		32
#define BITMASK_DEBUG003		64
#define BITMASK_DEBUG004		128
#define BITMASK_DEBUG005		256
#define BITMASK_DEBUG006		512
#define BITMASK_DEBUG007		1024
#define BITMASK_DEBUG008		2048
#define BITMASK_DEBUG009		4096
#define BITMASK_DEBUG010		8192
#define BITMASK_DEBUG011		16384
#define BITMASK_DEBUG012		32768
#define BITMASK_DEBUG013		65536

#define BITMASK_DEBUG_GENERAL		BITMASK_DEBUG001
#define BITMASK_DEBUG_FUNCTION		BITMASK_DEBUG002
#define BITMASK_DEBUG_FLAGS		BITMASK_DEBUG003
#define BITMASK_DEBUG_MEMORY		BITMASK_DEBUG004
#define BITMASK_DEBUG_FD		BITMASK_DEBUG005
#define BITMASK_DEBUG_SYSCALLS		BITMASK_DEBUG006
#define BITMASK_DEBUG_STRCALLS		BITMASK_DEBUG007
#define BITMASK_DEBUG_IRCCALLS		BITMASK_DEBUG008
#define BITMASK_DEBUG_MAIN		BITMASK_DEBUG009
#define BITMASK_DEBUG_ARES		BITMASK_DEBUG010
#define BITMASK_DEBUG_USERIO		BITMASK_DEBUG011
#define BITMASK_DEBUG_CONNIO		BITMASK_DEBUG012
#define BITMASK_DEBUG_IDENT		BITMASK_DEBUG013

#define BITMASK_DEBUG			(BITMASK_DEBUG001 \
					|BITMASK_DEBUG002 \
					|BITMASK_DEBUG003 \
					|BITMASK_DEBUG004 \
					|BITMASK_DEBUG005 \
					|BITMASK_DEBUG006 \
					|BITMASK_DEBUG007 \
					|BITMASK_DEBUG008 \
					|BITMASK_DEBUG009 \
					|BITMASK_DEBUG010 \
					|BITMASK_DEBUG011 \
					|BITMASK_DEBUG012 \
					|BITMASK_DEBUG013 \
					)

#endif
