/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Client I/O System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (18.07.2001)
 *
 */

#ifdef USER_IO_H
#warning "client_io.h already included."
#else
#define USER_IO_H

struct hostent;
struct Listen_Struct;

/* DEFINES - JONAS (24.06.2000) */

#define CLIENT_VERIFYTIMEOUT				45
#define CLIENT_ERRORTIMEOUT				6
#define CLIENT_IDLETIMEBEFOREPING			300
#define CLIENT_PINGTIMEOUT				240

/* BIT MASKS - JONAS (24.06.2000) */

#define USER_BITMASK_SOCKET				1
#define USER_BITMASK_VERIFIED				2
#define USER_BITMASK_SENTPING				4
#define USER_BITMASK_SENTERROR				8

/* MACROS - JONAS (24.06.2000) */

#define Client_SetSocket(x)				((x)->Flags |= USER_BITMASK_SOCKET)
#define Client_SetVerified(x)				((x)->Flags |= USER_BITMASK_VERIFIED)
#define Client_SetSentPing(x)				((x)->Flags |= USER_BITMASK_SENTPING)
#define Client_SetSentError(x)				((x)->Flags |= USER_BITMASK_SENTERROR)

#define Client_ClearSocket(x)				((x)->Flags &= ~USER_BITMASK_SOCKET)
#define Client_ClearVerified(x)				((x)->Flags &= ~USER_BITMASK_VERIFIED)
#define Client_ClearSentPing(x)				((x)->Flags &= ~USER_BITMASK_SENTPING)
#define Client_ClearSentError(x)				((x)->Flags &= ~USER_BITMASK_SENTERROR)

#define Client_IsSocket(x)				((x)->Flags & USER_BITMASK_SOCKET)
#define Client_IsVerified(x)				((x)->Flags & USER_BITMASK_VERIFIED)
#define Client_IsSentPing(x)				((x)->Flags & USER_BITMASK_SENTPING)
#define Client_IsSentError(x)				((x)->Flags & USER_BITMASK_SENTERROR)

/* STRUCTURES - JONAS (18.07.2001) */

struct Client_Struct {

  struct Listen_Struct *ListenS;

  char *Nick;
  char *User;
  char *Host;
  char *Pass;

  unsigned long int ResolveFlags;
  unsigned long int Flags;

  char *HostName;
  char *HostIPS;
  unsigned long int HostIPH;
  unsigned long long int HostIPN;
  unsigned long int PortH;
  unsigned long int PortN;

  signed long int FD;

  time_t Time;
  time_t LastRecvTime;
  time_t SentPingTime;
  time_t SentErrorTime;

  char *RecvBuffer;
  char *SendBuffer;

  struct UserConf_Struct *UserConf;
  struct Conn_Struct *ConnS;

  unsigned long int Lines;
  time_t LineTime;

  struct Client_Struct *Prev;
  struct Client_Struct *Next;

};

/* FUNCTION PROTOTYPES - JONAS (18.07.2001) */

struct Client_Struct *client_add(struct Listen_Struct *ListenS, const char *const HostIPSPT, const unsigned long int HostIPH, const unsigned long long int HostIPN, const unsigned long int PortH, const unsigned long int PortN, const signed long int FD);
void client_rem(struct Client_Struct *ClientS);
void client_resolve(struct Client_Struct *ClientS);
void client_hostiptoname(void *ArgPT, unsigned short int ErrNo, struct hostent *HostEnt);
void client_hostnametoip(void *ArgPT, unsigned short int ErrNo, struct hostent *HostEnt);
unsigned short int client_accessconfcheck(struct Client_Struct *ClientS);
void client_fds(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
void client_io(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
void client_recv(struct Client_Struct *ClientS);
void client_send(struct Client_Struct *ClientS);
void client_addsend(struct Client_Struct *ClientS, const char *const LinePT, ...) __attribute__ ((format (printf, 2, 3)));
void client_parse(struct Client_Struct *ClientS);
void client_parse_message(struct Client_Struct *ClientS, char *MessagePT);
void client_parse_command(struct Client_Struct *ClientS, char *LinePT, char *CommandPT, char **ParamsPT, const unsigned short int Params);
void client_notice(struct Client_Struct *ClientS, const char *const LinePT, ...) __attribute__ ((format (printf, 2, 3)));
void client_noticealluser(const char *UserPT, const char *const LinePT, ...) __attribute__ ((format (printf, 2, 3)));
void client_noticeallbutone(struct Client_Struct *ClientO, const char *const LinePT, ...) __attribute__ ((format (printf, 2, 3)));
void client_noticeall(const char *const LinePT, ...) __attribute__ ((format (printf, 1, 2)));
void client_close(struct Client_Struct *ClientS, const char *const LinePT, ...) __attribute__ ((format (printf, 2, 3)));
void client_cleanup(struct Client_Struct *ClientS, const char *const LinePT, ...) __attribute__ ((format (printf, 2, 3)));
unsigned short int client_closeall(const char *const MessagePT, ...) __attribute__ ((format (printf, 1, 2)));
void client_welcome(struct Client_Struct *ClientS);
void client_attach(struct Client_Struct *ClientS, struct Conn_Struct *ConnS);
void client_detach(struct Client_Struct *ClientS);

#endif
