/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Connection Configuration System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (18.07.2001)
 *
 */

#ifdef CONN_CONF_H
#warning "conn_conf.h already included."
#else
#define CONN_CONF_H

#define CONN_CONF_NAME_DEFAULT			"Connection001"
#define CONN_CONF_NICK_DEFAULT			"NghtLght"
#define CONN_CONF_AWAYNICK_DEFAULT		"NghtLght"
#define CONN_CONF_USER_DEFAULT			"nghtlght"
#define CONN_CONF_HOST_DEFAULT			"0.0.0.0"
#define CONN_CONF_USERMODE_DEFAULT		"+i"
#define CONN_CONF_USERINFO_DEFAULT		"Night Light IRC Proxy www.ircproxy.night-light.net"
#define CONN_CONF_CHANS_DEFAULT			"#eclipsed,#chatparty"
#define CONN_CONF_AUTOCONNECT_DEFAULT		1
#define CONN_CONF_LOGGING_DEFAULT		1
#define CONN_CONF_AUTOAWAY_DEFAULT		1
#define CONN_CONF_PUBLICAWAY_DEFAULT		1
#define CONN_CONF_REGAINNICK_DEFAULT		1
#define CONN_CONF_MAXUSERS_DEFAULT		5
#define CONN_CONF_SENDMAXLINES_DEFAULT		1024
#define CONN_CONF_SENDLINETIME_DEFAULT		10
#define CONN_CONF_SENDMAXBUFFER_DEFAULT		1024
#define CONN_CONF_SENDBUFFERTIME_DEFAULT	120
#define CONN_CONF_AWAYMSG_DEFAULT		"Not here, detached. Using Night Light IRC Proxy, get it at www.ircproxy.night-light.net"
#define CONN_CONF_PUBLICAWAYMSG_DEFAULT		"is gone [ Night Light IRC Proxy, get it at www.ircproxy.night-light.net ]"
#define CONN_CONF_PUBLICBACKMSG_DEFAULT		"is back [ Night Light IRC Proxy, get it at www.ircproxy.night-light.net ]"

#define CONN_CONF_SERVERHOST_DEFAULT		"irc.undernet.org"
#define CONN_CONF_SERVERPORT_DEFAULT		"6667"
#define CONN_CONF_SERVERPASS_DEFAULT		"0"

/* STRUCTURES - JONAS (18.07.2001) */

struct ConnConf_Struct {

  char *Name;
  char *Nick;
  char *AwayNick;
  char *User;
  char *Host;
  char *Mode;
  char *Info;
  char *Chans;
  unsigned short int AutoConnect;
  unsigned short int Logging;
  unsigned short int AutoAway;
  unsigned short int PublicAway;
  unsigned short int RegainNick;
  unsigned short int MaxClients;
  unsigned short int SendMaxLines;
  unsigned short int SendLineTime;
  unsigned short int SendMaxBuffer;
  unsigned short int SendBufferTime;
  char *AwayMsg;
  char *PublicDetachMsg;
  char *PublicAttachMsg;

  unsigned short int Servers;

  struct ConnConfServer_Struct *Server_Head;
  struct ConnConfServer_Struct *Server_Tail;

  struct ConnConf_Struct *Next;
  struct ConnConf_Struct *Prev;

};

struct ConnConfServer_Struct {

  char *Host;
  unsigned long int Port;
  char *Pass;

  struct ConnConfServer_Struct *Next;
  struct ConnConfServer_Struct *Prev;

};

/* FUNCTION PROTOTYPES - JONAS (18.07.2001) */

signed long int conn_conf_read(void);
struct ConnConf_Struct *conn_conf_add(const char *const NamePT, const char *const NickPT, const char *const AwayNickPT, const char *const UserPT, const char *const HostPT, const char *const ModePT, const char *const InfoPT, const char *const ChansPT, const unsigned short int AutoConnect, const unsigned short int Logging, const unsigned short int AutoAway, const unsigned short int PublicAway, const unsigned short int RegainNick, const unsigned short int MaxClients, const unsigned short int SendMaxLines, const unsigned short int SendLineTime, const unsigned short int SendMaxBuffer, const unsigned short int SendBufferTime, const char *const AwayMsgPT, const char *const PublicDetachMsgPT, const char *const PublicAttachMsgPT);
void conn_conf_rem(struct ConnConf_Struct *ConnConf);
struct ConnConf_Struct *conn_conf_get(const char *const NamePT);
void conn_conf_remall(void);
struct ConnConfServer_Struct *conn_conf_addserver(struct ConnConf_Struct *ConnConf, const char *const HostPT, const unsigned long int Port, const char *const PassPT);
void conn_conf_remserver(struct ConnConf_Struct *ConnConf, struct ConnConfServer_Struct *ConnConfServer);
struct ConnConfServer_Struct *conn_conf_getserver(struct ConnConf_Struct *ConnConf, const char *const HostPT);
void conn_conf_remservers(struct ConnConf_Struct *ConnConf);

#endif
