/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Connection Parser System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (18.07.2001)
 *
 */

#ifdef CONN_PARSER_H
#warning "conn_parser.h already included."
#else
#define CONN_PARSER_H

/* MACROS - JONAS (24.06.2000) */

#define CONN_PARSE_STRREALLOC(P, S) \
  strrealloc((P), (S)); \
  if (aerrno != AESUCCESS) { \
    assert(Conn_IsSocket(ConnS)); \
    if (Conn_IsWelcome(ConnS)) { conn_quit(ConnS, "String reallocation failure in function %s() (%s:%d): [%d] %s", __FUNCTION__, __FILE__, __LINE__, aerrno, straerror(aerrno)); } \
    else { conn_disconnect(ConnS, "Connection %s server %s: String reallocation failure in function %s() (%s:%d): [%d] %s", ConnS->Name, ConnS->ServerHostName, __FUNCTION__, __FILE__, __LINE__, aerrno, straerror(aerrno)); } \
    return(FALSE); \
  } \
  assert(strcmp((P), (S)) == FALSE)

#define CONN_PARSE_NUMERIC_ERROR(X) \
	conn_quit(ConnS, \
	"Internal failure calling function %s() from function %s() (%s:%d) connection: %s after receiving numeric %d from server %s(%s):%ld: [%d] %s" \
	, (X), __FUNCTION__, __FILE__, __LINE__, ConnS->Name, Numeric, ConnS->ServerHostName, ConnS->ServerHostIPS, ConnS->ServerPortH, aerrno, straerror(aerrno)); \
	return(FALSE)

#define CONN_PARSE_NUMERIC_CHECKPARAMS(X) \
	if (Params < X) { \
		conn_quit(ConnS, "Too few parameters for numeric %d received from server %s(%s):%ld (function %s (%s:%d))", Numeric, ConnS->ServerHostName, ConnS->ServerHostIPS, ConnS->ServerPortH, __FUNCTION__, __FILE__, __LINE__); \
		return(FALSE); \
	}


#define CONN_PARSE_EVENT_ERROR(X) \
	conn_quit(ConnS, \
	"Internal failure calling function %s() from function %s() (%s:%d) connection: %s after receiving event %s from server %s(%s):%ld: [%d] %s", \
	(X), __FUNCTION__, __FILE__, __LINE__, ConnS->Name, CommandPT, ConnS->ServerHostName, ConnS->ServerHostIPS, ConnS->ServerPortH, aerrno, straerror(aerrno)); \
	return(FALSE)

#define CONN_PARSE_EVENT_CHECKPARAMS(X) \
	if (Params < X) { \
		conn_quit(ConnS, "Too few parameters for event %s received from server %s(%s):%ld (function %s (%s:%d))", CommandPT, ConnS->ServerHostName, ConnS->ServerHostIPS, ConnS->ServerPortH, __FUNCTION__, __FILE__, __LINE__); \
		return(FALSE); \
	}


/* TYPEDEFS - JONAS (24.06.2000) */

#define CONN_PARSE_NUMERIC(X)			unsigned short int X(struct Conn_Struct *ConnS, const char *const PrefixPT, const unsigned char *const LinePT, const unsigned short int Numeric, char **ParamsPT, const unsigned short int Params)
#define CONN_PARSE_EVENT(X)			unsigned short int X(struct Conn_Struct *ConnS, const char *const NickPT, const char *const UserPT, const char *const HostPT, const char *const NUHPT, const char *const CommandPT, char **ParamsPT, const unsigned short int Params)

/* FUNCTION PROTOTYPES - JONAS (18.07.2001) */

void conn_parser(struct Conn_Struct *ConnS);
void conn_parse_message(struct Conn_Struct *ConnS, char *MessagePT);
unsigned short int conn_parse_numeric(struct Conn_Struct *ConnS, const char *const PrefixPT, const unsigned char *const LinePT, const unsigned short int Numeric, char **ParamsPT, const unsigned short int Params);
CONN_PARSE_NUMERIC(conn_parse_numeric_welcome);
CONN_PARSE_NUMERIC(conn_parse_numeric_isupport);
CONN_PARSE_NUMERIC(conn_parse_numeric_nowaway);
CONN_PARSE_NUMERIC(conn_parse_numeric_unaway);
CONN_PARSE_NUMERIC(conn_parse_numeric_nextnick);
CONN_PARSE_NUMERIC(conn_parse_numeric_ison);
CONN_PARSE_NUMERIC(conn_parse_numeric_namereply);
CONN_PARSE_NUMERIC(conn_parse_numeric_endofnames);
CONN_PARSE_NUMERIC(conn_parse_numeric_whoreply);
CONN_PARSE_NUMERIC(conn_parse_numeric_endofwho);
unsigned short int conn_parse_event(struct Conn_Struct *ConnS, const char *PrefixPT, const char *const CommandPT, char **ParamsPT, const unsigned short int Params);
CONN_PARSE_EVENT(conn_parse_event_ping);
CONN_PARSE_EVENT(conn_parse_event_pong);
CONN_PARSE_EVENT(conn_parse_event_error);
CONN_PARSE_EVENT(conn_parse_event_nick);
CONN_PARSE_EVENT(conn_parse_event_join);
CONN_PARSE_EVENT(conn_parse_event_part);
CONN_PARSE_EVENT(conn_parse_event_quit);
CONN_PARSE_EVENT(conn_parse_event_kick);
CONN_PARSE_EVENT(conn_parse_event_mode);
CONN_PARSE_EVENT(conn_parse_event_privmsg_notice_topic);

#endif
