/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Connection SendQ System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (18.07.2001)
 *
 */

#ifdef CONN_SENDQ_H
#warning "conn_sendq.h already included."
#else
#define CONN_SENDQ_H

/* STRUCTURES - JONAS (18.07.2001) */

struct SendQ_Struct {

  char *Line;
  unsigned short int Priority;
  time_t Time;

  struct SendQ_Struct *Next;

};

struct FlushL_Struct {

  unsigned short int Lines;
  time_t Time;

  struct FlushL_Struct *Prev;
  struct FlushL_Struct *Next;

};

struct FlushB_Struct {

  unsigned short int Len;
  time_t Time;

  struct FlushB_Struct *Prev;
  struct FlushB_Struct *Next;

};

/* FUNCTION PROTOTYPES - JONAS (18.07.2001) */

void conn_addsendq(struct Conn_Struct *ConnS, const char *const LinePT, ...) __attribute__ ((format (printf, 2, 3)));
void conn_flushsendq(struct Conn_Struct *ConnS);
void conn_initsendq(struct Conn_Struct *ConnS);

void conn_addflushl(struct Conn_Struct *ConnS, const unsigned short int Lines);
void conn_initflushl(struct Conn_Struct *ConnS);

void conn_addflushb(struct Conn_Struct *ConnS, const unsigned short int Len);
void conn_initflushb(struct Conn_Struct *ConnS);

#endif
