/*
 * ----------------------------------------------------------------
 * Night Light System Headers (headers.h)
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (20.07.2003)
 *
 */

#ifdef HEADERS_H
#warning "headers.h already included."
#else
#define HEADERS_H

#ifndef NEED_SYS_TYPES_H
  #define NEED_SYS_TYPES_H 1
#endif
#ifndef NEED_SYS_PARAM_H
  #define NEED_SYS_PARAM_H 1
#endif
#ifndef NEED_LIMITS_H
  #define NEED_LIMITS_H 0
#endif
#ifndef NEED_STDARG_H
  #define NEED_STDARG_H 1
#endif
#ifndef NEED_ERRNO_H
  #define NEED_ERRNO_H 1
#endif
#ifndef NEED_CTYPE_H
  #define NEED_CTYPE_H 1
#endif
#ifndef NEED_NETINET_IN_H
  #define NEED_NETINET_IN_H 0
#endif
#ifndef NEED_STDIO_H
  #define NEED_STDIO_H 1
#endif
#ifndef NEED_STDLIB_H
  #define NEED_STDLIB_H 1
#endif
#ifndef NEED_TIME_H
  #define NEED_TIME_H 1
#endif
#ifndef NEED_SYS_STAT_H
  #define NEED_SYS_STAT_H 0
#endif
#ifndef NEED_SYS_UIO_H
  #define NEED_SYS_UIO_H 0
#endif
#ifndef NEED_FCNTL_H
  #define NEED_FCNTL_H 0
#endif
#ifndef NEED_SYS_IOCTL_H
  #define NEED_SYS_IOCTL_H 0
#endif
#ifndef NEED_SYS_FILIO_H
  #define NEED_SYS_FILIO_H 0
#endif
#ifndef NEED_UNISTD_H
  #define NEED_UNISTD_H 1
#endif
#ifndef NEED_STRING_H
  #define NEED_STRING_H 1
#endif
#ifndef NEED_SIGNAL_H
  #define NEED_SIGNAL_H 0
#endif
#ifndef NEED_ARPA_INET_H
  #define NEED_ARPA_INET_H 0
#endif
#ifndef NEED_SYS_SOCKET_H
  #define NEED_SYS_SOCKET_H 0
#endif
#ifndef NEED_NETDB_H
  #define NEED_NETDB_H 0
#endif
#ifndef NEED_SYSCTL_H
  #define NEED_SYSCTL_H 0
#endif
#ifndef NEED_ARPA_NAMESER_H
  #define NEED_ARPA_NAMESER_H 0
#endif
#ifndef NEED_GETUSERPW_HEADERS
  #define NEED_GETUSERPW_HEADERS 0
#endif

/*
 * <sys/types.h>
 *
 * size_t, time_t, pid_t, uid_t, gid_t, socklen_t, off_t quad_t
 * FD_SETSIZE, FD_SET(), FD_CLR(), FD_ISSET(), FD_COPY(), FD_ZERO()
 *
 */
#if NEED_SYS_TYPES_H
  #if HAVE_SYS_TYPES_H
    #include <sys/types.h>
  #else
    #warning "This system does not have sys/types.h"
  #endif
#endif


/*
 * <sys/param.h>
 *
 * Some systems need this file.
 *
 */
#if NEED_SYS_PARAM_H
  #if HAVE_SYS_PARAM_H
    #include <sys/param.h>
  #else
    #warning "This system does not have sys/param.h"
  #endif
#endif


/*
 * <limits.h>
 *
 */
#if NEED_LIMITS_H
  #if HAVE_LIMITS_H
    #include <limits.h>
  #else
    #warning "This system does not have limits.h!"
  #endif
#endif


/*
 * <stdarg.h>
 *
 * va_list, va_start, va_arg, va_end
 *
 */
#if NEED_STDARG_H
  #if HAVE_STDARG_H
    #include <stdarg.h>
  #else
    #warning "This system does not have stdarg.h!"
  #endif
#endif


/*
 * <errno.h>
 *
 * errno
 *
 */
#if NEED_ERRNO_H
  #if HAVE_ERRNO_H
    #include <errno.h>
  #else
    #warning "This system does not have errno.h!"
  #endif
#endif


/*
 * <ctype.h>
 *
 * isalnum(), isalpha(), iscntrl(), isdigit(), isgraph(), islower(), isprint(), ispunct(), isspace(), isupper(), isxdigit(), tolower(), toupper()
 * digittoint(), isascii(), isblank(), ishexnumber(), isideogram(), isnumber(), isphonogram(), isrune(), isspecial(), toascii()
 *
 */
#if NEED_CTYPE_H
  #if HAVE_CTYPE_H
    #include <ctype.h>
  #else
    #warning "This system does not have ctype.h!"
  #endif
#endif


/*
 * <netinet/in.h> Definitions for third level IPv4/IPv6 identifiers and fourth level IPv4/v6 identifiers
 *
 * struct in_addr, struct sockaddr_in
 *
 */
#if NEED_NETINET_IN_H
  #if HAVE_NETINET_IN_H
    #include <netinet/in.h>
  #else
    #warning "This system does not have netinet/in.h!"
  #endif
#endif


/*
 * <stdio.h>
 *
 * FILE, BUFSIZ, EOF, stdin, stdout, stderr
 *
 * fopen(), fdopen(), freopen(), fclose(), fflush(), fpurge(), fread(), fwrite(), fgets(), gets()
 * printf(), fprintf(), sprintf(), snprintf(), asprintf(), vprintf(), vfprintf(), vsprintf(), vsnprintf(), vasprintf()
 * scanf(), fscanf(), sscanf(), vscanf(), vsscanf(), vfscanf()
 * clearerr(), feof(), ferror(), fileno()
 * fgetc(), getc(), getchar(), getw()
 * fputc(), putc(), putchar(), putw()
 * ungetc()
 * fseek(), ftell(), rewind(), fgetpos(), fsetpos(), fseeko(), ftello()
 * setbuf(), setbuffer(), setlinebuf(), setvbuf()
 * perror()
 * remove(), rename()
 * tmpfile(), tmpnam(), tempnam()
 * ctermid(), ctermid_r()
 * fgetln()
 * fmtcheck()
 * popen(), pclose()
 * funopen(), fropen(), fwopen()
 *
 */
#if NEED_STDIO_H
  #if HAVE_STDIO_H
    #include <stdio.h>
  #else
    #warning "This system does not have stdio.h!"
  #endif
#endif


/*
 * <stdlib.h>
 *
 * NULL, EXIT_FAILURE, EXIT_SUCCESS
 *
 * exit(), abort(), atexit()
 * atof(), atoi(), atol()
 * strtod(), strtol(), strtoll(), strtoul(), strtoull() strtoq() strtouq()
 * malloc(), calloc(), realloc(), reallocf(), free()
 * labs(), abs(), div(), ldiv(), math()
 * bsearch(), lsearch(), qsort(), heapsort(), mergesort()
 * rand(), srand(), rand_r()
 * random(), srandom(), srandomdev(), initstate(), setstate()
 * system(), daemon(), devname(), getloadavg(), getprogname(), setprogname()
 * getenv(), setenv(), putenv(), unsetenv()
 * mblen(), mbstowcs(), mbtowc(), wcstombs(), wctomb()
 * getbsize()
 * cgetent(), cgetset(), cgetmatch(), cgetcap(), cgetnum(), cgetstr(), cgetustr(), cgetfirst(), cgetnext(), cgetclose()
 * radixsort(), sradixsort()
 * realpath()
 * user_from_uid(), group_from_gid()
 *
 */
#if NEED_STDLIB_H
  #if HAVE_STDLIB_H
    #include <stdlib.h>
  #else
    #warning "This system does not have stdlib.h!"
  #endif
#endif


/*
 * <time.h> / <sys/time.h>
 *
 * struct tm, struct timeval, struct timespec, struct timecounter, struct itimerval, struct clockinfo
 *
 * microtime(), getmicrotime(), nanotime(), getnanotime()
 * microuptime(), getmicrouptime(), nanouptime(), getnanouptime()
 * time(), tvtohz(), clock()
 * adjtime()
 * utimes(), lutimes(), futimes()
 * getitimer(), setitimer()
 * gettimeofday(), settimeofday()
 * ctime(), difftime(), asctime(), localtime(), gmtime(), mktime(), timegm(), ctime_r(), localtime_r(), gmtime_r(), asctime_r()
 * strftime(), strptime()
 * timezone()
 * tzset(), tzsetwall()
 * clock_getres(), clock_gettime(), clock_settime()
 * nanosleep()
 *
 */
#if NEED_TIME_H
  #if TIME_WITH_SYS_TIME
    #include <sys/time.h>
    #include <time.h>
  #else
    #if HAVE_SYS_TIME_H
      #include <sys/time.h>
    #else
      #include <time.h>
    #endif
  #endif
#endif


/*
 * <sys/stat.h>
 *
 * chmod(), fchmod(), lchmod()
 * stat(), lstat(), fstat()
 * mkdir(), mkfifo(), umask()
 * chflags(), fchflags()
 *
 */
#if NEED_SYS_STAT_H
  #if HAVE_SYS_STAT_H
    #include <sys/stat.h>
  #else
    #warning "This system does not have sys/stat.h!"
  #endif
#endif


/*
 * <sys/uio.h>
 *
 * struct iovec, struct uio
 *
 * uiomove()
 *
 */
#if NEED_SYS_UIO_H
  #if HAVE_SYS_UIO_H
    #include <sys/uio.h>
  #else
    #warning "This system does not have sys/uio.h!"
  #endif
#endif


/*
 * <fcntl.h>
 *
 * open(), creat(), fcntl()
 *
 *
 */
#if NEED_FCNTL_H
  #if HAVE_FCNTL_H
    #include <fcntl.h>
  #else
    #warning "This system does not have fcntl.h!"
  #endif
#endif


/*
 * <sys/ioctl.h>
 *
 * ioctl()
 *
 *
 */
#if NEED_SYS_IOCTL_H
  #if HAVE_SYS_IOCTL_H
    #include <sys/ioctl.h>
  #else
    #warning "This system does not have sys/ioctl.h!"
  #endif
#endif


/*
 * <sys/filio.h>
 *
 * Solaris need this for ioctl()
 *
 *
 */
#if NEED_SYS_FILIO_H
  #if HAVE_SYS_FILIO_H
    #include <sys/filio.h>
  #endif
#endif


/*
 * <unistd.h>
 *
 * STDIN_FILENO, STDOUT_FILENO, STDERR_FILENO
 *
 * getopt(), getsubopt()
 * pause(), sleep(), usleep()
 * alarm(), ualarm()
 * _exit()
 * access()
 * chdir(), fchdir(), rmdir()
 * chown(), fchown(), lchown()
 * execl(), execlp(), execle(), exect(), execv(), execvp()
 * pipe()
 * read(), readv(), pread()
 * write(), writev(), pwrite()
 * dup(), dup2(), close(), select()
 * revoke(), lockf(), lseek()
 * valloc()
 * fork(), rfork(), rfork_thread(), vfork()
 * getpid(), getppid()
 * getdomainname(), setdomainname(), gethostid(), sethostid(), gethostname(), sethostname(), getlogin_r(), setlogin(), getusershell(), setusershell(), endusershell()
 * getcwd(), getwd(), chroot()
 * sysconf(), pathconf(), fpathconf()
 * getuid(), geteuid(), getgid(), getegid()
 * setuid(), seteuid(), setgid(), setegid()
 * setruid(), setrgid(), setreuid(), setregid(), setresgid(), setresuid()
 * issetugid()
 * initgroups(), getgrouplist(), getgroups(), getlogin(), getlogin_r(), setlogin()
 * getpgrp(), getpgid(), getpid(), getppid()
 * setpgid(), setpgrp()
 * setproctitle()
 * getsid(), setsid()
 * ttyname(), isatty(), ttyslot()
 * link(), unlink(), readlink(), symlink()
 * tcgetpgrp(), tcsetpgrp()
 * acct(), brk()
 * confstr()
 * getpass(), crypt(), crypt_get_format(), crypt_set_format()
 * setkey(), encrypt(), des_setkey(), des_cipher()
 * getusershell(), setusershell(), endusershell()
 * fflagstostr(), strtofflags()
 * fsync(), truncate(), ftruncate()
 * getdtablesize() getpagesize()
 * getmode(), setmode()
 * getpeereid()
 * rcmd(), rresvport(), iruserok(), ruserok(), rcmd_af(), rresvport_af(), iruserok_sa()
 * rcmdsh
 * mktemp(), mkstemp(), mkstemps(), mkdtemp()
 * mknod()
 * nfssvc()
 * nice()
 * profil()
 * re_comp(), re_exec()
 * swapon(), sync(), reboot()
 * brk(), sbrk()
 * syscall()
 * undelete()
 *
 */
#if NEED_UNISTD_H
  #if HAVE_UNISTD_H
    #include <unistd.h>
  #else
    #warning "This system does not have unistd.h!"
  #endif
#endif


/*
 * <string.h>
 *
 * memchr(), memcmp(), memcpy(), memmove(), memset()
 * strchr(), strstr(), strpbrk(), strrchr(), strtok(), strtok_r(), strxfrm()
 * strcat(), strncat()
 * strcmp, strncmp(), strcpy, strncpy
 * strcoll()
 * strspn(), strcspn()
 * strerror()
 * strlen()
 *
 */
#if NEED_STRING_H
  #if HAVE_STRING_H
    #include <string.h>
  #else
    #warning "This system does not have string.h!"
  #endif
#endif


/*
 * <signal.h>
 *
 * struct sigaction, sig_t
 *
 * raise(), kill(), killpg()
 * signal(), sigaction(), sigpending(), sigprocmask(), sigsuspend(), sigwait()
 * sigaltstack(), sigblock(), siginterrupt(), sigpause(), sigreturn(), sigsetmask(), sigstack(), sigvec(), psignal()
 * sigemptyset(), sigfillset(), sigaddset(), sigdelset(), sigismember()
 *
 */
#if NEED_SIGNAL_H
  #if HAVE_SIGNAL_H
    #include <signal.h>
  #else
    #warning "This system does not have errno.h!"
  #endif
#endif


/*
 * <arpa/inet.h>
 *
 * inet_addr(), inet_aton(), inet_lnaof(), inet_makeaddr(), inet_neta(), inet_netof(), inet_network()
 * inet_net_ntop(), inet_net_pton(), inet_ntoa(), inet_pton(), inet_ntop(), inet_nsap_addr(), inet_nsap_ntoa()
 *
 */
#if NEED_ARPA_INET_H
  #if HAVE_ARPA_INET_H
    #include <arpa/inet.h>
  #else
    #warning "This system does not have arpa/inet.h!"
  #endif
#endif


/*
 * <sys/socket.h> Definitions for second level network identifiers
 *
 * struct sockaddr
 *
 * socket(), bind(), connect(), listen(), accept()
 * getpeername(), getsockname(), getsockopt()
 * recv(), recvfrom(), recvmsg(), send(), sendto(), sendmsg()
 * sendfile(), shutdown(), socketpair()
 *
 */
#if NEED_SYS_SOCKET_H
  #if HAVE_SYS_SOCKET_H
    #include <sys/socket.h>
  #else
    #warning "This system does not have sys/socket.h!"
  #endif
#endif


/*
 * <netdb.h>
 *
 * h_errno
 * struct hostent, struct netent, struct servent, struct protoent, struct addrinfo
 *
 * gethostbyname(), gethostbyname2(), gethostbyaddr(), gethostent(), sethostent(), endhostent(), herror(), hstrerror()
 * getnetent(), getnetbyname(), getnetbyaddr(), setnetent(), endnetent()
 * getnetgrent(), innetgr(), setnetgrent(), endnetgrent()
 * getprotoent(), getprotobyname(), getprotobynumber(), setprotoent(), endprotoent()
 * getservent(), getservbyname(), getservbyport(), setservent(), endservent()
 * getipnodebyname(), getipnodebyaddr(), freehostent()
 * getaddrinfo(), freeaddrinfo(), gai_strerror()
 * getnameinfo()
 *
 */
#if NEED_NETDB_H
  #if HAVE_NETDB_H
    #include <netdb.h>
  #else
    #warning "This system does not have netdb.h!"
  #endif
#endif


/*
 *
 * <sys/sysctl.h> Definitions for top level identifiers, second level kernel and hardware identifiers, and user level identifiers
 *
 * sysctl_add_oid(), sysctl_remove_oid()
 * sysctl_ctx_init(), sysctl_ctx_free(), sysctl_ctx_entry_add(), sysctl_ctx_entry_find(), sysctl_ctx_entry_del()
 * sysctl(), sysctlbyname(), sysctlnametomib()
 *
 */
#if NEED_SYSCTL_H
  #if HAVE_SYS_SYSCTL_H
    #include <sys/sysctl.h>
  #else
    #warning "This system does not have sys/sysctl.h!"
  #endif
#endif


/*
 * <arpa/nameser.h>
 *
 * Nameserver stuff needed for Ares.
 *
 */
#if NEED_ARPA_NAMESER_H
  #if HAVE_ARPA_NAMESER_H
    #include <arpa/nameser.h>
  #else
    #warning "This system does not have arpa/nameser.h!"
  #endif
#endif


/*
 * <crypt.h>
 *
 *
 *
 */
#if NEED_CRYPT && HAVE_CRYPT_H
  #include <crypt.h>
#endif


/*
 * <assert.h>
 *
 */
#if USE_ASSERT && HAVE_ASSERT_H
  #include <assert.h>
#else
  #warning "!!! NOT USING ASSERTIONS !!!"
  #define assert(X)
#endif


/*
 * Stuff we need to retrive system passwords.
 * This might not work on all systems.
 *
 */
#if NEED_GETUSERPW_HEADERS

  #if HAVE_PWD_H
    #include <pwd.h>
  #endif

  #if HAVE_PROT_H
    #include <prot.h>
  #endif

  #if HAVE_SHADOW_H
    #include <shadow.h>
  #endif

  #if HAVE_USERPW_H
    #include <userpw.h>
  #endif

  #if HAVE_HPSECURITY_H
    #include <hpsecurity.h>
  #endif

#endif


#endif
