/*
 * ----------------------------------------------------------------
 * Night Light Ident Configuration System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (03.07.2003)
 *
 */

#ifdef IDENT_CONF_H
#warning "ident_conf.h already included."
#else
#define IDENT_CONF_H

/* STRUCTURES - JONAS (03.07.2003) */

struct IdentConf_Struct {

  char *Host;
  unsigned long int Port;

  struct IdentConf_Struct *Next;
  struct IdentConf_Struct *Prev;

};

/* FUNCTION PROTOTYPES - JONAS (03.07.2003) */

signed long int ident_conf_read(void);
struct IdentConf_Struct *ident_conf_add(const char *const HostPT, const unsigned long int Port);
void ident_conf_rem(struct IdentConf_Struct *IdentConf);
struct IdentConf_Struct *ident_conf_get(const char *const HostPT, const unsigned long int Port);
void ident_conf_remall(void);

#endif
