/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Ident Listen System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (03.07.2003)
 *
 */

#ifdef IDENT_LISTEN_H
#warning "ident_listen.h already included."
#else
#define IDENT_LISTEN_H

struct hostent;

/* DEFINES - JONAS (03.07.2003) */

#define IDENTLISTEN_INTERVAL			60
#define IDENTLISTEN_SOCKKEEPALIVE		TRUE
#define IDENTLISTEN_SOCKREUSEADDR		TRUE


/* BIT MASKS - JONAS (03.07.2003) */

#define IDENTLISTEN_BITMASK_REMOVE		2

#define IDENTLISTEN_BITMASK_RESOLVING		2
#define IDENTLISTEN_BITMASK_RESOLVED		4
#define IDENTLISTEN_BITMASK_SOCKET		8
#define IDENTLISTEN_BITMASK_LISTENING		16


/* MACROS - JONAS (03.07.2003) */

#define IdentListen_SetRemove(x)		((x)->PermFlags |= IDENTLISTEN_BITMASK_REMOVE)
#define IdentListen_ClearRemove(x)		((x)->PermFlags &= ~IDENTLISTEN_BITMASK_REMOVE)
#define IdentListen_IsRemove(x)			((x)->PermFlags & IDENTLISTEN_BITMASK_REMOVE)

#define IdentListen_SetResolving(x)		((x)->Flags |= IDENTLISTEN_BITMASK_RESOLVING)
#define IdentListen_SetResolved(x)		((x)->Flags |= IDENTLISTEN_BITMASK_RESOLVED)
#define IdentListen_SetSocket(x)		((x)->Flags |= IDENTLISTEN_BITMASK_SOCKET)
#define IdentListen_SetListening(x)		((x)->Flags |= IDENTLISTEN_BITMASK_LISTENING)

#define IdentListen_ClearResolving(x)		((x)->Flags &= ~IDENTLISTEN_BITMASK_RESOLVING)
#define IdentListen_ClearResolved(x)		((x)->Flags &= ~IDENTLISTEN_BITMASK_RESOLVED)
#define IdentListen_ClearSocket(x)		((x)->Flags &= ~IDENTLISTEN_BITMASK_SOCKET)
#define IdentListen_ClearListening(x)		((x)->Flags &= ~IDENTLISTEN_BITMASK_LISTENING)

#define IdentListen_IsResolving(x)		((x)->Flags & IDENTLISTEN_BITMASK_RESOLVING)
#define IdentListen_IsResolved(x)		((x)->Flags & IDENTLISTEN_BITMASK_RESOLVED)
#define IdentListen_IsSocket(x)			((x)->Flags & IDENTLISTEN_BITMASK_SOCKET)
#define IdentListen_IsListening(x)		((x)->Flags & IDENTLISTEN_BITMASK_LISTENING)

/* STRUCTURES - JONAS (03.07.2003) */

struct IdentListen_Struct {

  char *Host;

  unsigned long int PermFlags;
  unsigned long int Flags;

  char *HostIPS;
  unsigned long int HostIPH;
  unsigned long long int HostIPN;

  unsigned long int PortH;
  unsigned long int PortN;

  signed long int FD;

  time_t Time;
  unsigned short int Tries;

  struct IdentListen_Struct *Prev;
  struct IdentListen_Struct *Next;

};

/* FUNCTION PROTOTYPES - JONAS (03.07.2003) */

struct IdentListen_Struct *ident_listen_add(const char *const HostPT, const unsigned long int Port);
void ident_listen_rem(struct IdentListen_Struct *IdentListenS);
void ident_listen_init(struct IdentListen_Struct *IdentListenS);
struct IdentListen_Struct *ident_get(const char *const HostPT, const unsigned long int Port);
void ident_listen_start(struct IdentListen_Struct *IdentListenS);
void ident_listen_hosttoip(void *ArgPT, unsigned short int ErrNo, struct hostent *HostEnt);
void ident_listen_stop(struct IdentListen_Struct *IdentListenS);
void ident_listen_fds(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
void ident_listen_io(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
unsigned short int ident_listen_closeall(const char *const MessagePT, ...) __attribute__ ((format (printf, 1, 2)));

#endif
