/*
 * ----------------------------------------------------------------
 * Night Light Internet Relat Chat Defines (irc_defines.h)
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (18.07.2001)
 *
 *
 */

#ifdef IRC_DEFINES_H
#warning "irc_defines.h already included."
#else
#define IRC_DEFINES_H


/* Network bitmasks */

#define IRC_NETWORK_ZERO						0
#define IRC_NETWORK_GENERIC						1
#define IRC_NETWORK_IRCNET						2
#define IRC_NETWORK_EFNET						4
#define IRC_NETWORK_UNDERNET						8
#define IRC_NETWORK_ALL							(IRC_NETWORK_GENERIC|IRC_NETWORK_IRCNET|IRC_NETWORK_EFNET|IRC_NETWORK_UNDERNET)


/* Unknown NICK/USER/HOST strings */

#define IRCUNKNOWNNICK							""
#define IRCUNKNOWNUSER							""
#define IRCUNKNOWNHOST							""
#define IRCUNKNOWNNUH							IRCUNKNOWNNICK "!" IRCUNKNOWNUSER "@" IRCUNKNOWNHOST


/* Characters */

#define IRCNUHCHARS							"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._!@`[]{}|\\^?*~"
#define IRCNICKCHARS							"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_`[]{}|\\^?*"
#define IRCUSERCHARS							"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.?*~"
#define IRCHOSTCHARS							"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.?*"
#define IRCPASSCHARS							"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.?*"
#define IRCSERVERCHARS							IRCHOSTCHARS

#define IRCEVENTS							"abcdiew"
#define IRCCHANEVENTS							"jpqknmtabcdxz"

#define IRCUSERMODES							"+-iws"
#define IRCCHANMODES							"+-ilpskmnt"


/* SendQ */

#define IRCSENDMAXLINES							100
#define IRCSENDLINETIME							1

#define IRCSENDMAXBUFFER						1024
#define IRCSENDBUFFERTIME						120


/* Settings */

#define IRCMAXPARAMS							15
#define IRCMAXMODES							3
#define IRCMAXCHANS							10
#define IRCCHANMAXBANS							30


/* Lengths */

#define IRCSERVERLEN							63
#define IRCSERVERINFOLEN						200

#define IRCPASSLEN							20
#define IRCNICKLEN							9
#define IRCUSERLEN							12
#define IRCHOSTLEN							63
#define IRCNAMELEN							50

#define IRCUSERHOSTLEN							(IRCNICKLEN + IRCUSERLEN + 1)
#define IRCNUHLEN							(IRCNICKLEN + IRCUSERLEN + IRCHOSTLEN + 2)

#define IRCMSGLEN							510
#define IRCMSGCRLFLEN							(IRCMSGLEN+2)

#define IRCPRIVMSGLEN							490
#define IRCNOTICELEN							490
#define IRCCTCPLEN							490
#define IRCACTIONLEN							490
#define IRCQUITMSGLEN							200
#define IRCKILLMSGLEN							200
#define IRCWALLOPSMSGLEN						200
#define IRCAWAYMSGLEN							200

#define IRCMODECHARLEN							2
#define IRCMODEPARAMLEN							50

#define IRCMODECHARSLEN							10
#define IRCMODEPARAMSLEN						510

#define IRCMODELINELEN							(IRCMODECHARSLEN + IRCMODEPARAMSLEN)
#define IRCMODESLEN							(IRCCHANMODELEN * IRCCHANMAXMODES)

#define IRCCHANLEN							50
#define IRCCHANKEYLEN							23
#define IRCCHANKICKMSGLEN						200
#define IRCCHANPARTMSGLEN						200
#define IRCCHANTOPICLEN							160


/* Structures */

struct IRC_ISupport_Struct {

  char *Network;
  unsigned long int Networks;
  unsigned short int MaxModes;
  unsigned short int MaxChans;
  unsigned short int MaxBans;
  unsigned short int NickLen;
  unsigned short int AwayMsgLen;
  unsigned short int TopicLen;
  unsigned short int KickMsgLen;
  char *ChanTypes;
  char *Prefix;
  char *ChanModes;

};


/* IRC Mask defines */

#define IRC_MINNICKMASK							1
#define IRC_MAXNICKMASK							6
#define IRC_MINUSERMASK							1
#define IRC_MAXUSERMASK							6
#define IRC_MINHOSTMASK							1
#define IRC_MAXHOSTMASK							6

#endif
