/*
 * ----------------------------------------------------------------
 * Night Light Internet Relat Chat Functions Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (28.09.2002)
 *
 *
 */

#ifdef IRCCALLS_H
#warning "irccalls.h already included."
#else
#define IRCCALLS_H


#define IRC_IRCUNKNOWNEVENT						"Unknown IRC event: \"%c\"."
#define IRC_IRCEVENTTWOTIMESINSTRING					"IRC event \"%c\" appears two times in string."
#define IRC_IRCNICKINVALIDSTARTCHAR					"Invalid starting character \"%c\" in nickname."
#define IRC_IRCNICKINVALIDCHAR						"Invalid character \"%c\" in nickname."
#define IRC_IRCNICKMAXCHARS						"Maximum %d characters in nickname."
#define IRC_IRCUSERINVALIDCHAR						"Invalid character \"%c\" in username."
#define IRC_IRCUSERMAXCHARS						"Maximum %d characters in username."
#define IRC_IRCHOSTINVALIDCHAR						"Invalid character \"%c\" in hostname."
#define IRC_IRCHOSTMAXCHARS						"Maximum %d characters in hostname."
#define IRC_IRCNUHINVALIDCHAR						"Invalid character \"%c\" in NICK!USER@HOST."
#define IRC_IRCNUHMAXCHARS						"Maximum %d characters in NICK!USER@HOST."
#define IRC_IRCSERVERINVALIDCHAR					"Invalid character \"%c\" in server."
#define IRC_IRCSERVERMAXCHARS						"Maximum %d characters in server."
#define IRC_IRCPASSINVALIDCHAR						"Invalid character \"%c\" in password."
#define IRC_IRCPASSMAXCHARS						"Maximum %d characters in password."
#define IRC_IRCTARGETINVALIDCHAR					"Invalid character \"%c\" in target."
#define IRC_IRCTARGETMAXCHARS						"Maximum %d characters in target."
#define IRC_IRCCHANINVALIDSTARTCHAR					"Invalid starting character \"%c\" in channel name."
#define IRC_IRCCHANINVALIDCHAR						"Invalid character \"%c\" in channel name."
#define IRC_IRCCHANMAXCHARS						"Maximum %d characters in channel name."
#define IRC_IRCCHANTOPICMAXCHARS					"Maximum %d characters in channel topic name."
#define IRC_IRCCHANKEYMAXCHARS						"Maximum %d characters in channel key name."
#define IRC_IRCUNKNOWNUSERMODEFLAG					"Unknown user mode flag: \"%c\"."
#define IRC_IRCUSERMODESTWOTIMESINSTRING				"User mode \"%c\" appears more then once in user modes."
#define IRC_IRCUNKNOWNCHANMODEFLAG					"Unknown channel mode flag: \"%c\"."
#define IRC_IRCCHANMODESTWOTIMESINSTRING				"Channel mode \"%c\" appears more then once in user modes."
#define IRC_IRCUNKNOWNCHANEVENT						"Unknown channel event \"%c\"."
#define IRC_IRCCHANEVENTTWOTIMESINSTRING				"Channel event \"%c\" appears more than once in string."
#define IRC_IRCMSGMAXCHARS						"Maximum %d characters in a IRC message."

/* FUNCTION PROTOTYPES - JONAS (26.09.2000) */

unsigned short int irc_isvalidevents(const char * const StringPT);
unsigned short int irc_isvalidnick(const char * const StringPT);
unsigned short int irc_isvaliduser(const char * const StringPT);
unsigned short int irc_isvalidhost(const char * const StringPT);
unsigned short int irc_isvalidnuh(const char * const StringPT);
unsigned short int irc_isvalidserver(const char * const StringPT);
unsigned short int irc_isvalidpass(const char * const StringPT);
unsigned short int irc_isvalidtarget(const char *const StringPT);
unsigned short int irc_isvalidchan(const char * const StringPT);
unsigned short int irc_isvalidchantopic(const char * const StringPT);
unsigned short int irc_isvalidchankey(const char * const StringPT);
unsigned short int irc_isvalidusermodes(const char * const StringPT);
unsigned short int irc_isvalidchanmodes(const char * const StringPT);
unsigned short int irc_isvalidchanevents(const char * const StringPT);
unsigned short int irc_isvalidmsg(const char *const StringPT);
const char *irc_strevent(const char Event);
char *irc_nuhmask(const char *NickPT, const char *UserPT, const char *HostPT, const unsigned short int NickMask, const unsigned short int UserMask, const unsigned short int HostMask);
char *irc_fixnuh(char *NUHPT);
void irc_nuhmastest(void);
unsigned short int irc_nextnick(const char *const NickPT, unsigned short int NicksIndex, const unsigned short int MaxNickLen);
void irc_cleanup(void);


#endif
