/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Listen I/O System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (18.07.2001)
 *
 */

#ifdef LISTEN_IO_H
#warning "listen_io.h already included."
#else
#define LISTEN_IO_H

struct hostent;

/* DEFINES - JONAS (18.07.2001) */

#define LISTEN_INTERVAL				60
#define LISTEN_SOCKKEEPALIVE			TRUE
#define LISTEN_SOCKREUSEADDR			TRUE


/* BIT MASKS - JONAS (18.07.2001) */

#define LISTEN_BITMASK_REMOVE			2

#define LISTEN_BITMASK_RESOLVING		2
#define LISTEN_BITMASK_RESOLVED			4
#define LISTEN_BITMASK_SOCKET			8
#define LISTEN_BITMASK_LISTENING		16


/* MACROS - JONAS (18.07.2001) */

#define Listen_SetRemove(x)			((x)->PermFlags |= LISTEN_BITMASK_REMOVE)
#define Listen_ClearRemove(x)			((x)->PermFlags &= ~LISTEN_BITMASK_REMOVE)
#define Listen_IsRemove(x)			((x)->PermFlags & LISTEN_BITMASK_REMOVE)

#define Listen_SetResolving(x)			((x)->Flags |= LISTEN_BITMASK_RESOLVING)
#define Listen_SetResolved(x)			((x)->Flags |= LISTEN_BITMASK_RESOLVED)
#define Listen_SetSocket(x)			((x)->Flags |= LISTEN_BITMASK_SOCKET)
#define Listen_SetListening(x)			((x)->Flags |= LISTEN_BITMASK_LISTENING)

#define Listen_ClearResolving(x)		((x)->Flags &= ~LISTEN_BITMASK_RESOLVING)
#define Listen_ClearResolved(x)			((x)->Flags &= ~LISTEN_BITMASK_RESOLVED)
#define Listen_ClearSocket(x)			((x)->Flags &= ~LISTEN_BITMASK_SOCKET)
#define Listen_ClearListening(x)		((x)->Flags &= ~LISTEN_BITMASK_LISTENING)

#define Listen_IsResolving(x)			((x)->Flags & LISTEN_BITMASK_RESOLVING)
#define Listen_IsResolved(x)			((x)->Flags & LISTEN_BITMASK_RESOLVED)
#define Listen_IsSocket(x)			((x)->Flags & LISTEN_BITMASK_SOCKET)
#define Listen_IsListening(x)			((x)->Flags & LISTEN_BITMASK_LISTENING)

/* STRUCTURES - JONAS (18.07.2001) */

struct Listen_Struct {

  char *Host;

  unsigned long int PermFlags;
  unsigned long int Flags;

  char *HostIPS;
  unsigned long int HostIPH;
  unsigned long long int HostIPN;

  unsigned long int PortH;
  unsigned long int PortN;

  signed long int FD;

  time_t Time;
  unsigned short int Tries;

  struct Listen_Struct *Prev;
  struct Listen_Struct *Next;

};

/* FUNCTION PROTOTYPES - JONAS (18.07.2001) */

struct Listen_Struct *listen_add(const char *const HostPT, const unsigned long int Port);
void listen_rem(struct Listen_Struct *ListenS);
void listen_init(struct Listen_Struct *ListenS);
struct Listen_Struct *listen_get(const char *const HostPT, const unsigned long int Port);
void listen_start(struct Listen_Struct *ListenS);
void listen_hosttoip(void *ArgPT, unsigned short int ErrNo, struct hostent *HostEnt);
void listen_stop(struct Listen_Struct *ListenS);
void listen_fds(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
void listen_io(fd_set *ReadFDS, fd_set *WriteFDS, unsigned long int *FDS);
unsigned short int listen_closeall(const char *const MessagePT, ...) __attribute__ ((format (printf, 1, 2)));

#endif
