/*
 * ----------------------------------------------------------------
 * Night Light Program Defines (nlprgdef.h)
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (12.08.2001)
 *
 */

#ifdef NLPRGDEF_H
#warning "nlprgdef.h already included."
#else
#define NLPRGDEF_H

#define PACKAGE						PACKAGE_NAME
#define VERSION						PACKAGE_VERSION
#define UNIXNAME					PACKAGE
#define SHORTNAME					"Night Light IRC Proxy"
#define LONGNAME					"Night Light Internet Relay Chat Proxy Server Daemon"
#define DESCRIPTION					"Internet Relay Chat Proxy"
#define AUTHORNAME					"Jonas Kvinge"
#define AUTHORMAIL					"jonas@night-light.net"
#define URL						"http://www.ircproxy.night-light.net/"
#define COPYRIGHT					"Copyright (C) 1997-2003 Jonas Kvinge, all rights reserved."
#define STARTUPLN1					LONGNAME " v" VERSION
#define STARTUPLN2					COPYRIGHT

#define ACCESS_CONFFILE					"access.conf"
#define LISTEN_CONFFILE					"listen.conf"
#define USER_CONFFILE					"user.conf"
#define CONN_CONFFILE					"conn.conf"
#define IDENT_CONFFILE					"ident.conf"

#define MAINFILE					"ircproxy.log"
#define ERRORFILE					"ircproxy-error.log"
#define DEBUGFILE					"ircproxy-debug.log"

#define NLPRGSEC					3
#define NLPRGUSEC					0

#define ARES						TRUE

#define EXITTTL						5
#define FLUSHTIME					45

#ifndef SOMAXCONN
  #define SOMAXCONN 64
#endif

#define IRCP_USER_HOST(X)				(((X->ListenS != NULL) && (X->ListenS->HostIPH != 0)) ? X->ListenS->Host : HOSTNAME)
#define IRCP_USER_NICK(X)				(((X->ConnS != NULL) && (Conn_IsWelcome(X->ConnS))) ? X->ConnS->IRCNick : "*")

#ifndef NBLOCK_SYSV
  #ifndef NBLOCK_BSD
    #ifndef NBLOCK_POSIX
      #define NBLOCK_POSIX 1
    #endif
  #endif
#endif


#if !USER_CONF && !HAVE_GETPWNAM && !HAVE_GETSPNAM && !HAVE_GETUSERPW && !HAVE_GETSPWNAM
  #error "This system does not seem to have getpwnam(), getspnam(), getuserpw() or getspwnam()."
  #error "One of those functions are required to retrive system passwords."
  #error "To get this program to work on this system please define USER_CONF in make config."
  #error "Please report this error the same way you report a bug."
#endif


#endif
