/*
 * ----------------------------------------------------------------
 * Night Light Standard Defines (nlstddef.h)
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (12.08.2001)
 *
 */

#ifdef NLSTDDEF_H
#warning "nlstddef.h already included."
#else
#define NLSTDDEF_H


/* DEFINES */

#ifndef TRUE
  #define TRUE						1
#endif
#ifndef FALSE
  #define FALSE						0
#endif

#define SUCCESS						0
#define ERROR						-1

#define FOREVER						-1
#define NEVER						0
#define NONE						-1

#define FD_NONE						-1

#define HOST_UNRESOLVED					"<unresolved>"

#define UNKNOWNUSER					"<unknown>"
#define UNKNOWNHOST					"<unknown>"

#define SERVER_PORT_MIN					1
#define SERVER_PORT_MAX					1023

#define CLIENT_PORT_MIN					1024
#define CLIENT_PORT_MAX					0xFFFF

#define PASSWD_FILE					"/etc/passwd"
#define GROUP_FILE					"/etc/group"

#define FAKELOOP for (FakeLoop = TRUE ; FakeLoop == TRUE ; FakeLoop = FALSE)
#define FOREVERLOOP while(TRUE)

#ifndef __FILE__
  #define __FILE__ "unknown"
#endif
#ifndef __LINE__
  #define __LINE__ "unknown"
#endif
#ifndef __FUNCTION__
  #define __FUNCTION__ "unknown"
#endif

#ifndef INADDR_NONE
  #define INADDR_NONE 0xffffffff
#endif

#ifndef MSG_NOSIGNAL
  #define MSG_NOSIGNAL 0
#endif

#define PRINT_SIZE_T					signed long int
#define PRINT_PID_T					unsigned long int
#define PRINT_TIME_T					signed long int
#define PRINT_UID_T					unsigned long int
#define PRINT_GID_T					unsigned long int

#if WIN32
  #define LINEFEED					"\r\n"
#else
  #define LINEFEED					"\n"
#endif

#if !HAVE_SIZE_T
  typedef int size_t;
#endif

#if !HAVE_PID_T
  typedef int pid_t;
#endif

#if !HAVE_UID_T
  typedef long uid_t;
#endif

#if !HAVE_GID_T
  typedef long gid_t;
#endif

#if !HAVE_SOCKLEN_T
  typedef size_t socklen_t;
#endif

#if !HAVE_SETEUID
  #define seteuid setuid
#endif
#if !HAVE_SETEGID
  #define setegid setgid
#endif

#if OS_BSD || OS_LINUX || OS_WIN32 || WIN32
  #define accept_addrlen_type socklen_t
  #define getsockopt_optlen_type socklen_t
  #define getsockname_namelen_type socklen_t
  #define getpeername_namelen_type socklen_t
#elif OS_SOLARIS
  #define accept_addrlen_type socklen_t
  #define getsockopt_optlen_type int
  #define getsockname_namelen_type socklen_t
  #define getpeername_namelen_type socklen_t
#elif OS_AIX
  #define accept_addrlen_type int
  #define getsockopt_optlen_type int
  #define getsockname_namelen_type socklen_t
  #define getpeername_namelen_type socklen_t
#elif OS_HPUNIX
  #define accept_addrlen_type int
  #define getsockopt_optlen_type int
  #define getsockname_namelen_type int
  #define getpeername_namelen_type int
#elif OS_OSF1
  #define accept_addrlen_type int
  #define getsockopt_optlen_type int
  #define getsockname_namelen_type int
  #define getpeername_namelen_type int
#else
  #define accept_addrlen_type socklen_t
  #define getsockopt_optlen_type socklen_t
  #define getsockname_namelen_type socklen_t
  #define getpeername_namelen_type socklen_t
#endif

#if HAVE_SNPRINTF
  #if !HAVE_DECL_SNPRINTF || OS_OSF1
    int snprintf(char *str, size_t size, const char *format, ...);
  #endif
#else
  #warning "This system does not have sprintf(). Using sprintf() for snprintf()!"
  #define snprintf(S, Z, F, ...) sprintf(S, F, ...)
#endif

#if HAVE_VSNPRINTF
  #if !HAVE_DECL_VSNPRINTF || OS_OSF1
    int vsnprintf(char *str, size_t size, const char *format, va_list ap);
  #endif
#else
  #warning "This system does not have vsprintf(). Using vsprintf() for vsnprintf()!"
  #define vsnprintf(S, Z, F, ...) vsprintf(S, F, ...)
#endif

#if !HAVE_INET_ATON
  #if HAVE_INET_PTON
    #define inet_aton(C, A) inet_pton(AF_INET, C, A)
  #else
    #error "This system does not have int_aton() or inet_pton()."
  #endif
#endif

/* MACROS */

#undef FREE
#define FREE(x) \
                free((x)); \
                (x) = NULL

#define TestPrint(X) sysprint(BITMASK_DEBUG_GENERAL, "File: %s - Line: %d - Function %s() - %s", __FILE__, __LINE__, __FUNCTION__, (X))

/* VARAIBLES */

#if defined(MAIN_C) || defined(MKPASSWD_C)
  time_t NOW = 0;
  unsigned short int FakeLoop = TRUE;
#else
  extern time_t NOW;
  extern unsigned short int FakeLoop;
#endif


/* AERRNO DEFINES */

#define AESUCCESS					0
#define AEINVALID					1
#define AEEXISTS					2
#define AEMALLOC					3
#define AENOMATCH					4
#define AENORESOURCE					5
#define AEINPROGRESS					6


/* HOST DEFINES */

#define HOSTRESOLVING					1
#define HOSTTOIP					2
#define HOSTIPTONAME					4
#define HOSTNAMETOIP					8
#define HOSTRESOLVED					16


/* HOST MACROS */

#define Host_SetResolving(x)				((x) |= HOSTRESOLVING)
#define Host_SetHostToIP(x)				((x) |= HOSTTOIP)
#define Host_SetHostIPToName(x)				((x) |= HOSTIPTONAME)
#define Host_SetHostNameToIP(x)				((x) |= HOSTNAMETOIP)
#define Host_SetResolved(x)				((x) |= HOSTRESOLVED)

#define Host_ClearResolving(x)				((x) &= ~HOSTRESOLVING)
#define Host_ClearHostToIP(x)				((x) &= ~HOSTTOIP)
#define Host_ClearHostIPToName(x)			((x) &= ~HOSTIPTONAME)
#define Host_ClearHostNameToIP(x)			((x) &= ~HOSTNAMETOIP)
#define Host_ClearResolved(x)				((x) &= ~HOSTRESOLVED)

#define Host_IsResolving(x)				((x) & HOSTRESOLVING)
#define Host_IsHostToIP(x)				((x) & HOSTTOIP)
#define Host_IsHostIPToName(x)				((x) & HOSTIPTONAME)
#define Host_IsHostNameToIP(x)				((x) & HOSTNAMETOIP)
#define Host_IsResolved(x)				((x) & HOSTRESOLVED)


#endif
