/*
 * ----------------------------------------------------------------
 * Night Light System Functions Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (23.08.2001)
 *
 */

#ifdef SYSCALLS_H
#warning "syscalls.h already included."
#else
#define SYSCALLS_H


/* VARIABLES - JONAS (18.07.2001) */

#ifdef SYSCALLS_C
  unsigned short int aerrno = SUCCESS;
#else
  extern signed short int aerrno;
#endif


/* STRUCTURES - JONAS (18.07.2001) */

struct PrintMode_Struct {

  const char *Name;
  const unsigned long int Bitmask;
  const unsigned short int Level;
  const char *Description;

};

struct PrintFile_Struct {

  char *Name;
  unsigned long int Bitmask;
  FILE *FilePT;

};


/* FUNCTION PROTOTYPES - JONAS (18.07.2001) */

void sysinit(void);
#if !WIN32
void sysinitid(void);
signed long int sysseteuidnormal(void);
signed long int sysseteuid(const uid_t UID);
signed long int sysseteuidbyuser(const char *const UserPT);
#endif
void sysinitfiles(void);
void sysclosefiles(void);
void sysopenfiles_fg(void);
#if !WIN32
void sysopenfiles_bg(void);
#endif
void sysflushfiles(void);
#if !WIN32
void syscheckpid(void);
void syswritepid(void);
#endif
void syssetsignals(void);
void syshandlesignal(int Signal);
#if !WIN32
void sysfork(void);
#endif
void sysprint(const unsigned long int Bitmask, const char *const LinePT, ...) __attribute__ ((format (printf, 2, 3)));
void sysrehash(void);
void systerm(void);
signed short int sysrun(const char *const CmdPT, char *ResultPT);
#if !WIN32
uid_t sysgetuidfromuser(const char *const UserPT);
char *sysgetnamefromuser(const char *const UserPT);
char *sysgethomedirfromuser(const char *const UserPT);
gid_t sysgetgidfromgroup(const char *const GroupPT);
#endif
void syscleanup(void);

#endif
