/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy User Configuration System Header
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (18.07.2001)
 *
 */

#ifdef USER_CONF_H
#warning "user_conf.h already included."
#else
#define USER_CONF_H

#if !USER_CONF
  #error "USER_CONF not defined."
#endif

/* STRUCTURES - JONAS (18.07.2001) */

struct UserConf_Struct {

  char *User;
  char *Pass;

  struct UserConf_Struct *Next;
  struct UserConf_Struct *Prev;

};

/* FUNCTION PROTOTYPES - JONAS (18.07.2001) */

signed long int user_conf_read(void);
struct UserConf_Struct *user_conf_add(const char *const UserPT, const char *const PassPT);
void user_conf_rem(struct UserConf_Struct *UserConf);
struct UserConf_Struct *user_conf_get(const char *const UserPT);
void user_conf_remall(void);

#endif
