/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Client Authentication System
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (27.02.2002)
 *
 */

#define CLIENT_AUTH_C

#define NEED_SYS_TYPES_H 1		/* Extra types */
#define NEED_SYS_PARAM_H 1		/* Some systems need this */
#define NEED_LIMITS_H 0			/* Kernel limits */
#define NEED_STDARG_H 1			/* va_list, etc */
#define NEED_ERRNO_H 1			/* errno */
#define NEED_CTYPE_H 0			/* isdigit(), etc */
#define NEED_NETINET_IN_H 0		/* in_addr, sockaddr_in, etc */
#define NEED_ARPA_INET_H 0		/* inet_ntoa(), inet_aton(), etc */
#define NEED_STDIO_H 1			/* Standard C UNIX functions */
#define NEED_STDLIB_H 1			/* malloc(), exit(), atoi(), etc */
#define NEED_TIME_H 1			/* time(), etc */
#define NEED_SYSCTL_H 0			/* sysctl(), etc */
#define NEED_SYS_STAT_H 0		/* chmod(), mkdir(), etc */
#define NEED_SYS_UIO_H 0		/* iovec, etc */
#define NEED_FCNTL_H 1			/* open(), creat(), fcntl(), etc */
#define NEED_SYS_IOCTL_H 0		/* ioctl(), etc */
#define NEED_SYS_FILIO_H 0		/* Solaris need this for ioctl(), etc */
#define NEED_UNISTD_H 1			/* Unix standard functions */
#define NEED_STRING_H 1			/* C string functions */
#define NEED_SIGNAL_H 0			/* Signal functions */
#define NEED_SYS_SOCKET_H 0		/* Socket functions */
#define NEED_NETDB_H 0			/* Network database functions */
#define NEED_ARPA_NAMESER_H 0		/* Nameserver definitions */
#define NEED_GETUSERPW_HEADERS 1 	/* Functions to retrive system passwords */

#include "includes.h"

#include "client_auth.h"
#include "matchpass.h"

#if USER_CONF
  #include "user_conf.h"
#endif

/* VARIABLES - JONAS (31.07.2001) */

#if USER_CONF
  extern struct UserConf_Struct *UserConf_Head;
#else
  extern uid_t UID_Current;
  extern uid_t EUID_Current;
  extern uid_t UID_Normal;
  extern uid_t EUID_Normal;
#endif

/* CLIENT_AUTHCHECK FUNCTION - JONAS (27.02.2002) */

unsigned short int client_authcheck(const char *const UserPT, const char *const PassPT) {

#if USER_CONF
  struct UserConf_Struct *UserConf = NULL;
#else
  char *CryptPassPT = NULL;
#endif

  assert(UserPT != NULL);
  assert(PassPT != NULL);

#if USER_CONF

#if 0
  #warning "Seperate user configuration file will be used for user authentication! -- THIS IS NOT A ERROR --"
#endif

  for (UserConf = UserConf_Head ; UserConf != NULL ; UserConf = UserConf->Next) {
    if ((strcmp(UserConf->User, UserPT) == FALSE) && (matchpass(UserConf->Pass, PassPT) == TRUE)) {
      aerrno = AESUCCESS;
      return(AESUCCESS);
    }
  }

#else

#if 0
  #warning "Retriving password for user authentication from the system! -- THIS IS NOT A ERROR --"
#endif

  #if !ROOT
    #warning "ATTENTION! ATTENTION! ATTENTION!"
    #warning "YOU ARE COMPILING IRCPROXY WITHOUT THE ROOT OPTION AND WITHOUT A SEPERATE USER CONFIGURATION FILE. MOST SYSTEMS DOES NOT ALLOW TO RETRIVE SYSTEM PASSWORDS UNLESS YOU ARE ROOT! AUTHENTICATION WILL PROBABLY NOT WORK!!! YOU SHOULD EITHER ENABLE 'USER_CONF' OR 'ROOT' IN 'MAKE CONFIG'."
    #warning "."
  #endif

  if ((UID_Current == 0) && (EUID_Current != 0)) { sysseteuid(0); }

  #if HAVE_GETPWNAM /* Traditional UNIX */

#if 0
    #warning "Using getpwnam() - Traditional UNIX -- THIS NOT A ERROR --"
#endif

    FAKELOOP {
      struct passwd *PasswdPT = NULL;

      PasswdPT = getpwnam(UserPT);
      if (PasswdPT == NULL) {
        if (EUID_Current != EUID_Normal) { sysseteuidnormal(); }
        aerrno = AENOMATCH;
        return(AENOMATCH);
      }
      CryptPassPT = PasswdPT->pw_passwd;
    }

  #elif HAVE_GETSPNAM /* Sun Shadow System */

#if 0
    #warning "Using getspnam() - Sun Shadow System -- THIS NOT A ERROR --"
#endif

    FAKELOOP {
      struct spwd *PasswdPT = NULL;

      PasswdPT = getspnam(UserPT);
      if (PasswdPT == NULL) {
        if (EUID_Current != EUID_Normal) { sysseteuidnormal(); }
        aerrno = AENOMATCH;
        return(AENOMATCH);
      }
      CryptPassPT = PasswdPT->sp_pwdp;
    }

  #elif HAVE_GETUSERPW /* AIX */

#if 0
    #warning "Using getuserpw() - AIX -- THIS NOT A ERROR --"
#endif

    FAKELOOP {
      struct userpw *PasswdPT = NULL;

      PasswdPT = getuserpw(UserPT);
      if (PasswdPT == NULL) {
        if (EUID_Current != EUID_Normal) { sysseteuidnormal(); }
        aerrno = AENOMATCH;
        return(AENOMATCH);
      }
      CryptPassPT = Passwd->upw_passwd;
    }

  #elif HAVE_GETSPWNAM /* HP UNIX */

#if 0
    #warning "Using getspwnam() HP UNIX -- THIS NOT A ERROR --"
#endif

    FAKELOOP {
      struct pr_passwd *PasswdPT = NULL;

      PasswdPT = getspwnam(UserPT);
      if (PasswdPT == NULL) {
        if (EUID_Current != EUID_Normal) { sysseteuidnormal(); }
        aerrno = AENOMATCH;
        return(AENOMATCH);
      }
      CryptPassPT = PasswdPT->ufld.fd_encrypt;
    }

  #else

    #error "This system does not seem to have getpwnam(), getspnam(), getuserpw() or getspwnam()."
    #error "One of those functions are required to retrive system passwords."
    #error "To get this program to work on this system please define USER_CONF in make config."
    #error "Please report this error the same way you report a bug."

  #endif

  if (EUID_Current != EUID_Normal) { sysseteuidnormal(); }

  assert(CryptPassPT != NULL);
    
  if (matchpass(CryptPassPT, PassPT) == TRUE) {
     aerrno = AESUCCESS;
     return(AESUCCESS);
  }
  else {
    aerrno = AENOMATCH;
    return(AENOMATCH);
  }
#endif

  aerrno = AENOMATCH;
  return(AENOMATCH);

}

