/*
 * ----------------------------------------------------------------
 * Night Light IRC Proxy Connection Ignore System
 * ----------------------------------------------------------------
 * Copyright (C) 1997-2003 Jonas Kvinge <jonas@night-light.net>
 * All rights reserved.
 *
 * This code is a result of thousands of hours of work by
 * Jonas Kvinge <jonas@night-light.net>
 *
 * You may not create derivative works based on this code.
 *
 * Modified source code or binaries compiled from modified source
 * code distributed in any shape or form without the authors
 * permission is expressly forbidden.
 *
 * This code is provided without warranty of any kind.
 *
 * Under no circumstances and under no legal contract or otherwise
 * shall Jonas Kvinge be liable to you or any other person for any
 * damages, computer failure, malfunction or any other damages or
 * losses.
 *
 * Last modified by:
 * Jonas Kvinge (07.07.2003)
 *
 */

#define CONN_IGNORE_C

#define NEED_SYS_TYPES_H 1		/* Extra types */
#define NEED_SYS_PARAM_H 1		/* Some systems need this */
#define NEED_LIMITS_H 0			/* Kernel limits */
#define NEED_STDARG_H 1			/* va_list, etc */
#define NEED_ERRNO_H 1			/* errno */
#define NEED_CTYPE_H 1			/* isdigit(), etc */
#define NEED_NETINET_IN_H 0		/* in_addr, sockaddr_in, etc */
#define NEED_ARPA_INET_H 0		/* inet_ntoa(), inet_aton(), etc */
#define NEED_STDIO_H 1			/* Standard C UNIX functions */
#define NEED_STDLIB_H 1			/* malloc(), exit(), atoi(), etc */
#define NEED_TIME_H 1			/* time(), etc */
#define NEED_SYSCTL_H 0			/* sysctl(), etc */
#define NEED_SYS_STAT_H 0		/* chmod(), mkdir(), etc */
#define NEED_SYS_UIO_H 0		/* iovec, etc */
#define NEED_FCNTL_H 1			/* open(), creat(), fcntl(), etc */
#define NEED_SYS_IOCTL_H 0		/* ioctl(), etc */
#define NEED_SYS_FILIO_H 0		/* Solaris need this for ioctl(), etc */
#define NEED_UNISTD_H 1			/* Unix standard functions */
#define NEED_STRING_H 1			/* C string functions */
#define NEED_SIGNAL_H 0			/* Signal functions */
#define NEED_SYS_SOCKET_H 0		/* Socket functions */
#define NEED_NETDB_H 0			/* Network database functions */
#define NEED_ARPA_NAMESER_H 0		/* Nameserver definitions */
#define NEED_GETUSERPW_HEADERS 0 	/* Functions to retrive system passwords */

#include "includes.h"

#include "irc.h"

#include "conn_io.h"
#include "conn_ignore.h"

/* CONN_ADDIGNORE FUNCTION - JONAS (22.07.2001) */

struct Ignore_Struct *conn_addignore(struct Conn_Struct *ConnS, const char *const NUHPT) {

  struct Ignore_Struct *IgnoreS = NULL;
  struct Ignore_Struct *Ignore_NEW = NULL;

  assert(ConnS != NULL);
  assert(NUHPT != NULL);

  IgnoreS = conn_getignore(ConnS, NUHPT);
  if (IgnoreS != NULL) {
    aerrno = AEEXISTS;
    return(IgnoreS);
  }

  Ignore_NEW = malloc(sizeof(struct Ignore_Struct));
  if (Ignore_NEW == NULL) {
    aerrno = AEMALLOC;
    return(NULL);
  }

  memset(Ignore_NEW, 0, sizeof(struct Ignore_Struct));

  Ignore_NEW->NUH = strdup(NUHPT);
  if (Ignore_NEW->NUH == NULL) {
    free(Ignore_NEW);
    aerrno = AEMALLOC;
    return(NULL);
  }
  Ignore_NEW->ExpireTime = NOW + CONN_IGNORETTL;

  if (ConnS->Ignore_Head == NULL) {
    ConnS->Ignore_Head = Ignore_NEW;
    ConnS->Ignore_Tail = Ignore_NEW;
  }
  else {
    IgnoreS = ConnS->Ignore_Tail;
    IgnoreS->Next = Ignore_NEW;
    Ignore_NEW->Prev = IgnoreS;
    ConnS->Ignore_Tail = Ignore_NEW;
  }

  ConnS->NumIgnores++;

  aerrno = AESUCCESS;
  return(Ignore_NEW);

}

/* CONN_REMIGNORE FUNCTION - JONAS (01.08.2001) */

void conn_remignore(struct Conn_Struct *ConnS, struct Ignore_Struct *IgnoreS) {

  assert(ConnS != NULL);
  assert(IgnoreS != NULL);

  if (IgnoreS->Prev == NULL) { ConnS->Ignore_Head = IgnoreS->Next; }
  else { IgnoreS->Prev->Next = IgnoreS->Next; }

  if (IgnoreS->Next == NULL) { ConnS->Ignore_Tail = IgnoreS->Prev; }
  else { IgnoreS->Next->Prev = IgnoreS->Prev; }

  free(IgnoreS->NUH);
  free(IgnoreS);

  ConnS->NumIgnores--;

}

/* CONN_GETIGNORE - JONAS (06.10.2000) */

struct Ignore_Struct *conn_getignore(struct Conn_Struct *ConnS, const char *const NUHPT) {

  struct Ignore_Struct *IgnoreS = NULL;

  assert(ConnS != NULL);
  assert(NUHPT != NULL);

  for (IgnoreS = ConnS->Ignore_Head ; IgnoreS != NULL ; IgnoreS = IgnoreS->Next) {
    if (strwm(IgnoreS->NUH, NUHPT) == TRUE) {
      aerrno = AESUCCESS;
      return(IgnoreS);
    }
  }
  aerrno = AENOMATCH;
  return(NULL);

}

/* CONN_IGNOREEXPIRE - JONAS (06.10.2000) */

void conn_ignoreexpire(struct Conn_Struct *ConnS) {

  struct Ignore_Struct *IgnoreS = NULL;
  struct Ignore_Struct *Ignore_DEL = NULL;

  assert(ConnS != NULL);

  ConnS->IgnoreExpireTime = (NOW + CONN_IGNOREEXPIRETIME);

  for (IgnoreS = ConnS->Ignore_Head ; IgnoreS != NULL ;) {
    if (IgnoreS->ExpireTime < NOW) {
      Ignore_DEL = IgnoreS;
      IgnoreS = IgnoreS->Next;
      conn_remignore(ConnS, Ignore_DEL);
      continue;
    }
    IgnoreS = IgnoreS->Next;
  }

}

/* CONN_REMIGNORES - JONAS (06.10.2000) */

void conn_remignores(struct Conn_Struct *ConnS) {

  assert(ConnS != NULL);

  while (ConnS->Ignore_Head != NULL) { conn_remignore(ConnS, ConnS->Ignore_Head); }
  assert(ConnS->NumIgnores == 0);

}

