# -*- Mode: Python -*-
# vi:si:et:sw=4:sts=4:ts=4
#
# Istanbul - a desktop session recorder
# Copyright (C) 2005 Zaheer Abbas Merali (zaheerabbas at merali dot org)
# All rights reserved.

# This file may be distributed and/or modified under the terms of
# the GNU General Public License version 2 as published by
# the Free Software Foundation.
# This file is distributed without any warranty; without even the implied
# warranty of merchantability or fitness for a particular purpose.
# See "LICENSE.GPL" in the source distribution for more information.

# Headers in this file shall remain intact.

import gtk
import gtk.glade
import os
import gst

from istanbul.configure import config

class IstanbulPrefs:
    def __init__(self, main):
        self.main = main
        self.xml = gtk.glade.XML(os.path.join(config.gladedir, 'prefs.glade'))
        self.prefs = self.xml.get_widget('prefs')
        self.prefs.hide_all()

        # get resolution
        screen = self.main.tray_event_box.get_screen()
        widthAdjustment = gtk.Adjustment(screen.get_width(), 1.0, screen.get_width(), 1.0, 100.0, 100.0)
        heightAdjustment = gtk.Adjustment(screen.get_height(), 1.0, screen.get_height(), 1.0, 100.0, 100.0)
        self.xml.get_widget('widthSpin').set_adjustment(widthAdjustment)
        self.xml.get_widget('heightSpin').set_adjustment(heightAdjustment)
        
        # set default values
        self.xml.get_widget('filenameEntry').set_text('%s/desktop-recording.ogg' % os.environ['HOME'])
        
        # handle button presses
        self.prefs.connect('response',self.response_cb)

        # check for shout2send plugin
        #if it doesnt exist desensitise the checkbox
        if gst.element_factory_make('shout2send') == None:
            self.xml.get_widget('stream_icecast2').set_sensitive(False)

        # handle checkbox yes/no
        self.xml.get_widget('save').connect('toggled', self.save_toggled_cb)
        self.xml.get_widget('stream_icecast2').connect('toggled', self.icecast_toggled_cb)
        self.xml.get_widget('encode_later').connect('toggled', self.encodelater_toggled_cb)

    def show_all(self):
        self.prefs.show_all()

    def response_cb(self, arg1, arg2):
        self.prefs.hide_all()

    def save_toggled_cb(self, button):
        state = button.get_active()
        self.xml.get_widget('filenameLabel').set_sensitive(state)
        self.xml.get_widget('filenameEntry').set_sensitive(state)
        self.xml.get_widget('encode_later').set_senisitive(state)

    def icecast_toggled_cb(self, button):
        state = button.get_active()
        self.xml.get_widget('serverLabel').set_sensitive(state)
        self.xml.get_widget('shout_ip').set_sensitive(state)
        self.xml.get_widget('portLabel').set_sensitive(state)
        self.xml.get_widget('shout_port').set_sensitive(state)
        self.xml.get_widget('mountLabel').set_sensitive(state)
        self.xml.get_widget('shout_mount').set_sensitive(state)
        self.xml.get_widget('passwordLabel').set_sensitive(state)
        self.xml.get_widget('shout_password').set_sensitive(state)

    def encodelater_toggled_cb(self, button):
        state = button.get_active()
        if state:
            # de-sensitise icecast
            self.xml.get_widget('stream_icecast2').set_sensitive(False)
            self.xml.get_widget('serverLabel').set_sensitive(False)
            self.xml.get_widget('shout_ip').set_sensitive(False)
            self.xml.get_widget('portLabel').set_sensitive(False)
            self.xml.get_widget('shout_port').set_sensitive(False)
            self.xml.get_widget('mountLabel').set_sensitive(False)
            self.xml.get_widget('shout_mount').set_sensitive(False)
            self.xml.get_widget('passwordLabel').set_sensitive(False)
            self.xml.get_widget('shout_password').set_sensitive(False)

        else:
            # make icecast sensitive
            self.xml.get_widget('stream_icecast2').set_sensitive(True)
            if self.xml.get_widget('stream_icecast2').get_active():
                self.xml.get_widget('serverLabel').set_sensitive(True)
                self.xml.get_widget('shout_ip').set_sensitive(True)
                self.xml.get_widget('portLabel').set_sensitive(True)
                self.xml.get_widget('shout_port').set_sensitive(True)
                self.xml.get_widget('mountLabel').set_sensitive(True)
                self.xml.get_widget('shout_mount').set_sensitive(True)
                self.xml.get_widget('passwordLabel').set_sensitive(True)
                self.xml.get_widget('shout_password').set_sensitive(True)

