'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) ScrolledListBox.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS scrolledcanvas iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
scrolledcanvas \- Create and manipulate scrolled canvas widgets
.SH SYNOPSIS
\fBscrolledcanvas\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- Labeledwidget <- Scrolledwidget <- Scrolledcanvas
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveBackground\fR	\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR
\fBexportSelection\fR	\fBfont\fR	\fBforeground\fR	\fBhighlightColor\fR
\fBhighlightThickness\fR	\fBinsertBorderWidth\fR	\fBinsertOffTime\fR	\fBinsertOnTime\fR
\fBinsertWidth\fR	\fBrelief\fR	\fBselectBackground\fR	\fBselectBorderWidth\fR
\fBselectForeground\fR	
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBcloseEnough\fR	\fBconfine\fR	\fBscrollRegion\fR	\fBxScrollIncrement\fR
\fByScrollIncrement\fR
.fi
.LP
See the "canvas" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBactiveRelief\fR	\fBelementBorderWidth\fR	\fBjump\fR	\fBtroughColor\fR
.fi
.LP
See the "scrollbar" widget manual entry for details on the above
associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBdisabledForeground\fR	\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR
\fBlabelMargin\fR	\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR
\fBstate\fR
.fi
.LP
See the "labeledwidget" class manual entry for details on the inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBautoMargin\fR
Class:	\fBAutoMargin\fR
Command-Line Switch:	\fB-automargin\fR
.fi
.IP
Specifies the autoresize extra margin to reserve.  This option is only
effective with autoresize turned on.  The default is 10.
.LP
.nf
Name:	\fBautoResize\fR
Class:	\fBAutoResize\fR
Command-Line Switch:	\fB-autoresize\fR
.fi
.IP
Automatically adjusts the scrolled region to be the bounding 
box covering all the items in the canvas following the execution 
of any method which creates or destroys items.  Thus, as new 
items are added, the scrollbars adjust accordingly.
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-height\fR
.fi
.IP
Specifies the height of the scrolled canvas widget in any of the forms 
acceptable to \fBTk_GetPixels\fR.  The default height is 30 pixels.
.LP
.nf
Name:	\fBhscrollMode\fR
Class:	\fBScrollMode\fR
Command-Line Switch:	\fB-hscrollmode\fR
.fi
.IP
Specifies the the display mode to be used for the horizontal
scrollbar: \fBstatic, dynamic,\fR or \fBnone\fR.  In static mode, the 
scroll bar is displayed at all times.  Dynamic mode displays the
scroll bar as required, and none disables the scroll bar display.  The 
default is static.
.LP
.nf
Name:	\fBsbWidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-sbwidth\fR
.fi
.IP
Specifies the width of the scrollbar in any of the forms acceptable 
to \fBTk_GetPixels\fR.  The default width is 15 pixels..
.LP
.nf
Name:	\fBscrollMargin\fR
Class:	\fBScrollMargin\fR
Command-Line Switch:	\fB-scrollmargin\fR
.fi
.IP
Specifies the distance between the canvas and scrollbar in any of the 
forms acceptable to \fBTk_GetPixels\fR.  The default is 3 pixels.
.LP
.nf
Name:	\fBtextBackground\fR
Class:	\fBBackground\fR
Command-Line Switch \fB-textbackground\fR
.fi
.IP
Specifies the background color for the canvas.  This allows the background 
within the canvas to be different from the normal background color.
.LP
.nf
Name:	\fBvscrollMode\fR
Class:	\fBScrollMode\fR
Command-Line Switch:	\fB-vscrollmode\fR
.fi
.IP
Specifies the the display mode to be used for the vertical
scrollbar: \fBstatic, dynamic,\fR or \fBnone\fR.  In static mode, the 
scroll bar is displayed at all times.  Dynamic mode displays the 
scroll bar as required, and none disables the scroll bar display.  The 
default is static.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-width\fR
.fi
.IP
Specifies the width of the scrolled canvas widget in any of the forms 
acceptable to \fBTk_GetPixels\fR.  The default height is 30 pixels.
.BE

.SH DESCRIPTION
.PP
The \fBscrolledcanvas\fR command creates 
a scrolled canvas with additional options to manage
horizontal and vertical scrollbars.  This includes options to control
which scrollbars are displayed and the method, i.e. statically or
dynamically.

.SH "METHODS"
.PP
The \fBscrolledcanvas\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for scrolledcanvas widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBaddtag\fR	\fBbbox\fR	\fBbind\fR	\fBcanvasx\fR
\fBcanvasy\fB	\fBcoords\fR	\fBcreate\fR	\fBdchars\fR
\fBdelete\fR	\fBdtag\fR	\fBfind\fR	\fBfocus\fR
\fBgettags\fR	\fBicursor\fR	\fBindex\fR	\fBinsert\fR
\fBitemconfigure\fR	\fBlower\fR	\fBmove\fR	\fBpostscript\fR
\fBraise\fR	\fBscale\fR	\fBscan\fR	\fBselect\fR
\fBtype\fR	\fBxview\fR	\fByview\fR
.fi
.LP
See the "canvas" manual entry for details on the associated methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBscrolledcanvas\fR
command.
.TP
\fIpathName \fBchildsite\fR
Returns the child site widget path name.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBscrolledcanvas\fR
command.
.TP
\fIpathName \fBjustify \fIdirection\fR
Justifies the canvas contents via the scroll bars in one of four directions:
\fBleft\fR, \fBright\fR, \fBtop\fR, or \fBbottom\fR.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBcanvas\fR
Class:	\fBCanvas\fR
.fi
.IP
The canvas component is the canvas widget.  See the "canvas" widget 
manual entry for details on the canvas component item.
.LP
.nf
Name:	\fBhorizsb\fR
Class:	\fBScrollbar\fR
.fi
.IP
The horizsb component is the horizontal scroll bar.  See the "ScrollBar" 
widget manual entry for details on the horizsb component item.
.LP
.nf
Name:	\fBvertsb\fR
Class:	\fBScrollbar\fR
.fi
.IP
The vertsb component is the vertical scroll bar.  See the "ScrollBar" widget 
manual entry for details on the vertsb component item.
.fi

.SH EXAMPLE
.DS
  scrolledcanvas .sc 

  .sc create rectangle 100 100 400 400 -fill red
  .sc create rectangle 300 300 600 600 -fill green
  .sc create rectangle 200 200 500 500 -fill blue

  pack .sc -padx 10 -pady 10 -fill both -expand yes
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
scrolledcanvas, canvas, widget
