'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) spinner.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS spinner iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
spinner \- Create and manipulate a spinner widget
.SH SYNOPSIS
\fBspinner\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- Labeledwidget <- Spinner
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR	\fBexportSelection\fR
\fBforeground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR	\fBinsertBackground\fR
\fBinsertBorderWidth\fR	\fBinsertOffTime\fR	\fBinsertOnTime\fR	\fBinsertWidth\fR
\fBjustify\fR	\fBrelief\fR	\fBselectBackground\fR	\fBselectBorderWidth\fR
\fBselectForeground\fR	\fBtextVariable\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBshow\fR	\fBstate\fR
.fi
.LP
See the "entry" manual entry for details on the associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBchildSitePos\fR	\fBcommand\fR	\fBfixed\fR	\fBfocusCommand\fR
\fBinvalid\fR	\fBtextBackground\fR	\fBtextFont\fR	\fBvalidate\fR
\fBwidth\fR
.fi
.LP
See the "entryfield" widget manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBdisabledForeground\fR	\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR
\fBlabelMargin\fR	\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR
\fBstate\fR
.fi
.LP
See the "labeledwidget" widget manual entry for details on the above
inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBarrowOrient\fR
Class:	\fBOrient\fR
Command-Line Switch:	\fB-arroworient\fR
.fi
.IP
Specifies placement of arrow buttons: \fBhorizontal\fR or \fBvertical\fR.
The default is vertical.
.LP
.nf
Name:	\fBdecrement\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-decrement\fR
.fi
.IP
Tcl command to be executed when down arrow is pressed.
.LP
.nf
Name:	\fBincrement\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-increment\fR
.fi
.IP
Tcl command to be executed when up arrow is pressed.
.LP
.nf
Name:	\fBrepeatDelay\fR
Class:	\fBRepeatDelay\fR
Command-Line Switch:	\fB-repeatdelay\fR
.fi
.IP
Specifies the initial delay in milliseconds before the spinner repeat action 
on the arrow buttons engages.  The default is 300 milliseconds.
.LP
.nf
Name:	\fBrepeatInterval\fR
Class:	\fBRepeatInterval\fR
Command-Line Switch:	\fB-repeatinterval\fR
.fi
.IP
Specifies the repeat delay in milliseconds between selections of the arrow 
buttons.  A repeatinterval of 0 disables button repeat.  The default is 
100 milliseconds.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBspinner\fR command creates a spinner widget.  The spinner is 
comprised of an entryfield plus up and down arrow buttons. 
Arrows may be drawn horizontally or vertically.
.DE

.SH "METHODS"
.PP
The \fBspinner\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for spinner widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBdelete\fR	\fBget\fR	\fBicursor\fR	\fBindex\fR	
\fBinsert\fR	\fBscan\fR	\fBselection\fR	\fBxview\fR	
.fi
.LP
See the "entry" manual entry for details on the associated methods.
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBchildsite\fR	\fBclear\fR	\fBpeek\fR
.fi
.LP
See the "entryfield" manual entry for details on the associated methods.
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBspinner\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBspinner\fR
command.
.TP
\fIpathName \fBdown\fR
Derived classes may overload this method to specialize functionality.
.TP
\fIpathName \fBup\fR
Derived classes may overload this method to specialize functionality.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBdownarrow\fR
Class:	\fBCanvas\fR
.fi
.IP
The downarrow component is the downward pointing button of the spinner.  See
the "canvas" widget manual entry for details on the downarrow component item.
.LP
.nf
Name:	\fBuparrow\fR
Class:	\fBCanvas\fR
.fi
.IP
The uparrow component is the upward pointing button of the spinner.  See
the "canvas" widget manual entry for details on the uparrow component item.
.fi

.SH EXAMPLE
.DS
 set months {January February March April May June July \\
                 August September October November December}

 proc blockInput {char} {
     return 0
 }

 proc spinMonth {step} {
     global months

     set index [expr [lsearch $months [.sm get]] + $step]

     if {$index < 0} {set index 11}
     if {$index > 11} {set index 0}

     .sm delete 0 end
     .sm insert 0 [lindex $months $index]
 }

 spinner .sm -labeltext "Month : " -width 10 -fixed 10 -validate blockInput \\
             -decrement {spinMonth -1} -increment {spinMonth 1}
 .sm insert 0 January

 pack .sm -padx 10 -pady 10
.DE
.SH ACKNOWLEDGEMENTS:
.LP
Ken Copeland <ken@hilco.com>
.IP
10/18/95 - Added auto-repeat action to spinner arrow buttons.
.LP
.SH AUTHOR
Sue Yockey
.SH KEYWORDS
spinner, widget
